/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.palladiosimulator.envdyn.api.entity.bn.DynamicBayesianNetwork;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundRandomVariable;
import org.palladiosimulator.envdyn.environment.staticmodel.LocalProbabilisticNetwork;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.simexp.core.action.Reconfiguration;
import org.palladiosimulator.simexp.core.state.ArchitecturalConfiguration;
import org.palladiosimulator.simexp.core.state.SelfAdaptiveSystemState;
import org.palladiosimulator.simexp.core.state.SimulationRunnerHolder;
import org.palladiosimulator.simexp.core.statespace.SelfAdaptiveSystemStateSpaceNavigator;
import org.palladiosimulator.simexp.core.store.SimulatedExperienceStore;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivableEnvironmentalState;
import org.palladiosimulator.simexp.markovian.statespace.StateSpaceNavigator;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.DeltaIoTBaseEnvironemtalDynamics;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.DeltaIoTPartiallyEnvDynamics;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.DeltaIoTModelAccess;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import org.palladiosimulator.solver.core.models.PCMInstance;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.entity.Value;
import tools.mdsd.probdist.api.random.ISeedProvider;

public class DeltaIoTPartiallyEnvDynamics<R>
extends DeltaIoTBaseEnvironemtalDynamics<R> {
    private static final Logger LOGGER = Logger.getLogger(DeltaIoTPartiallyEnvDynamics.class);
    private final SelfAdaptiveSystemStateSpaceNavigator<PCMInstance, QVTOReconfigurator, R, List<InputValue<CategoricalValue>>> partiallyEnvProcess;

    public DeltaIoTPartiallyEnvDynamics(DynamicBayesianNetwork<CategoricalValue> dbn, SimulatedExperienceStore<QVTOReconfigurator, R> simulatedExperienceStore, DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess, Optional<ISeedProvider> seedProvider, SimulationRunnerHolder simulationRunnerHolder) {
        super(dbn, modelAccess, seedProvider);
        this.partiallyEnvProcess = this.createPartiallyEnvironmentalDrivenProcess(simulatedExperienceStore, simulationRunnerHolder);
    }

    public SelfAdaptiveSystemStateSpaceNavigator<PCMInstance, QVTOReconfigurator, R, List<InputValue<CategoricalValue>>> getEnvironmentProcess() {
        return this.partiallyEnvProcess;
    }

    private SelfAdaptiveSystemStateSpaceNavigator<PCMInstance, QVTOReconfigurator, R, List<InputValue<CategoricalValue>>> createPartiallyEnvironmentalDrivenProcess(SimulatedExperienceStore<QVTOReconfigurator, R> simulatedExperienceStore, SimulationRunnerHolder simulationRunnerHolder) {
        return new SelfAdaptiveSystemStateSpaceNavigator<PCMInstance, QVTOReconfigurator, R, List<InputValue<CategoricalValue>>>(this.envProcess, simulatedExperienceStore, simulationRunnerHolder){
            private final SNRCalculator snrCalculator;
            {
                this.snrCalculator = new SNRCalculator();
            }

            protected SelfAdaptiveSystemState<PCMInstance, QVTOReconfigurator, List<InputValue<CategoricalValue>>> determineStructuralState(StateSpaceNavigator.NavigationContext<QVTOReconfigurator> context) {
                LOGGER.info((Object)"Start with state transition.");
                long start = System.currentTimeMillis();
                QVToReconfiguration reconf = (QVToReconfiguration)QVToReconfiguration.class.cast(context.getAction().get());
                ArchitecturalConfiguration nextConfig = DeltaIoTPartiallyEnvDynamics.getCurrentArchitecture(context).apply((Reconfiguration)reconf);
                PerceivableEnvironmentalState<List<InputValue<CategoricalValue>>> currentEnvironment = DeltaIoTPartiallyEnvDynamics.getCurrentEnvironment(context);
                PerceivableEnvironmentalState<List<InputValue<CategoricalValue>>> nextEnvironment = this.determineNextEnvState(currentEnvironment, (ArchitecturalConfiguration<PCMInstance, QVTOReconfigurator>)nextConfig);
                long end = System.currentTimeMillis();
                LOGGER.info((Object)("Stop with state transition, took : " + (end - start) / 1000L));
                return DeltaIoTBaseEnvironemtalDynamics.asPcmState(context.getSource()).transitToNext(nextEnvironment, nextConfig);
            }

            private PerceivableEnvironmentalState<List<InputValue<CategoricalValue>>> determineNextEnvState(PerceivableEnvironmentalState<List<InputValue<CategoricalValue>>> envState, ArchitecturalConfiguration<PCMInstance, QVTOReconfigurator> pcmConf) {
                PerceivableEnvironmentalState nextEnvironment = DeltaIoTPartiallyEnvDynamics.this.envProcess.determineNextGiven(envState);
                this.adjustArchitecturalDependentVariables((PerceivableEnvironmentalState<List<InputValue<CategoricalValue>>>)nextEnvironment, pcmConf);
                return nextEnvironment;
            }

            private void adjustArchitecturalDependentVariables(PerceivableEnvironmentalState<List<InputValue<CategoricalValue>>> nextEnv, ArchitecturalConfiguration<PCMInstance, QVTOReconfigurator> archConfig) {
                List<InputValue<CategoricalValue>> inputValues = DeltaIoTPartiallyEnvDynamics.toInputs(nextEnv.getValue().getValue());
                for (InputValue<CategoricalValue> each : inputValues) {
                    if (!DeltaIoTPartiallyEnvDynamics.isSNRTemplate(each.getVariable())) continue;
                    LocalProbabilisticNetwork localNetwork = (LocalProbabilisticNetwork)LocalProbabilisticNetwork.class.cast(each.getVariable().eContainer());
                    GroundRandomVariable wiVariable = DeltaIoTPartiallyEnvDynamics.findWirelessInterferenceVariable(localNetwork);
                    LinkingResource link = (LinkingResource)LinkingResource.class.cast(wiVariable.getAppliedObjects().get(0));
                    AssemblyContext sourceMote = DeltaIoTPartiallyEnvDynamics.this.modelAccess.findSourceMote(link, archConfig);
                    double wirelessInterference = DeltaIoTPartiallyEnvDynamics.this.modelAccess.retrieveWirelessInterference(wiVariable, nextEnv);
                    int transmissionPower = DeltaIoTPartiallyEnvDynamics.this.modelAccess.retrieveTransmissionPower(sourceMote, link);
                    each.setValue((Value)this.computeSNR(each.getVariable(), wirelessInterference, transmissionPower));
                }
            }

            private CategoricalValue computeSNR(GroundRandomVariable variable, double wirelessInterference, int transmissionPower) {
                double snr = this.snrCalculator.calculateSNROf(variable, transmissionPower, wirelessInterference);
                return CategoricalValue.create((String)Double.toString(snr));
            }

            protected PerceivableEnvironmentalState<List<InputValue<CategoricalValue>>> determineInitial(ArchitecturalConfiguration<PCMInstance, QVTOReconfigurator> initialArch) {
                return DeltaIoTPartiallyEnvDynamics.this.envProcess.determineInitial();
            }

            class SNRCalculator {
                private final Map<String, SNREquation> linkToSNR = Maps.newHashMap();

                private SNRCalculator() {
                    this.linkToSNR.put("Unicast13to11", (SNREquation)new SNREquation(-0.0210526315789, -2.81052631579));
                    this.linkToSNR.put("Unicast14to12", (SNREquation)new SNREquation(0.0333333333333, 2.58947368421));
                    this.linkToSNR.put("Unicast15to12", (SNREquation)new SNREquation(0.0438596491228, 1.31578947368));
                    this.linkToSNR.put("Unicast11to7", (SNREquation)new SNREquation(0.380701754386, -2.12631578947));
                    this.linkToSNR.put("Unicast12to7", (SNREquation)new SNREquation(0.317543859649, 2.95789473684));
                    this.linkToSNR.put("Unicast12to3", (SNREquation)new SNREquation(-0.0157894736842, -3.77894736842));
                    this.linkToSNR.put("Unicast7to3", (SNREquation)new SNREquation(0.168421052632, 2.30526315789));
                    this.linkToSNR.put("Unicast7to2", (SNREquation)new SNREquation(-0.0157894736842, 3.77894736842));
                    this.linkToSNR.put("Unicast2to4", (SNREquation)new SNREquation(0.0473684210526, -5.29473684211));
                    this.linkToSNR.put("Unicast3to1", (SNREquation)new SNREquation(0.0280701754386, 4.25263157895));
                    this.linkToSNR.put("Unicast8to1", (SNREquation)new SNREquation(0.00350877192982, 0.45263157895));
                    this.linkToSNR.put("Unicast4to1", (SNREquation)new SNREquation(0.119298245614, -1.49473684211));
                    this.linkToSNR.put("Unicast9to1", (SNREquation)new SNREquation(0.0701754385965, 2.89473684211));
                    this.linkToSNR.put("Unicast6to4", (SNREquation)new SNREquation(0.0175438596491, -3.84210526316));
                    this.linkToSNR.put("Unicast10to6", (SNREquation)new SNREquation(3.51139336547E-16, -2.21052631579));
                    this.linkToSNR.put("Unicast10to5", (SNREquation)new SNREquation(0.250877192982, -1.75789473684));
                    this.linkToSNR.put("Unicast5to9", (SNREquation)new SNREquation(-0.019298245614, 4.8));
                }

                public double calculateSNROf(GroundRandomVariable variable, int transmissionPower, double wirelessInterference) {
                    String snrToQuery = ((LinkingResource)LinkingResource.class.cast(variable.getAppliedObjects().get(0))).getEntityName();
                    Optional<SNREquation> snrValues = Optional.ofNullable((SNREquation)this.linkToSNR.get(snrToQuery));
                    if (snrValues.isEmpty()) {
                        throw new RuntimeException(String.format("There are no snr values for %s", snrToQuery));
                    }
                    return snrValues.get().getSNR(transmissionPower);
                }
            }

            class SNREquation {
                final double multiplier;
                final double constant;

                public SNREquation(double multiplier, double constant) {
                    this.multiplier = multiplier;
                    this.constant = constant;
                }

                public double getSNR(int power) {
                    return this.multiplier * (double)power + this.constant;
                }
            }
        };
    }

    public static GroundRandomVariable findWirelessInterferenceVariable(LocalProbabilisticNetwork localNetwork) {
        return localNetwork.getGroundRandomVariables().stream().filter(DeltaIoTPartiallyEnvDynamics.isWITemplate()).findFirst().orElseThrow(() -> new RuntimeException("There is no wireless interference template."));
    }
}

