/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.simexp.core.state.RestoredSelfAdaptiveSystemState;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.markovian.sampling.SampleDumper;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.strategy.MoteContext;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.DeltaIoTCommons;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.DeltaIoTModelAccess;
import org.palladiosimulator.simexp.pcm.state.PcmSelfAdaptiveSystemState;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class DeltaIoTSampleLogger
implements SampleDumper {
    private static final Logger LOGGER = Logger.getLogger(DeltaIoTSampleLogger.class);
    private final DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess;

    public DeltaIoTSampleLogger(DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess) {
        this.modelAccess = modelAccess;
    }

    public void dump(State source) {
        this.onRunStart();
        if (source instanceof RestoredSelfAdaptiveSystemState) {
            RestoredSelfAdaptiveSystemState state = (RestoredSelfAdaptiveSystemState)RestoredSelfAdaptiveSystemState.class.cast(source);
            LOGGER.info((Object)String.format("Restored state: %s", state.toString()));
        } else {
            PcmSelfAdaptiveSystemState state = (PcmSelfAdaptiveSystemState)PcmSelfAdaptiveSystemState.class.cast(source);
            Map<AssemblyContext, Map<LinkingResource, Double>> motesToLinks = DeltaIoTCommons.filterMotesWithWirelessLinks(this.modelAccess, state);
            ArrayList<MoteContext.WirelessLink> links = new ArrayList<MoteContext.WirelessLink>();
            for (AssemblyContext each : motesToLinks.keySet()) {
                MoteContext moteContext = new MoteContext(this.modelAccess, each, motesToLinks.get(each));
                for (MoteContext.WirelessLink eachLink : moteContext.links) {
                    links.add(eachLink);
                }
            }
            List sortedLinks = links.stream().sorted((l1, l2) -> l1.pcmLink.getEntityName().compareTo(l2.pcmLink.getEntityName())).collect(Collectors.toList());
            Integer maxName = links.stream().mapToInt(v -> v.pcmLink.getEntityName().length()).max().orElseThrow(NoSuchElementException::new);
            for (MoteContext.WirelessLink eachLink : sortedLinks) {
                this.onEntry(eachLink, maxName);
            }
        }
        this.onRunFinish();
    }

    private void onRunStart() {
        LOGGER.info((Object)"******** Network configuration *******");
    }

    private void onRunFinish() {
        LOGGER.info((Object)"******** END *******");
    }

    private void onEntry(MoteContext.WirelessLink link, int maxName) {
        LOGGER.info((Object)String.format("Link %-" + String.format("%d", maxName) + "s Power: %2s, SNR: % 22.18f, Dist.: %4s", link.pcmLink.getEntityName(), link.transmissionPower, link.SNR, link.distributionFactor));
    }
}

