/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot.environment;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.palladiosimulator.envdyn.api.entity.bn.DynamicBayesianNetwork;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivedInputValues;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivedValue;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.DeltaIoTBaseEnvironemtalDynamics;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.DeltaIoTModelAccess;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import org.palladiosimulator.solver.core.models.PCMInstance;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.random.ISeedProvider;

public class DeltaIoTEnvironemtalDynamics<R>
extends DeltaIoTBaseEnvironemtalDynamics<R> {
    public DeltaIoTEnvironemtalDynamics(DynamicBayesianNetwork<CategoricalValue> dbn, DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess, Optional<ISeedProvider> seedProvider) {
        super(dbn, modelAccess, seedProvider);
    }

    @Override
    protected PerceivedValue<List<InputValue<CategoricalValue>>> toPerceivedValue(final List<InputValue<CategoricalValue>> sample) {
        return new PerceivedInputValues(sample){

            public String toString() {
                List<InputValue> wiValues = sample.stream().filter(each -> DeltaIoTEnvironemtalDynamics.isWITemplate().test(each.getVariable())).collect(Collectors.toList());
                List<InputValue> snrValues = sample.stream().filter(each -> DeltaIoTEnvironemtalDynamics.isSNRTemplate(each.getVariable())).collect(Collectors.toList());
                List<InputValue> maValues = sample.stream().filter(each -> DeltaIoTEnvironemtalDynamics.isMATemplate().test(each.getVariable())).collect(Collectors.toList());
                StringBuilder builder = new StringBuilder();
                wiValues.forEach(input -> {
                    StringBuilder stringBuilder2 = builder.append(String.format("(Variable: %1s, Value: %2s),", input.getVariable().getEntityName(), ((CategoricalValue)input.getValue()).toString()));
                });
                snrValues.forEach(input -> {
                    StringBuilder stringBuilder2 = builder.append(String.format("(Variable: %1s, Value: %2s),", input.getVariable().getEntityName(), ((CategoricalValue)input.getValue()).toString()));
                });
                maValues.forEach(input -> {
                    StringBuilder stringBuilder2 = builder.append(String.format("(Variable: %1s, Value: %2s),", input.getVariable().getEntityName(), ((CategoricalValue)input.getValue()).toString()));
                });
                String stringValues = builder.toString();
                return String.format("Environmental states:%s", stringValues.substring(0, stringValues.length() - 1));
            }
        };
    }
}

