/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot.process;

import java.util.List;
import java.util.Optional;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundRandomVariable;
import org.palladiosimulator.envdyn.environment.staticmodel.LocalProbabilisticNetwork;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivableEnvironmentalState;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.DeltaIoTPartiallyEnvDynamics;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.process.DeltaIoTPrismFileUpdater;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.DeltaIoTModelAccess;
import org.palladiosimulator.simexp.pcm.prism.entity.PrismContext;
import org.palladiosimulator.simexp.pcm.prism.entity.PrismSimulatedMeasurementSpec;
import org.palladiosimulator.simexp.pcm.state.PcmSelfAdaptiveSystemState;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import org.palladiosimulator.solver.core.models.PCMInstance;
import tools.mdsd.probdist.api.entity.CategoricalValue;

public class PacketLossPrismFileUpdater<A>
extends DeltaIoTPrismFileUpdater<A> {
    private static final String SNR_VARIABLE = "SignalToNoiseRatio";
    private final DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess;

    public PacketLossPrismFileUpdater(PrismSimulatedMeasurementSpec prismSpec, DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess) {
        super(prismSpec);
        this.modelAccess = modelAccess;
    }

    public PrismContext apply(PcmSelfAdaptiveSystemState<A, List<InputValue<CategoricalValue>>> sasState) {
        PrismContext prismContext = new PrismContext("PacketLoss", this.stringify(this.prismSpec.getModuleFile()), this.stringify(this.prismSpec.getPropertyFile()));
        this.substituteMoteActivations(prismContext, sasState);
        this.substituteSNR(prismContext, sasState);
        this.substituteDistributionFactor(prismContext, sasState);
        return prismContext;
    }

    private void substituteSNR(PrismContext prismContext, PcmSelfAdaptiveSystemState<A, List<InputValue<CategoricalValue>>> sasState) {
        ResourceEnvironment resEnv = ((PCMInstance)sasState.getArchitecturalConfiguration().getConfiguration()).getResourceEnvironment();
        for (LinkingResource each : resEnv.getLinkingResources__ResourceEnvironment()) {
            Optional<InputValue<CategoricalValue>> snrValue = this.resolveSNRInputValue(each, (PerceivableEnvironmentalState<List<InputValue<CategoricalValue>>>)sasState.getPerceivedEnvironmentalState());
            if (!snrValue.isPresent()) continue;
            InputValue<CategoricalValue> inputValue = snrValue.get();
            LocalProbabilisticNetwork localNetwork = (LocalProbabilisticNetwork)LocalProbabilisticNetwork.class.cast(inputValue.getVariable().eContainer());
            GroundRandomVariable wiVariable = DeltaIoTPartiallyEnvDynamics.findWirelessInterferenceVariable(localNetwork);
            double wirelessInterference = this.modelAccess.retrieveWirelessInterference(wiVariable, (PerceivableEnvironmentalState<List<InputValue<CategoricalValue>>>)sasState.getPerceivedEnvironmentalState());
            double newSnrValue = Double.valueOf((String)((CategoricalValue)inputValue.getValue()).get()) + wirelessInterference;
            this.substitute(prismContext, each, Double.toString(newSnrValue));
        }
    }

    private Optional<InputValue<CategoricalValue>> resolveSNRInputValue(LinkingResource linkingRes, PerceivableEnvironmentalState<List<InputValue<CategoricalValue>>> state) {
        List<InputValue<CategoricalValue>> values = this.resolveInputValue(linkingRes, state);
        if (values.isEmpty()) {
            return Optional.empty();
        }
        return values.stream().filter(each -> each.getVariable().getInstantiatedTemplate().getEntityName().equals(SNR_VARIABLE)).findFirst();
    }
}

