/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration;

import de.uka.ipd.sdq.stoex.VariableReference;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.SingleQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.param.reconfigurationparams.DeltaIoTReconfigurationParamRepository;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.param.reconfigurationparams.DistributionFactor;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.param.reconfigurationparams.DistributionFactorValue;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.param.reconfigurationparams.TransmissionPowerValue;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.DeltaIoTBaseReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.IDistributionFactorReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.ITransmissionPowerReconfiguration;

public class DeltaIoTNetworkReconfiguration
extends DeltaIoTBaseReconfiguration
implements IDistributionFactorReconfiguration,
ITransmissionPowerReconfiguration {
    private static final String QVT_FILE_SUFFIX = "DeltaIoTNetwork";
    private final DeltaIoTReconfigurationParamRepository paramRepo;

    public DeltaIoTNetworkReconfiguration(SingleQVToReconfiguration reconfiguration, DeltaIoTReconfigurationParamRepository paramRepo) {
        super(reconfiguration);
        this.paramRepo = paramRepo;
    }

    public static boolean isCorrectQvtReconfguration(QVToReconfiguration qvt) {
        return qvt.getReconfigurationName().endsWith(QVT_FILE_SUFFIX);
    }

    @Override
    public void setDistributionFactorValuesToDefaults() {
        for (DistributionFactor each : this.paramRepo.getDistributionFactors()) {
            each.getFactorValues().forEach(value -> value.setValue(0.0));
        }
    }

    @Override
    public void adjustDistributionFactor(Map<ProbabilisticBranchTransition, Double> factors) {
        if (this.isNotValid(factors)) {
            throw new RuntimeException("The disrtribution factors are note valid.");
        }
        for (Map.Entry<ProbabilisticBranchTransition, Double> entry : factors.entrySet()) {
            ProbabilisticBranchTransition branch = entry.getKey();
            Double value = entry.getValue();
            this.setDistributionFactorIfPresent(branch, value);
        }
    }

    @Override
    public void adjustTransmissionPower(Map<VariableReference, Integer> powerSetting) {
        for (Map.Entry<VariableReference, Integer> entry : powerSetting.entrySet()) {
            VariableReference each = entry.getKey();
            Integer adjustment = entry.getValue();
            Optional<TransmissionPowerValue> tp = this.findTransmissionPowerValueWith(each);
            if (tp.isEmpty()) {
                throw new RuntimeException(String.format("Power value for %s could not be found.", each.getReferenceName()));
            }
            TransmissionPowerValue transmissionPowerValue = tp.get();
            this.adjust(transmissionPowerValue, adjustment);
        }
    }

    private void adjust(TransmissionPowerValue value, int adjustement) {
        int newPowerVal = value.getPowerSetting() + adjustement;
        value.setPowerSetting(newPowerVal);
    }

    private Optional<DistributionFactorValue> findDistFactorValueWith(ProbabilisticBranchTransition branch) {
        return this.paramRepo.getDistributionFactors().stream().flatMap(each -> each.getFactorValues().stream()).filter(this.factorValueAppliedTo(branch)).findFirst();
    }

    private Predicate<DistributionFactorValue> factorValueAppliedTo(ProbabilisticBranchTransition givenBranch) {
        return value -> value.getAppliedBranch().getId().equals(givenBranch.getId());
    }

    private void setDistributionFactorIfPresent(ProbabilisticBranchTransition branch, double value) {
        Optional<DistributionFactorValue> factor = this.findDistFactorValueWith(branch);
        if (!factor.isPresent()) {
            throw new RuntimeException(String.format("Distribution factor for branch %s could not be found.", branch.getEntityName()));
        }
        factor.get().setValue(value);
    }

    @Override
    public boolean canBeAdjusted(Map<VariableReference, Integer> powerValues) {
        for (VariableReference each : powerValues.keySet()) {
            Optional<TransmissionPowerValue> powerVal = this.findTransmissionPowerValueWith(each);
            if (powerVal.isEmpty()) {
                return false;
            }
            int adjustedPowerSetting = powerVal.get().getPowerSetting() + powerValues.get(each);
            if (!Boolean.logicalOr(adjustedPowerSetting < 0, adjustedPowerSetting > 15)) continue;
            return false;
        }
        return true;
    }

    private Optional<TransmissionPowerValue> findTransmissionPowerValueWith(VariableReference varRef) {
        return this.paramRepo.getTransmissionPower().stream().flatMap(each -> each.getTransmissionPowerValues().stream()).filter(this.transmissionPowerValuesWith(varRef)).findFirst();
    }

    private Predicate<TransmissionPowerValue> transmissionPowerValuesWith(VariableReference varRef) {
        return v -> v.getVariableRef().getReferenceName().equals(varRef.getReferenceName());
    }
}

