/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.SingleQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.param.reconfigurationparams.DistributionFactor;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.param.reconfigurationparams.DistributionFactorValue;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.DeltaIoTBaseReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.IDistributionFactorReconfiguration;

public class DistributionFactorReconfiguration
extends DeltaIoTBaseReconfiguration
implements IDistributionFactorReconfiguration {
    public static final double DEFAULT_VALUE = 0.0;
    private static final String QVT_FILE_SUFFIX = "DistributionFactor";
    private final Set<DistributionFactor> distFactors;

    public DistributionFactorReconfiguration(SingleQVToReconfiguration reconfiguration, Set<DistributionFactor> distFactors) {
        super(reconfiguration);
        this.distFactors = distFactors;
    }

    public DistributionFactorReconfiguration(SingleQVToReconfiguration reconfiguration, List<DistributionFactor> distFactors) {
        this(reconfiguration, Sets.newLinkedHashSet(distFactors));
    }

    @Override
    public void setDistributionFactorValuesToDefaults() {
        for (DistributionFactor each : this.distFactors) {
            each.getFactorValues().forEach(value -> value.setValue(0.0));
        }
    }

    public static boolean isCorrectQvtReconfguration(QVToReconfiguration qvt) {
        String stringRepresentation = qvt.getReconfigurationName();
        return stringRepresentation.endsWith(QVT_FILE_SUFFIX);
    }

    @Override
    public void adjustDistributionFactor(Map<ProbabilisticBranchTransition, Double> factors) {
        for (Map.Entry<ProbabilisticBranchTransition, Double> entry : factors.entrySet()) {
            ProbabilisticBranchTransition each = entry.getKey();
            Double value = entry.getValue();
            Optional<DistributionFactorValue> distFactorValue = this.findDistFactorValueWith(each);
            distFactorValue.ifPresent(v -> v.setValue(value.doubleValue()));
        }
    }

    private Optional<DistributionFactorValue> findDistFactorValueWith(ProbabilisticBranchTransition branch) {
        return this.distFactors.stream().flatMap(each -> each.getFactorValues().stream()).filter(this.factorValueAppliedTo(branch)).findFirst();
    }

    private Predicate<DistributionFactorValue> factorValueAppliedTo(ProbabilisticBranchTransition givenBranch) {
        return value -> value.getAppliedBranch().getId().equals(givenBranch.getId());
    }
}

