/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration;

import com.google.common.collect.Sets;
import de.uka.ipd.sdq.stoex.VariableReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.SingleQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.param.reconfigurationparams.TransmissionPower;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.param.reconfigurationparams.TransmissionPowerValue;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.DeltaIoTBaseReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.ITransmissionPowerReconfiguration;

public class TransmissionPowerReconfiguration
extends DeltaIoTBaseReconfiguration
implements ITransmissionPowerReconfiguration {
    private static final String QVT_FILE_SUFFIX = "TransmissionPower";
    static final int MAX_POWER = 15;
    static final int MIN_POWER = 0;
    private final Set<TransmissionPower> powerSettings;

    public TransmissionPowerReconfiguration(SingleQVToReconfiguration reconfiguration, Set<TransmissionPower> powerSettings) {
        super(reconfiguration);
        this.powerSettings = powerSettings;
    }

    public TransmissionPowerReconfiguration(SingleQVToReconfiguration reconfiguration, List<TransmissionPower> powerSettings) {
        this(reconfiguration, Sets.newLinkedHashSet(powerSettings));
    }

    public static boolean isCorrectQvtReconfguration(QVToReconfiguration qvt) {
        return qvt.getReconfigurationName().endsWith(QVT_FILE_SUFFIX);
    }

    @Override
    public void adjustTransmissionPower(Map<VariableReference, Integer> powerSetting) {
        for (Map.Entry<VariableReference, Integer> entry : powerSetting.entrySet()) {
            VariableReference each = entry.getKey();
            Integer adjustment = entry.getValue();
            Optional<TransmissionPowerValue> transmissionPowerValue = this.findTransmissionPowerValueWith(each);
            transmissionPowerValue.ifPresent(v -> this.adjust((TransmissionPowerValue)v, adjustment));
        }
    }

    private void adjust(TransmissionPowerValue value, int adjustement) {
        int newPowerVal = value.getPowerSetting() + adjustement;
        value.setPowerSetting(newPowerVal);
    }

    @Override
    public boolean canBeAdjusted(Map<VariableReference, Integer> powerValues) {
        for (VariableReference each : powerValues.keySet()) {
            Optional<TransmissionPowerValue> powerVal = this.findTransmissionPowerValueWith(each);
            if (powerVal.isEmpty()) {
                return false;
            }
            int adjustedPowerSetting = powerVal.get().getPowerSetting() + powerValues.get(each);
            if (!Boolean.logicalOr(adjustedPowerSetting < 0, adjustedPowerSetting > 15)) continue;
            return false;
        }
        return true;
    }

    private Optional<TransmissionPowerValue> findTransmissionPowerValueWith(VariableReference varRef) {
        return this.powerSettings.stream().flatMap(each -> each.getTransmissionPowerValues().stream()).filter(this.transmissionPowerValuesWith(varRef)).findFirst();
    }

    private Predicate<TransmissionPowerValue> transmissionPowerValuesWith(VariableReference varRef) {
        return v -> v.getVariableRef().getReferenceName().equals(varRef.getReferenceName());
    }
}

