/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot.reward;

import org.palladiosimulator.simexp.core.entity.SimulatedMeasurement;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurementSpecification;
import org.palladiosimulator.simexp.core.reward.RewardEvaluator;
import org.palladiosimulator.simexp.core.state.StateQuantity;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Reward;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.impl.RewardImpl;

public class QualityBasedRewardEvaluator
implements RewardEvaluator<Double> {
    private final SimulatedMeasurementSpecification packetLossSpec;
    private final SimulatedMeasurementSpecification energyConsumptionSpec;

    public QualityBasedRewardEvaluator(SimulatedMeasurementSpecification packetLossSpec, SimulatedMeasurementSpecification energyConsumptionSpec) {
        this.packetLossSpec = packetLossSpec;
        this.energyConsumptionSpec = energyConsumptionSpec;
    }

    public Reward<Double> evaluate(StateQuantity quantifiedState) {
        double value = 0.0;
        SimulatedMeasurement packetLoss = (SimulatedMeasurement)quantifiedState.findMeasurementWith(this.packetLossSpec).orElseThrow();
        double normalizedPacketLoss = this.normalizePacketLoss(packetLoss.getValue());
        value += normalizedPacketLoss;
        SimulatedMeasurement energyConsumption = (SimulatedMeasurement)quantifiedState.findMeasurementWith(this.energyConsumptionSpec).orElseThrow();
        double normalizedEnergyConsumption = this.normalizeEnergyConsumption(energyConsumption.getValue());
        value += normalizedEnergyConsumption;
        double normalizedValue = normalizedPacketLoss + normalizedEnergyConsumption;
        return RealValuedReward.of(normalizedValue);
    }

    private double normalizeEnergyConsumption(double ec) {
        if (ec > 34.5) {
            return 0.0;
        }
        if (ec < 30.5) {
            return 1.0;
        }
        return 0.25 * (34.5 - ec);
    }

    private double normalizePacketLoss(double pl) {
        if (pl > 0.2) {
            return 0.0;
        }
        if (pl < 0.025) {
            return 1.0;
        }
        return 5.7142857142857135 * (0.2 - pl);
    }

    public static class RealValuedReward
    extends RewardImpl<Double> {
        private RealValuedReward(double value) {
            super.setValue((Object)value);
        }

        public static RealValuedReward of(double value) {
            return new RealValuedReward(value);
        }

        public String toString() {
            return Double.toString((Double)this.getValue());
        }
    }
}

