/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot.strategy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.uka.ipd.sdq.stoex.VariableReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurement;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurementSpecification;
import org.palladiosimulator.simexp.core.util.Threshold;
import org.palladiosimulator.simexp.markovian.activity.Policy;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.pcm.action.EmptyQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.param.reconfigurationparams.DeltaIoTReconfigurationParamRepository;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.param.reconfigurationparams.DistributionFactorValue;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.param.reconfigurationparams.TransmissionPowerValue;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.DistributionFactorReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.TransmissionPowerReconfiguration;
import org.palladiosimulator.simexp.pcm.prism.entity.PrismSimulatedMeasurementSpec;
import org.palladiosimulator.simexp.pcm.state.PcmSelfAdaptiveSystemState;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import tools.mdsd.probdist.api.entity.CategoricalValue;

public abstract class DeltaIoTReconfigurationStrategy
implements Policy<QVTOReconfigurator, QVToReconfiguration> {
    private static final String BRANCH_10_TO_6 = "TransmitToMote6";
    private static final String BRANCH_10_TO_5 = "TransmitToMote5";
    private static final String BRANCH_12_TO_3 = "TransmitToMote3";
    private static final String BRANCH_12_TO_7 = "TransmitToMote7";
    private static final String BRANCH_7_TO_3 = "TransmitFrom7ToMote3";
    private static final String BRANCH_7_TO_2 = "TransmitToMote2";
    private static final double DISTRIBUTION_FACTOR_INCREMENT = 0.1;
    private static final int TRANSMISSION_POWER_INCREMENT = 1;
    protected static final String VARIABLE_REFERENCE_3_TO_1 = "TransmissionPower3to1";
    protected static final String VARIABLE_REFERENCE_8_TO_1 = "TransmissionPower8to1";
    protected static final String VARIABLE_REFERENCE_9_TO_1 = "TransmissionPower9to1";
    protected static final String VARIABLE_REFERENCE_4_TO_1 = "TransmissionPower4to1";
    protected static final String VARIABLE_REFERENCE_10_TO_6 = "TransmissionPower10to6";
    protected static final String VARIABLE_REFERENCE_10_TO_5 = "TransmissionPower10to5";
    protected static final String VARIABLE_REFERENCE_5_TO_9 = "TransmissionPower5to9";
    protected static final String VARIABLE_REFERENCE_6_TO_4 = "TransmissionPower6to4";
    protected static final String VARIABLE_REFERENCE_7_TO_3 = "TransmissionPower7to3";
    protected static final String VARIABLE_REFERENCE_7_TO_2 = "TransmissionPower7to2";
    protected static final String VARIABLE_REFERENCE_2_TO_4 = "TransmissionPower2to4";
    protected static final String VARIABLE_REFERENCE_11_TO_7 = "TransmissionPower11to7";
    protected static final String VARIABLE_REFERENCE_13_TO_11 = "TransmissionPower13to11";
    protected static final String VARIABLE_REFERENCE_12_TO_7 = "TransmissionPower12to7";
    protected static final String VARIABLE_REFERENCE_12_TO_3 = "TransmissionPower12to3";
    protected static final String VARIABLE_REFERENCE_14_TO_12 = "TransmissionPower14to12";
    protected static final String VARIABLE_REFERENCE_15_TO_12 = "TransmissionPower15to12";
    protected static final List<String> VARIABLE_REFERENCES = Lists.newArrayList();
    public static final Threshold LOWER_PACKET_LOSS;
    public static final Threshold LOWER_ENERGY_CONSUMPTION;
    protected DeltaIoTReconfigurationParamRepository reconfParamsRepo;
    protected PrismSimulatedMeasurementSpec packetLossSpec;
    protected PrismSimulatedMeasurementSpec energyConsumptionSpec;

    static {
        VARIABLE_REFERENCES.add(VARIABLE_REFERENCE_3_TO_1);
        VARIABLE_REFERENCES.add(VARIABLE_REFERENCE_8_TO_1);
        VARIABLE_REFERENCES.add(VARIABLE_REFERENCE_9_TO_1);
        VARIABLE_REFERENCES.add(VARIABLE_REFERENCE_4_TO_1);
        VARIABLE_REFERENCES.add(VARIABLE_REFERENCE_10_TO_6);
        VARIABLE_REFERENCES.add(VARIABLE_REFERENCE_10_TO_5);
        VARIABLE_REFERENCES.add(VARIABLE_REFERENCE_5_TO_9);
        VARIABLE_REFERENCES.add(VARIABLE_REFERENCE_6_TO_4);
        VARIABLE_REFERENCES.add(VARIABLE_REFERENCE_7_TO_3);
        VARIABLE_REFERENCES.add(VARIABLE_REFERENCE_7_TO_2);
        VARIABLE_REFERENCES.add(VARIABLE_REFERENCE_2_TO_4);
        VARIABLE_REFERENCES.add(VARIABLE_REFERENCE_11_TO_7);
        VARIABLE_REFERENCES.add(VARIABLE_REFERENCE_13_TO_11);
        VARIABLE_REFERENCES.add(VARIABLE_REFERENCE_12_TO_7);
        VARIABLE_REFERENCES.add(VARIABLE_REFERENCE_12_TO_3);
        VARIABLE_REFERENCES.add(VARIABLE_REFERENCE_14_TO_12);
        VARIABLE_REFERENCES.add(VARIABLE_REFERENCE_15_TO_12);
        LOWER_PACKET_LOSS = Threshold.lessThan((double)0.1);
        LOWER_ENERGY_CONSUMPTION = Threshold.lessThan((double)0.4);
    }

    protected DeltaIoTReconfigurationStrategy() {
    }

    public QVToReconfiguration select(State source, Set<QVToReconfiguration> options) {
        this.retrieveDistributionFactorReconfiguration(options).setDistributionFactorValuesToDefaults();
        PcmSelfAdaptiveSystemState state = (PcmSelfAdaptiveSystemState)PcmSelfAdaptiveSystemState.class.cast(source);
        SimulatedMeasurement packetLoss = (SimulatedMeasurement)state.getQuantifiedState().findMeasurementWith((SimulatedMeasurementSpecification)this.packetLossSpec).orElseThrow(() -> new RuntimeException(String.format("There is no simulated measurement for spec %s", this.packetLossSpec.getName())));
        if (this.packetLossIsViolated(packetLoss)) {
            return this.handlePacketLoss((PcmSelfAdaptiveSystemState<QVTOReconfigurator, List<InputValue<CategoricalValue>>>)state, packetLoss, options);
        }
        SimulatedMeasurement energyConsumtption = (SimulatedMeasurement)state.getQuantifiedState().findMeasurementWith((SimulatedMeasurementSpecification)this.energyConsumptionSpec).orElseThrow(() -> new RuntimeException(String.format("There is no simulated measurement for spec %s", this.energyConsumptionSpec.getName())));
        if (this.energyConsumptionIsViolated(energyConsumtption)) {
            return this.handleEnergyConsumption((PcmSelfAdaptiveSystemState<QVTOReconfigurator, List<InputValue<CategoricalValue>>>)state, energyConsumtption, options);
        }
        return EmptyQVToReconfiguration.empty();
    }

    private boolean packetLossIsViolated(SimulatedMeasurement packetLoss) {
        return LOWER_PACKET_LOSS.isNotSatisfied(packetLoss.getValue());
    }

    private boolean energyConsumptionIsViolated(SimulatedMeasurement energyConsumtption) {
        return LOWER_ENERGY_CONSUMPTION.isNotSatisfied(energyConsumtption.getValue());
    }

    protected abstract QVToReconfiguration handlePacketLoss(PcmSelfAdaptiveSystemState<QVTOReconfigurator, List<InputValue<CategoricalValue>>> var1, SimulatedMeasurement var2, Set<QVToReconfiguration> var3);

    protected abstract QVToReconfiguration handleEnergyConsumption(PcmSelfAdaptiveSystemState<QVTOReconfigurator, List<InputValue<CategoricalValue>>> var1, SimulatedMeasurement var2, Set<QVToReconfiguration> var3);

    protected DistributionFactorReconfiguration retrieveDistributionFactorReconfiguration(Set<QVToReconfiguration> options) {
        return this.retrieveReconfiguration(DistributionFactorReconfiguration.class, options).orElseThrow(() -> new RuntimeException("There is no distribution factor reconfiguration registered."));
    }

    protected TransmissionPowerReconfiguration retrieveTransmissionPowerReconfiguration(Set<QVToReconfiguration> options) {
        return this.retrieveReconfiguration(TransmissionPowerReconfiguration.class, options).orElseThrow(() -> new RuntimeException("There is no distribution factor reconfiguration registered."));
    }

    private <T extends QVToReconfiguration> Optional<T> retrieveReconfiguration(Class<T> reconfClass, Set<QVToReconfiguration> options) {
        return options.stream().filter(reconfClass::isInstance).map(reconfClass::cast).findFirst();
    }

    protected boolean increaseDistributionFactor(ProbabilisticBranchTransition branchToIncrease, ProbabilisticBranchTransition branchToDecrease, DistributionFactorReconfiguration reconf) {
        HashMap factors = Maps.newHashMap();
        factors.put(this.findBranchWith(branchToDecrease.getEntityName()), -0.1);
        factors.put(this.findBranchWith(branchToIncrease.getEntityName()), 0.1);
        if (reconf.isValid(factors)) {
            reconf.adjustDistributionFactor(factors);
            return true;
        }
        return false;
    }

    protected boolean increaseDistributionFactorOfMote7(DistributionFactorReconfiguration reconf) {
        HashMap factors = Maps.newHashMap();
        factors.put(this.findBranchWith(BRANCH_7_TO_3), -0.1);
        factors.put(this.findBranchWith(BRANCH_7_TO_2), 0.1);
        if (Boolean.logicalAnd(this.canBeIncreased(factors), reconf.isValid(factors))) {
            reconf.adjustDistributionFactor(factors);
            return true;
        }
        return false;
    }

    protected boolean decreaseDistributionFactorOfMote7(DistributionFactorReconfiguration reconf) {
        HashMap factors = Maps.newHashMap();
        factors.put(this.findBranchWith(BRANCH_7_TO_3), 0.1);
        factors.put(this.findBranchWith(BRANCH_7_TO_2), -0.1);
        if (Boolean.logicalAnd(this.canBeDecreased(factors), reconf.isValid(factors))) {
            reconf.adjustDistributionFactor(factors);
            return true;
        }
        return false;
    }

    protected boolean increaseDistributionFactorOfMote10(DistributionFactorReconfiguration reconf) {
        HashMap factors = Maps.newHashMap();
        factors.put(this.findBranchWith(BRANCH_10_TO_6), -0.1);
        factors.put(this.findBranchWith(BRANCH_10_TO_5), 0.1);
        if (Boolean.logicalAnd(this.canBeIncreased(factors), reconf.isValid(factors))) {
            reconf.adjustDistributionFactor(factors);
            return true;
        }
        return false;
    }

    protected boolean decreaseDistributionFactorOfMote10(DistributionFactorReconfiguration reconf) {
        HashMap factors = Maps.newHashMap();
        factors.put(this.findBranchWith(BRANCH_10_TO_6), 0.1);
        factors.put(this.findBranchWith(BRANCH_10_TO_5), -0.1);
        if (Boolean.logicalAnd(this.canBeDecreased(factors), reconf.isValid(factors))) {
            reconf.adjustDistributionFactor(factors);
            return true;
        }
        return false;
    }

    protected boolean increaseDistributionFactorOfMote12(DistributionFactorReconfiguration reconf) {
        HashMap factors = Maps.newHashMap();
        factors.put(this.findBranchWith(BRANCH_12_TO_3), -0.1);
        factors.put(this.findBranchWith(BRANCH_12_TO_7), 0.1);
        if (Boolean.logicalAnd(this.canBeIncreased(factors), reconf.isValid(factors))) {
            reconf.adjustDistributionFactor(factors);
            return true;
        }
        return false;
    }

    protected boolean decreaseDistributionFactorOfMote12(DistributionFactorReconfiguration reconf) {
        HashMap factors = Maps.newHashMap();
        factors.put(this.findBranchWith(BRANCH_12_TO_3), 0.1);
        factors.put(this.findBranchWith(BRANCH_12_TO_7), -0.1);
        if (Boolean.logicalAnd(this.canBeDecreased(factors), reconf.isValid(factors))) {
            reconf.adjustDistributionFactor(factors);
            return true;
        }
        return false;
    }

    private boolean canBeIncreased(Map<ProbabilisticBranchTransition, Double> factors) {
        double branchProb2;
        if (factors.size() != 2) {
            return false;
        }
        ArrayList transitions = Lists.newArrayList(factors.keySet());
        double branchProb1 = ((ProbabilisticBranchTransition)transitions.get(0)).getBranchProbability();
        return branchProb1 != (branchProb2 = ((ProbabilisticBranchTransition)transitions.get(1)).getBranchProbability());
    }

    private boolean canBeDecreased(Map<ProbabilisticBranchTransition, Double> factors) {
        double branchProb2;
        if (factors.size() != 2) {
            return false;
        }
        ArrayList transitions = Lists.newArrayList(factors.keySet());
        double branchProb1 = ((ProbabilisticBranchTransition)transitions.get(0)).getBranchProbability() + factors.get(transitions.get(0));
        return Math.max(branchProb1, branchProb2 = ((ProbabilisticBranchTransition)transitions.get(1)).getBranchProbability() + factors.get(transitions.get(1))) <= 1.0;
    }

    protected boolean increaseTransmissionPower(String varRef, TransmissionPowerReconfiguration reconf) {
        HashMap powerSettings = Maps.newHashMap();
        powerSettings.put(this.findVariableReferenceWith(varRef), 1);
        if (reconf.canBeAdjusted(powerSettings)) {
            reconf.adjustTransmissionPower(powerSettings);
            return true;
        }
        return false;
    }

    protected boolean decreaseTransmissionPower(String varRef, TransmissionPowerReconfiguration reconf) {
        HashMap powerSettings = Maps.newHashMap();
        powerSettings.put(this.findVariableReferenceWith(varRef), -1);
        if (reconf.canBeAdjusted(powerSettings)) {
            reconf.adjustTransmissionPower(powerSettings);
            return true;
        }
        return false;
    }

    private ProbabilisticBranchTransition findBranchWith(String branchName) {
        return this.reconfParamsRepo.getDistributionFactors().stream().flatMap(each -> each.getFactorValues().stream()).filter(this.factorValuesWithBranch(branchName)).map(DistributionFactorValue::getAppliedBranch).findFirst().orElseThrow(() -> new RuntimeException(String.format("There is no branch with name %s", branchName)));
    }

    private Predicate<DistributionFactorValue> factorValuesWithBranch(String branchName) {
        return value -> value.getAppliedBranch().getEntityName().equals(branchName);
    }

    private VariableReference findVariableReferenceWith(String referenceName) {
        return this.reconfParamsRepo.getTransmissionPower().stream().flatMap(each -> each.getTransmissionPowerValues().stream()).filter(this.powerValuesWithVariable(referenceName)).map(TransmissionPowerValue::getVariableRef).findFirst().orElseThrow(() -> new RuntimeException(String.format("There is no variable reference with name %s", referenceName)));
    }

    private Predicate<TransmissionPowerValue> powerValuesWithVariable(String referenceName) {
        return value -> value.getVariableRef().getReferenceName().equals(referenceName);
    }

    public static class DeltaIoTReconfigurationStrategyBuilder {
        private final DeltaIoTReconfigurationStrategy strategy;

        protected DeltaIoTReconfigurationStrategyBuilder(DeltaIoTReconfigurationStrategy strategy) {
            this.strategy = strategy;
        }

        public DeltaIoTReconfigurationStrategyBuilder withReconfigurationParams(DeltaIoTReconfigurationParamRepository params) {
            this.strategy.reconfParamsRepo = params;
            return this;
        }

        public DeltaIoTReconfigurationStrategyBuilder andPacketLossSpec(PrismSimulatedMeasurementSpec packetLossSpec) {
            this.strategy.packetLossSpec = packetLossSpec;
            return this;
        }

        public DeltaIoTReconfigurationStrategyBuilder andEnergyConsumptionSpec(PrismSimulatedMeasurementSpec energyConsumptionSpec) {
            this.strategy.energyConsumptionSpec = energyConsumptionSpec;
            return this;
        }

        public DeltaIoTReconfigurationStrategy build() {
            Objects.requireNonNull(this.strategy.reconfParamsRepo, "Reconfiguration params are missing");
            Objects.requireNonNull(this.strategy.packetLossSpec, "Packet loss spec is missing");
            Objects.requireNonNull(this.strategy.energyConsumptionSpec, "Energy consumption spec is missing");
            return this.strategy;
        }
    }
}

