/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot.strategy;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurement;
import org.palladiosimulator.simexp.core.state.ArchitecturalConfiguration;
import org.palladiosimulator.simexp.core.util.Threshold;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.DeltaIoTBaseEnvironemtalDynamics;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.DistributionFactorReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.TransmissionPowerReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.strategy.DeltaIoTReconfigurationStrategy;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.DeltaIoTModelAccess;
import org.palladiosimulator.simexp.pcm.state.PcmSelfAdaptiveSystemState;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import org.palladiosimulator.solver.core.models.PCMInstance;
import tools.mdsd.probdist.api.entity.CategoricalValue;

public class LocalQualityBasedReconfigurationStrategy
extends DeltaIoTReconfigurationStrategy {
    private static final Logger LOGGER = Logger.getLogger((String)LocalQualityBasedReconfigurationStrategy.class.getName());
    private static final String ID = "LocalQualityBasedReconfigurationStrategy";
    public static final Threshold MEDIUM_PACKET_LOSS = Threshold.lessThan((double)0.3);
    public static final Threshold LOWER_ENERGY_CONSUMPTION = Threshold.lessThan((double)0.4);
    private final DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess;

    public LocalQualityBasedReconfigurationStrategy(DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess) {
        this.modelAccess = modelAccess;
    }

    public static DeltaIoTReconfigurationStrategy.DeltaIoTReconfigurationStrategyBuilder newBuilder(DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess) {
        return new DeltaIoTReconfigurationStrategy.DeltaIoTReconfigurationStrategyBuilder(new LocalQualityBasedReconfigurationStrategy(modelAccess));
    }

    public String getId() {
        return ID;
    }

    @Override
    protected QVToReconfiguration handlePacketLoss(PcmSelfAdaptiveSystemState<QVTOReconfigurator, List<InputValue<CategoricalValue>>> state, SimulatedMeasurement packetLoss, Set<QVToReconfiguration> options) {
        LOGGER.info((Object)"Start with actions selection.");
        long start = System.currentTimeMillis();
        QVToReconfiguration action = MEDIUM_PACKET_LOSS.isSatisfied(packetLoss.getValue()) ? this.increaseDistribution(state, options) : this.increaseTransmissionPower(state, options);
        long end = System.currentTimeMillis();
        LOGGER.info((Object)("Stop with action selection, took : " + (end - start) / 1000L));
        return action;
    }

    @Override
    protected QVToReconfiguration handleEnergyConsumption(PcmSelfAdaptiveSystemState<QVTOReconfigurator, List<InputValue<CategoricalValue>>> state, SimulatedMeasurement energyConsumtption, Set<QVToReconfiguration> options) {
        if (LOWER_ENERGY_CONSUMPTION.isSatisfied(energyConsumtption.getValue())) {
            return this.decreaseDistribution(state, options);
        }
        return this.decreaseTransmissionPower(state, options);
    }

    private QVToReconfiguration decreaseDistribution(PcmSelfAdaptiveSystemState<QVTOReconfigurator, List<InputValue<CategoricalValue>>> state, Set<QVToReconfiguration> options) {
        DistributionFactorReconfiguration disFactorReconf = this.retrieveDistributionFactorReconfiguration(options);
        Map<AssemblyContext, Map<LinkingResource, Double>> sourceMotesToLinks = this.filterMotesWithWirelessLinks(state);
        for (AssemblyContext each : sourceMotesToLinks.keySet()) {
            Map<LinkingResource, Double> links = sourceMotesToLinks.get(each);
            if (links.size() != 2) continue;
            this.decreaseDistributionFactorWithHighestTransmissionPower(each, links, disFactorReconf);
        }
        return disFactorReconf;
    }

    private QVToReconfiguration decreaseTransmissionPower(PcmSelfAdaptiveSystemState<QVTOReconfigurator, List<InputValue<CategoricalValue>>> state, Set<QVToReconfiguration> options) {
        TransmissionPowerReconfiguration transPowerReconf = this.retrieveTransmissionPowerReconfiguration(options);
        Map<AssemblyContext, Map<LinkingResource, Double>> sourceMotesToLinks = this.filterMotesWithWirelessLinks(state);
        for (AssemblyContext each : sourceMotesToLinks.keySet()) {
            WirelessLinkFilter linkFilter = new WirelessLinkFilter(sourceMotesToLinks.get(each));
            linkFilter.linksWithSNRHigherThan(Threshold.greaterThanOrEqualTo((double)0.0)).forEach(link -> this.decreaseTransmissionPower(each, (LinkingResource)link, transPowerReconf));
        }
        return transPowerReconf;
    }

    private QVToReconfiguration increaseDistribution(PcmSelfAdaptiveSystemState<QVTOReconfigurator, List<InputValue<CategoricalValue>>> state, Set<QVToReconfiguration> options) {
        DistributionFactorReconfiguration disFactorReconf = this.retrieveDistributionFactorReconfiguration(options);
        Map<AssemblyContext, Map<LinkingResource, Double>> sourceMotesToLinks = this.filterMotesWithWirelessLinks(state);
        for (AssemblyContext each : sourceMotesToLinks.keySet()) {
            Map<LinkingResource, Double> links = sourceMotesToLinks.get(each);
            if (links.size() != 2) continue;
            this.increaseDistributionFactorWithHighestSNR(each, links, disFactorReconf);
        }
        return disFactorReconf;
    }

    private QVToReconfiguration increaseTransmissionPower(PcmSelfAdaptiveSystemState<QVTOReconfigurator, List<InputValue<CategoricalValue>>> state, Set<QVToReconfiguration> options) {
        TransmissionPowerReconfiguration transPowerReconf = this.retrieveTransmissionPowerReconfiguration(options);
        Map<AssemblyContext, Map<LinkingResource, Double>> sourceMotesToLinks = this.filterMotesWithWirelessLinks(state);
        for (AssemblyContext each : sourceMotesToLinks.keySet()) {
            WirelessLinkFilter linkFilter = new WirelessLinkFilter(sourceMotesToLinks.get(each));
            linkFilter.linksWithSNRLowerThan(Threshold.lessThan((double)0.0)).forEach(link -> this.increaseTransmissionPower(each, (LinkingResource)link, transPowerReconf));
        }
        return transPowerReconf;
    }

    private void decreaseTransmissionPower(AssemblyContext sourceMote, LinkingResource link, TransmissionPowerReconfiguration transPowerReconf) {
        EList varUsages = sourceMote.getConfigParameterUsages__AssemblyContext();
        for (VariableUsage each : varUsages) {
            if (!this.modelAccess.isTransmissionPowerOfLink(each, link)) continue;
            this.decreaseTransmissionPower(each.getNamedReference__VariableUsage().getReferenceName(), transPowerReconf);
        }
    }

    private void increaseTransmissionPower(AssemblyContext sourceMote, LinkingResource link, TransmissionPowerReconfiguration transPowerReconf) {
        EList varUsages = sourceMote.getConfigParameterUsages__AssemblyContext();
        for (VariableUsage each : varUsages) {
            if (!this.modelAccess.isTransmissionPowerOfLink(each, link)) continue;
            this.increaseTransmissionPower(each.getNamedReference__VariableUsage().getReferenceName(), transPowerReconf);
        }
    }

    private void increaseDistributionFactorWithHighestSNR(AssemblyContext sourceMote, Map<LinkingResource, Double> links, DistributionFactorReconfiguration disFactorReconf) {
        ProbabilisticBranchTransition branchToDecrease;
        ProbabilisticBranchTransition branchToIncrease;
        List<ProbabilisticBranchTransition> branchesToAdapt = this.modelAccess.retrieveCommunicatingBranches(sourceMote);
        LinkingResource linkWithHighestSNR = new WirelessLinkFilter(links).linkWithHighestSNR();
        if (this.isPhysicalLink(branchesToAdapt.get(0), linkWithHighestSNR)) {
            branchToIncrease = branchesToAdapt.get(1);
            branchToDecrease = branchesToAdapt.get(0);
        } else {
            branchToIncrease = branchesToAdapt.get(0);
            branchToDecrease = branchesToAdapt.get(1);
        }
        this.increaseDistributionFactor(branchToIncrease, branchToDecrease, disFactorReconf);
    }

    private void decreaseDistributionFactorWithHighestTransmissionPower(AssemblyContext sourceMote, Map<LinkingResource, Double> links, DistributionFactorReconfiguration disFactorReconf) {
        ProbabilisticBranchTransition branchToDecrease;
        ProbabilisticBranchTransition branchToIncrease;
        Iterator<Map.Entry<LinkingResource, Double>> iterator = links.entrySet().iterator();
        LinkingResource link1 = iterator.next().getKey();
        LinkingResource link2 = iterator.next().getKey();
        double transmissionPower1 = this.modelAccess.retrieveTransmissionPower(sourceMote, link1);
        double transmissionPower2 = this.modelAccess.retrieveTransmissionPower(sourceMote, link2);
        List<ProbabilisticBranchTransition> branchesToAdapt = this.modelAccess.retrieveCommunicatingBranches(sourceMote);
        if (transmissionPower1 > transmissionPower2) {
            branchToIncrease = this.isPhysicalLink(branchesToAdapt.get(0), link2) ? branchesToAdapt.get(0) : branchesToAdapt.get(1);
            branchToDecrease = this.isPhysicalLink(branchesToAdapt.get(0), link1) ? branchesToAdapt.get(0) : branchesToAdapt.get(1);
        } else {
            branchToIncrease = this.isPhysicalLink(branchesToAdapt.get(0), link1) ? branchesToAdapt.get(0) : branchesToAdapt.get(1);
            branchToDecrease = this.isPhysicalLink(branchesToAdapt.get(0), link2) ? branchesToAdapt.get(0) : branchesToAdapt.get(1);
        }
        this.increaseDistributionFactor(branchToIncrease, branchToDecrease, disFactorReconf);
    }

    private boolean isPhysicalLink(ProbabilisticBranchTransition probabilisticBranchTransition, LinkingResource physicalLink) {
        String usedLinkId = probabilisticBranchTransition.getEntityName().substring(probabilisticBranchTransition.getEntityName().length() - 1);
        return physicalLink.getEntityName().endsWith(usedLinkId);
    }

    private Map<AssemblyContext, Map<LinkingResource, Double>> filterMotesWithWirelessLinks(PcmSelfAdaptiveSystemState<QVTOReconfigurator, List<InputValue<CategoricalValue>>> state) {
        return this.filterLinksWithSNR(state).entrySet().stream().collect(Collectors.groupingBy(this.equalSourceMote(state), Collectors.mapping(Function.identity(), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
    }

    private Map<LinkingResource, Double> filterLinksWithSNR(PcmSelfAdaptiveSystemState<QVTOReconfigurator, List<InputValue<CategoricalValue>>> state) {
        return DeltaIoTBaseEnvironemtalDynamics.toInputs(state.getPerceivedEnvironmentalState().getValue().getValue()).stream().filter(each -> DeltaIoTBaseEnvironemtalDynamics.isSNRTemplate(each.getVariable())).collect(Collectors.toMap(k -> (LinkingResource)k.getVariable().getAppliedObjects().get(0), v -> this.getSNR((InputValue<CategoricalValue>)v)));
    }

    private Double getSNR(InputValue<CategoricalValue> input) {
        String value = (String)((CategoricalValue)input.getValue()).get();
        return Double.valueOf(value);
    }

    private Function<Map.Entry<LinkingResource, Double>, AssemblyContext> equalSourceMote(PcmSelfAdaptiveSystemState<QVTOReconfigurator, List<InputValue<CategoricalValue>>> state) {
        return entry -> this.modelAccess.findSourceMote((LinkingResource)entry.getKey(), (ArchitecturalConfiguration<PCMInstance, QVTOReconfigurator>)state.getArchitecturalConfiguration());
    }

    private static class WirelessLinkFilter {
        private final Map<LinkingResource, Double> linksWithSNRValue;

        public WirelessLinkFilter(Map<LinkingResource, Double> linksWithSNRValue) {
            this.linksWithSNRValue = linksWithSNRValue;
        }

        public List<LinkingResource> linksWithSNRLowerThan(Threshold lowerBound) {
            return this.orderBySNRValue(this.linksWithSNRValue).stream().takeWhile(each -> lowerBound.isSatisfied(((Double)each.getValue()).doubleValue())).map(each -> (LinkingResource)each.getKey()).collect(Collectors.toList());
        }

        public List<LinkingResource> linksWithSNRHigherThan(Threshold upperBound) {
            return this.orderBySNRValue(this.linksWithSNRValue).stream().dropWhile(each -> upperBound.isNotSatisfied(((Double)each.getValue()).doubleValue())).map(each -> (LinkingResource)each.getKey()).collect(Collectors.toList());
        }

        public LinkingResource linkWithHighestSNR() {
            return this.orderBySNRValue(this.linksWithSNRValue).get(0).getKey();
        }

        private List<Map.Entry<LinkingResource, Double>> orderBySNRValue(Map<LinkingResource, Double> links) {
            return links.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toList());
        }
    }
}

