/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot.strategy;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.simexp.core.strategy.SharedKnowledge;
import org.palladiosimulator.simexp.core.util.Threshold;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.DeltaIoTModelAccess;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class MoteContext {
    private final DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess;
    public final AssemblyContext mote;
    public final Set<WirelessLink> links;

    public MoteContext(DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess, AssemblyContext mote, Map<LinkingResource, Double> linkToSNR) {
        this.modelAccess = modelAccess;
        this.mote = mote;
        this.links = this.initLinks(mote, linkToSNR);
    }

    private Set<WirelessLink> initLinks(AssemblyContext mote, Map<LinkingResource, Double> linkToSNR) {
        LinkedHashSet links = Sets.newLinkedHashSet();
        for (LinkingResource each : linkToSNR.keySet()) {
            Double SNR = linkToSNR.get(each);
            int transmissionPower = this.modelAccess.retrieveTransmissionPower(mote, each);
            Double distFactor = this.modelAccess.retrieveCommunicatingBranch(mote, each).map(ProbabilisticBranchTransition::getBranchProbability).orElse(1.0);
            links.add(new WirelessLink(each, SNR, transmissionPower, distFactor));
        }
        return links;
    }

    public boolean hasTwoLinks() {
        return this.links.size() == 2;
    }

    public boolean hasEqualTransmissionPower() {
        if (!this.hasTwoLinks()) {
            return false;
        }
        Iterator<WirelessLink> linkQuantityIterator = this.links.iterator();
        int tp1 = linkQuantityIterator.next().transmissionPower;
        int tp2 = linkQuantityIterator.next().transmissionPower;
        return tp1 == tp2;
    }

    public boolean hasUnequalTransmissionPower() {
        return !this.hasEqualTransmissionPower();
    }

    public String getId() {
        return this.mote.getId();
    }

    public static class MoteContextFilter {
        private final List<MoteContext> contexts;

        public MoteContextFilter(SharedKnowledge knowledge) {
            this.contexts = knowledge.getValues().stream().filter(MoteContext.class::isInstance).map(MoteContext.class::cast).collect(Collectors.toList());
        }

        public List<MoteContext> getAllMoteContexts() {
            return this.contexts;
        }

        public List<MoteContext> motesWithTwoLinks() {
            return this.contexts.stream().filter(MoteContext::hasTwoLinks).collect(Collectors.toList());
        }

        public Map<MoteContext, WirelessLink> motesWithSNRLowerThan(Threshold lowerBound) {
            HashMap result = Maps.newHashMap();
            for (MoteContext each : this.contexts) {
                this.linksWithSNRLowerThan(lowerBound, each).forEach(link -> {
                    WirelessLink wirelessLink = result.put(each, link);
                });
            }
            return result;
        }

        public Map<MoteContext, WirelessLink> motesWithSNRHigherThan(Threshold lowerBound) {
            HashMap result = Maps.newHashMap();
            for (MoteContext each : this.contexts) {
                this.linksWithSNRHigherThan(lowerBound, each).forEach(link -> {
                    WirelessLink wirelessLink = result.put(each, link);
                });
            }
            return result;
        }

        public WirelessLink linkWithSmallestSNR(MoteContext mote) {
            return this.orderBySNRValue(mote.links).get(0);
        }

        public WirelessLink linkWithHighestTransmissionPower(MoteContext mote) {
            List<WirelessLink> values = this.orderByTransmissionPowerValue(mote.links);
            return values.get(values.size() - 1);
        }

        private List<WirelessLink> linksWithSNRLowerThan(Threshold lowerBound, MoteContext mote) {
            return this.orderBySNRValue(mote.links).stream().takeWhile(each -> lowerBound.isSatisfied(each.SNR)).collect(Collectors.toList());
        }

        private List<WirelessLink> linksWithSNRHigherThan(Threshold upperBound, MoteContext mote) {
            return this.orderBySNRValue(mote.links).stream().dropWhile(each -> upperBound.isNotSatisfied(each.SNR)).collect(Collectors.toList());
        }

        private List<WirelessLink> orderBySNRValue(Set<WirelessLink> links) {
            Comparator<WirelessLink> snrComparator = new Comparator<WirelessLink>(){

                @Override
                public int compare(WirelessLink l1, WirelessLink l2) {
                    return Double.compare(l1.SNR, l2.SNR);
                }
            };
            List<WirelessLink> result = this.orderBy(snrComparator, links);
            return result;
        }

        private List<WirelessLink> orderByTransmissionPowerValue(Set<WirelessLink> links) {
            Comparator<WirelessLink> tpComparator = new Comparator<WirelessLink>(){

                @Override
                public int compare(WirelessLink l1, WirelessLink l2) {
                    return Double.compare(l1.transmissionPower, l2.transmissionPower);
                }
            };
            return this.orderBy(tpComparator, links);
        }

        private List<WirelessLink> orderBy(Comparator<WirelessLink> linkComparator, Set<WirelessLink> links) {
            return links.stream().sorted(linkComparator).collect(Collectors.toList());
        }
    }

    public static class WirelessLink {
        public final LinkingResource pcmLink;
        public final double SNR;
        public final int transmissionPower;
        public final double distributionFactor;

        private WirelessLink(LinkingResource pcmLink, double SNR, int transmissionPower, double distributionFactor) {
            this.pcmLink = pcmLink;
            this.SNR = SNR;
            this.transmissionPower = transmissionPower;
            this.distributionFactor = distributionFactor;
        }
    }
}

