/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot.util;

import de.uka.ipd.sdq.identifier.Identifier;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.simexp.core.strategy.SharedKnowledge;
import org.palladiosimulator.simexp.core.util.Threshold;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.DeltaIoTBaseEnvironemtalDynamics;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.DeltaIoTModelAccess;
import org.palladiosimulator.simexp.pcm.state.PcmSelfAdaptiveSystemState;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import org.palladiosimulator.solver.core.models.PCMInstance;
import tools.mdsd.probdist.api.entity.CategoricalValue;

public class DeltaIoTCommons {
    public static final String STATE_KEY = "PCM_STATE";
    public static final String OPTIONS_KEY = "OPTIONS";
    public static final String PACKET_LOSS_KEY = "PacketLoss";
    public static final String ENERGY_CONSUMPTION_KEY = "EnergyConsumption";
    public static final double UPPER_BOUND_PACKET_LOSS = 0.2;
    public static final double LOWER_BOUND_PACKET_LOSS = 0.025;
    public static final double BOUND_PACKET_LOSS = 0.1;
    public static final Threshold LOWER_PACKET_LOSS = Threshold.lessThan((double)0.1);
    public static final double UPPER_BOUND_ENERGY_CONSUMPTION = 34.5;
    public static final double AVG_BOUND_ENERGY_CONSUMPTION = 32.0;
    public static final double LOWER_BOUND_ENERGY_CONSUMPTION = 30.5;
    public static final Threshold LOWER_ENERGY_CONSUMPTION = Threshold.lessThan((double)32.0);
    public static final double DISTRIBUTION_FACTOR_INCREMENT = 0.1;
    public static final int TRANSMISSION_POWER_INCREMENT = 1;
    public static final String PRISM_PACKET_LOSS_PROPERTY = "P=? [ F \"Packetloss\" ]";
    public static final String PRISM_ENERGY_CONSUMPTION_PROPERTY = "Rmax=? [ F \"EnergyConsumption\" ]";

    public static PcmSelfAdaptiveSystemState findPcmState(SharedKnowledge knowledge) {
        return (PcmSelfAdaptiveSystemState)knowledge.getValue(STATE_KEY).orElseThrow();
    }

    public static void requirePcmSelfAdaptiveSystemState(State source) {
        if (!PcmSelfAdaptiveSystemState.class.isInstance(source)) {
            throw new RuntimeException("The self-adaptive system state is not a PCM-based.");
        }
    }

    public static Map<AssemblyContext, Map<LinkingResource, Double>> filterMotesWithWirelessLinks(DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess, PcmSelfAdaptiveSystemState state) {
        Comparator<AssemblyContext> comparator = Comparator.comparing(Identifier::getId);
        TreeMap<AssemblyContext, Map<LinkingResource, Double>> result = new TreeMap<AssemblyContext, Map<LinkingResource, Double>>(comparator);
        Function<Map.Entry<LinkingResource, Double>, AssemblyContext> classifier = DeltaIoTCommons.equalSourceMote(modelAccess, state);
        Map<LinkingResource, Double> linksWithSNRMap = DeltaIoTCommons.filterLinksWithSNR(state);
        for (Map.Entry<LinkingResource, Double> entry : linksWithSNRMap.entrySet()) {
            AssemblyContext context = classifier.apply(entry);
            TreeMap<LinkingResource, Double> linkResourceMap = (TreeMap<LinkingResource, Double>)result.get(context);
            if (linkResourceMap == null) {
                Comparator<LinkingResource> lrComparator = Comparator.comparing(Identifier::getId);
                linkResourceMap = new TreeMap<LinkingResource, Double>(lrComparator);
            }
            linkResourceMap.put(entry.getKey(), entry.getValue());
            result.put(context, linkResourceMap);
        }
        return result;
    }

    private static Map<LinkingResource, Double> filterLinksWithSNR(PcmSelfAdaptiveSystemState state) {
        List<InputValue<CategoricalValue>> inputList = DeltaIoTBaseEnvironemtalDynamics.toInputs(state.getPerceivedEnvironmentalState().getValue().getValue());
        Comparator<LinkingResource> comparator = Comparator.comparing(Identifier::getId);
        TreeMap<LinkingResource, Double> result = new TreeMap<LinkingResource, Double>(comparator);
        for (InputValue<CategoricalValue> inputValue : inputList) {
            if (!DeltaIoTBaseEnvironemtalDynamics.isSNRTemplate(inputValue.getVariable())) continue;
            LinkingResource lr = (LinkingResource)inputValue.getVariable().getAppliedObjects().get(0);
            result.put(lr, DeltaIoTCommons.getSNR(inputValue));
        }
        return result;
    }

    private static Double getSNR(InputValue input) {
        String value = (String)((CategoricalValue)CategoricalValue.class.cast(input.getValue())).get();
        return Double.valueOf(value);
    }

    private static Function<Map.Entry<LinkingResource, Double>, AssemblyContext> equalSourceMote(DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess, PcmSelfAdaptiveSystemState state) {
        return entry -> modelAccess.findSourceMote((LinkingResource)entry.getKey(), state.getArchitecturalConfiguration());
    }
}

