/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot.util;

import com.google.common.collect.Maps;
import de.uka.ipd.sdq.stoex.VariableReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.param.reconfigurationparams.DeltaIoTReconfigurationParamRepository;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.strategy.MoteContext;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.DeltaIoTModelAccess;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.ReconfigurationParameterManager;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class ReconfigurationParameterCalculator {
    private final ReconfigurationParameterManager paramManager;
    private final DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess;

    public ReconfigurationParameterCalculator(DeltaIoTReconfigurationParamRepository reconfParamsRepo, DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess) {
        this.paramManager = new ReconfigurationParameterManager(reconfParamsRepo, modelAccess);
        this.modelAccess = modelAccess;
    }

    public Map<VariableReference, Integer> computeIncreasedTransmissionPower(AssemblyContext mote, MoteContext.WirelessLink link) {
        return this.computeAdjustedTransmissionPower(mote, link, 1);
    }

    public Map<VariableReference, Integer> computeDecreasedTransmissionPower(AssemblyContext mote, MoteContext.WirelessLink link) {
        return this.computeAdjustedTransmissionPower(mote, link, -1);
    }

    public Map<ProbabilisticBranchTransition, Double> computeAdjustedDistributionFactors(MoteContext.WirelessLink linkToDecrease, MoteContext context) {
        ProbabilisticBranchTransition branchToDecrease;
        ProbabilisticBranchTransition branchToIncrease;
        List<ProbabilisticBranchTransition> branchesToAdapt = this.modelAccess.retrieveCommunicatingBranches(context.mote);
        if (this.modelAccess.isPhysicalLink(branchesToAdapt.get(0), linkToDecrease.pcmLink)) {
            branchToIncrease = this.paramManager.findBranchWith(branchesToAdapt.get(1).getEntityName());
            branchToDecrease = this.paramManager.findBranchWith(branchesToAdapt.get(0).getEntityName());
        } else {
            branchToIncrease = this.paramManager.findBranchWith(branchesToAdapt.get(0).getEntityName());
            branchToDecrease = this.paramManager.findBranchWith(branchesToAdapt.get(1).getEntityName());
        }
        HashMap factors = Maps.newHashMap();
        factors.put(branchToDecrease, -0.1);
        factors.put(branchToIncrease, 0.1);
        return factors;
    }

    private Map<VariableReference, Integer> computeAdjustedTransmissionPower(AssemblyContext mote, MoteContext.WirelessLink link, int adjustement) {
        HashMap powerSettings = Maps.newHashMap();
        EList varUsages = mote.getConfigParameterUsages__AssemblyContext();
        for (VariableUsage each : varUsages) {
            if (!this.modelAccess.isTransmissionPowerOfLink(each, link.pcmLink)) continue;
            String varRef = each.getNamedReference__VariableUsage().getReferenceName();
            powerSettings.put(this.paramManager.findVariableReferenceWith(varRef), adjustement);
        }
        return powerSettings;
    }
}

