/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.hri;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurementSpecification;
import org.palladiosimulator.simexp.core.strategy.SharedKnowledge;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.pcm.action.EmptyQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.hri.ReliabilityPrioritizedStrategy;

public class RandomizedAdaptationStrategy<C>
extends ReliabilityPrioritizedStrategy<C> {
    private final Random random = new Random();

    public RandomizedAdaptationStrategy(SimulatedMeasurementSpecification responseTimeSpec, double thresholdRt) {
        super(responseTimeSpec, thresholdRt);
    }

    @Override
    public String getId() {
        return "RandomizedAdaptationStrategy";
    }

    @Override
    protected boolean analyse(State source, SharedKnowledge knowledge) {
        return true;
    }

    @Override
    protected QVToReconfiguration plan(State source, Set<QVToReconfiguration> options, SharedKnowledge knowledge) {
        ArrayList availableOptions = Lists.newArrayList();
        availableOptions.add("EmptyReconf");
        if (this.isFilteringActivated) {
            availableOptions.add("DeactivateFilterComponent");
        } else {
            availableOptions.add("ActivateFilterComponent");
        }
        if (this.isDefaultMLModelActivated) {
            availableOptions.add("SwitchToRobustMLModel");
        } else {
            availableOptions.add("SwitchToDefaultMLModel");
        }
        String randomlySelect = (String)availableOptions.get(this.random.nextInt(3));
        if (randomlySelect.equals("ActivateFilterComponent")) {
            return this.activateFilteringReconfiguration(options);
        }
        if (randomlySelect.equals("DeactivateFilterComponent")) {
            return this.deactivateFilteringReconfiguration(options);
        }
        if (randomlySelect.equals("SwitchToDefaultMLModel")) {
            return this.switchToDefaultMLModel(options);
        }
        if (randomlySelect.equals("SwitchToRobustMLModel")) {
            return this.switchToRobustMLModel(options);
        }
        return EmptyQVToReconfiguration.empty();
    }
}

