/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.hri;

import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.dependability.reliability.uncertainty.UncertaintyRepository;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.api.UncertaintyBasedReliabilityPredictionConfig;
import org.palladiosimulator.envdyn.api.entity.bn.DynamicBayesianNetwork;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.experimentautomation.experiments.Experiment;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurementSpecification;
import org.palladiosimulator.simexp.core.evaluation.ExpectedRewardEvaluator;
import org.palladiosimulator.simexp.core.evaluation.TotalRewardCalculation;
import org.palladiosimulator.simexp.core.process.ExperienceSimulator;
import org.palladiosimulator.simexp.core.reward.RewardEvaluator;
import org.palladiosimulator.simexp.core.state.SimulationRunnerHolder;
import org.palladiosimulator.simexp.core.store.SimulatedExperienceStore;
import org.palladiosimulator.simexp.core.strategy.ReconfigurationStrategy;
import org.palladiosimulator.simexp.core.util.SimulatedExperienceConstants;
import org.palladiosimulator.simexp.environmentaldynamics.process.EnvironmentProcess;
import org.palladiosimulator.simexp.markovian.activity.Policy;
import org.palladiosimulator.simexp.pcm.action.IQVToReconfigurationManager;
import org.palladiosimulator.simexp.pcm.action.IQVToReconfigurationProvider;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.config.ITransformationConfiguration;
import org.palladiosimulator.simexp.pcm.examples.executor.ModelLoader;
import org.palladiosimulator.simexp.pcm.examples.executor.PcmExperienceSimulationExecutor;
import org.palladiosimulator.simexp.pcm.reliability.RealValuedRewardEvaluator;
import org.palladiosimulator.simexp.pcm.reliability.RobotCognitionBeforeExecutionInitialization;
import org.palladiosimulator.simexp.pcm.reliability.RobotCognitionEnvironmentalDynamics;
import org.palladiosimulator.simexp.pcm.reliability.StaticSystemSimulation;
import org.palladiosimulator.simexp.pcm.reliability.entity.PcmRelSimulatedMeasurementSpec;
import org.palladiosimulator.simexp.pcm.reliability.process.PcmRelExperienceSimulationRunner;
import org.palladiosimulator.simexp.pcm.simulator.SimulatorPcmExperienceSimulationExecutorFactory;
import org.palladiosimulator.simexp.pcm.simulator.config.IPCMWorkflowConfiguration;
import org.palladiosimulator.simexp.pcm.util.IExperimentProvider;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import org.palladiosimulator.solver.core.models.PCMInstance;
import org.palladiosimulator.solver.core.runconfig.PCMSolverWorkflowRunConfiguration;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.parser.ParameterParser;
import tools.mdsd.probdist.api.random.ISeedProvider;

public class RobotCognitionSimulationExecutorFactory
extends SimulatorPcmExperienceSimulationExecutorFactory<Double, List<InputValue<CategoricalValue>>> {
    public static final double UPPER_THRESHOLD_RT = 0.1;
    public static final double LOWER_THRESHOLD_REL = 0.9;
    public static final URI UNCERTAINTY_MODEL_URI = URI.createPlatformResourceURI((String)"/org.palladiosimulator.dependability.ml.hri/RobotCognitionUncertaintyModel.uncertainty", (boolean)true);

    public RobotCognitionSimulationExecutorFactory(IPCMWorkflowConfiguration workflowConfiguration, ModelLoader.Factory modelLoaderFactory, SimulatedExperienceStore<QVTOReconfigurator, Double> simulatedExperienceStore, Optional<ISeedProvider> seedProvider) {
        super(workflowConfiguration, modelLoaderFactory, simulatedExperienceStore, seedProvider);
    }

    protected PcmExperienceSimulationExecutor<PCMInstance, QVTOReconfigurator, QVToReconfiguration, Double> doCreate(Experiment experiment, DynamicBayesianNetwork<CategoricalValue> dbn) {
        EnvironmentProcess p;
        UsageScenario usageScenario = (UsageScenario)experiment.getInitialModel().getUsageModel().getUsageScenario_UsageModel().get(0);
        PcmRelSimulatedMeasurementSpec reliabilitySpec = new PcmRelSimulatedMeasurementSpec(usageScenario);
        List pcmMeasurementSpecs = this.createSpecs(experiment);
        ArrayList<PcmRelSimulatedMeasurementSpec> relSpecs = new ArrayList<PcmRelSimulatedMeasurementSpec>(pcmMeasurementSpecs);
        relSpecs.add(reliabilitySpec);
        ArrayList<PcmRelSimulatedMeasurementSpec> joinedSpecs = new ArrayList<PcmRelSimulatedMeasurementSpec>();
        joinedSpecs.addAll(pcmMeasurementSpecs);
        joinedSpecs.add(reliabilitySpec);
        UncertaintyBasedReliabilityPredictionConfig predictionConfig = new UncertaintyBasedReliabilityPredictionConfig(this.createDefaultRunConfig(), null, this.loadUncertaintyRepository(), null);
        ParameterParser parameterParser = this.getParameterParser();
        List<PcmRelExperienceSimulationRunner> runners = List.of(new PcmRelExperienceSimulationRunner(predictionConfig, this.getProbabilityDistributionRegistry(), this.getDistributionFactory(), parameterParser, this.getProbDistRepoLookup(), this.getSeedProvider()));
        StaticSystemSimulation reconfSelectionPolicy = new StaticSystemSimulation();
        IQVToReconfigurationManager qvtoReconfigurationManager = this.createQvtoReconfigurationManager(experiment, (ITransformationConfiguration)this.getWorkflowConfiguration());
        IExperimentProvider experimentProvider = this.createExperimentProvider(experiment);
        ArrayList<RobotCognitionBeforeExecutionInitialization> beforeExecutionInitializables = new ArrayList<RobotCognitionBeforeExecutionInitialization>();
        RobotCognitionBeforeExecutionInitialization beforeExecutionInitializable = new RobotCognitionBeforeExecutionInitialization((ReconfigurationStrategy)reconfSelectionPolicy, experimentProvider, qvtoReconfigurationManager);
        beforeExecutionInitializables.add(beforeExecutionInitializable);
        RobotCognitionEnvironmentalDynamics envDynamics = new RobotCognitionEnvironmentalDynamics(dbn);
        envDynamics.init(this.getSeedProvider());
        EnvironmentProcess envProcess = p = envDynamics.getEnvironmentProcess();
        RealValuedRewardEvaluator evaluator = new RealValuedRewardEvaluator((SimulatedMeasurementSpecification)reliabilitySpec);
        IQVToReconfigurationProvider qvToReconfigurationProvider = qvtoReconfigurationManager.getQVToReconfigurationProvider();
        Set reconfigurations = qvToReconfigurationProvider.getReconfigurations();
        SimulationRunnerHolder simulationRunnerHolder = this.createSimulationRunnerHolder();
        ExperienceSimulator simulator = this.createExperienceSimulator(experiment, joinedSpecs, runners, this.getSimulationParameters(), beforeExecutionInitializables, envProcess, this.getSimulatedExperienceStore(), null, (Policy)reconfSelectionPolicy, reconfigurations, (RewardEvaluator)evaluator, true, experimentProvider, simulationRunnerHolder, null, this.getSeedProvider());
        String sampleSpaceId = SimulatedExperienceConstants.constructSampleSpaceId((String)this.getSimulationParameters().getSimulationID(), (String)reconfSelectionPolicy.getId());
        ExpectedRewardEvaluator rewardCalculation = new ExpectedRewardEvaluator(this.getSimulationParameters().getSimulationID(), sampleSpaceId);
        return new PcmExperienceSimulationExecutor(simulator, experiment, this.getSimulationParameters(), (Policy)reconfSelectionPolicy, (TotalRewardCalculation)rewardCalculation, experimentProvider);
    }

    private PCMSolverWorkflowRunConfiguration createDefaultRunConfig() {
        PCMSolverWorkflowRunConfiguration config = new PCMSolverWorkflowRunConfiguration();
        config.setReliabilityAnalysis(true);
        config.setPrintMarkovStatistics(false);
        config.setPrintMarkovSingleResults(false);
        config.setSensitivityModelEnabled(false);
        config.setSensitivityModelFileName(null);
        config.setSensitivityLogFileName(null);
        config.setDeleteTemporaryDataAfterAnalysis(true);
        config.setDistance(1.0);
        config.setDomainSize(32);
        config.setIterationOverPhysicalSystemStatesEnabled(true);
        config.setMarkovModelReductionEnabled(true);
        config.setNumberOfEvaluatedSystemStates(1L);
        config.setNumberOfEvaluatedSystemStatesEnabled(false);
        config.setSolvingTimeLimitEnabled(false);
        config.setLogFile(null);
        config.setNumberOfEvaluatedSystemStatesEnabled(false);
        config.setNumberOfEvaluatedSystemStates(0L);
        config.setNumberOfExactDecimalPlacesEnabled(false);
        config.setNumberOfExactDecimalPlaces(0);
        config.setSolvingTimeLimitEnabled(false);
        config.setMarkovModelStorageEnabled(false);
        config.setIterationOverPhysicalSystemStatesEnabled(true);
        config.setMarkovEvaluationMode("POINTSOFFAILURE");
        config.setSaveResultsToFileEnabled(false);
        config.setRMIMiddlewareFile("pathmap://PCM_MODELS/Glassfish.repository");
        config.setEventMiddlewareFile("pathmap://PCM_MODELS/default_event_middleware.repository");
        return config;
    }

    private UncertaintyRepository loadUncertaintyRepository() {
        ResourceSetPartition partition = new ResourceSetPartition();
        partition.loadModel(UNCERTAINTY_MODEL_URI);
        partition.resolveAllProxies();
        return (UncertaintyRepository)partition.getFirstContentElement(UNCERTAINTY_MODEL_URI);
    }
}

