/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.hri;

import java.util.List;
import java.util.Set;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariable;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurement;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurementSpecification;
import org.palladiosimulator.simexp.core.process.Initializable;
import org.palladiosimulator.simexp.core.state.SelfAdaptiveSystemState;
import org.palladiosimulator.simexp.core.state.StateQuantity;
import org.palladiosimulator.simexp.core.strategy.ReconfigurationStrategy;
import org.palladiosimulator.simexp.core.strategy.SharedKnowledge;
import org.palladiosimulator.simexp.core.util.Threshold;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.pcm.action.EmptyQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.reliability.RobotCognitionEnvironmentalDynamics;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import tools.mdsd.probdist.api.entity.CategoricalValue;

public class ReliabilityPrioritizedStrategy<C>
extends ReconfigurationStrategy<QVTOReconfigurator, QVToReconfiguration>
implements Initializable {
    private static final String IMG_BRIGHTNESS_TEMPLATE = "_U5Fzu8qkEeqObY-eK2jOOA";
    private static final String IMG_NOISE_TEMPLATE = "_0uh4oCpGEeuMpaabmuiN-Q";
    private final SimulatedMeasurementSpecification responseTimeSpec;
    private final Threshold thresholdRt;
    protected boolean isDefaultMLModelActivated = true;
    protected boolean isFilteringActivated = false;

    public ReliabilityPrioritizedStrategy(SimulatedMeasurementSpecification responseTimeSpec, double thresholdRt) {
        super(null);
        this.responseTimeSpec = responseTimeSpec;
        this.thresholdRt = Threshold.lessThanOrEqualTo((double)thresholdRt);
    }

    public String getId() {
        return "ReliabilityPrioritizedStrategy";
    }

    protected void monitor(State source, SharedKnowledge knowledge) {
        SelfAdaptiveSystemState sasState = (SelfAdaptiveSystemState)source;
        StateQuantity stateQuantity = sasState.getQuantifiedState();
        SimulatedMeasurement rtSimMeasurement = (SimulatedMeasurement)stateQuantity.findMeasurementWith(this.responseTimeSpec).orElseThrow();
        knowledge.store(this.responseTimeSpec.getId(), (Object)rtSimMeasurement);
        List envState = (List)sasState.getPerceivedEnvironmentalState().getValue().getValue();
        for (InputValue each : RobotCognitionEnvironmentalDynamics.toInputs((Object)envState)) {
            TemplateVariable template = each.getVariable().getInstantiatedTemplate();
            if (template.getId().equals(IMG_BRIGHTNESS_TEMPLATE)) {
                knowledge.store(IMG_BRIGHTNESS_TEMPLATE, (Object)each.getValue());
                continue;
            }
            if (!template.getId().equals(IMG_NOISE_TEMPLATE)) continue;
            knowledge.store(IMG_NOISE_TEMPLATE, (Object)each.getValue());
        }
    }

    protected boolean analyse(State source, SharedKnowledge knowledge) {
        boolean isImgBrightnessIncreased;
        boolean isSensorNoiseIncreased;
        SimulatedMeasurement rtSimMeasurement = knowledge.getValue(this.responseTimeSpec.getId()).map(SimulatedMeasurement.class::cast).get();
        boolean isResponseTimeNotSatisfied = this.thresholdRt.isNotSatisfied(rtSimMeasurement.getValue());
        if (isResponseTimeNotSatisfied) {
            return true;
        }
        CategoricalValue sensorNoise = knowledge.getValue(IMG_NOISE_TEMPLATE).map(CategoricalValue.class::cast).get();
        boolean bl = isSensorNoiseIncreased = !((String)sensorNoise.get()).equals("(SensorNoise=Low)");
        if (isSensorNoiseIncreased) {
            return true;
        }
        CategoricalValue imgBrightness = knowledge.getValue(IMG_BRIGHTNESS_TEMPLATE).map(CategoricalValue.class::cast).get();
        boolean bl2 = isImgBrightnessIncreased = !((String)imgBrightness.get()).equals("(ImageBrightnessMeasure=Medium)");
        return isImgBrightnessIncreased;
    }

    protected QVToReconfiguration plan(State source, Set<QVToReconfiguration> options, SharedKnowledge knowledge) {
        boolean isImgBrightnessIncreased;
        CategoricalValue sensorNoise = knowledge.getValue(IMG_NOISE_TEMPLATE).map(CategoricalValue.class::cast).get();
        boolean isSensorNoiseIncreased = !((String)sensorNoise.get()).equals("(SensorNoise=Low)");
        CategoricalValue imgBrightness = knowledge.getValue(IMG_BRIGHTNESS_TEMPLATE).map(CategoricalValue.class::cast).get();
        boolean bl = isImgBrightnessIncreased = !((String)imgBrightness.get()).equals("(ImageBrightnessMeasure=Medium)");
        if (isSensorNoiseIncreased || isImgBrightnessIncreased) {
            return this.manageReliability(isSensorNoiseIncreased, isImgBrightnessIncreased, options);
        }
        SimulatedMeasurement rtSimMeasurement = knowledge.getValue(this.responseTimeSpec.getId()).map(SimulatedMeasurement.class::cast).get();
        boolean isResponseTimeNotSatisfied = this.thresholdRt.isNotSatisfied(rtSimMeasurement.getValue());
        if (isResponseTimeNotSatisfied) {
            return this.managePerformance(options);
        }
        return EmptyQVToReconfiguration.empty();
    }

    protected QVToReconfiguration emptyReconfiguration() {
        return EmptyQVToReconfiguration.empty();
    }

    public void initialize() {
        this.isDefaultMLModelActivated = true;
        this.isFilteringActivated = false;
    }

    private QVToReconfiguration manageReliability(boolean isSensorNoiseIncreased, boolean isImgBrightnessIncreased, Set<QVToReconfiguration> options) {
        boolean bothValuesIncreased;
        boolean bl = bothValuesIncreased = isSensorNoiseIncreased && isImgBrightnessIncreased;
        if (bothValuesIncreased && this.isDefaultMLModelActivated) {
            return this.switchToRobustMLModel(options);
        }
        if (isSensorNoiseIncreased && !this.isFilteringActivated) {
            return this.activateFilteringReconfiguration(options);
        }
        return EmptyQVToReconfiguration.empty();
    }

    private QVToReconfiguration managePerformance(Set<QVToReconfiguration> options) {
        if (!this.isDefaultMLModelActivated) {
            return this.switchToDefaultMLModel(options);
        }
        if (this.isFilteringActivated) {
            return this.deactivateFilteringReconfiguration(options);
        }
        return EmptyQVToReconfiguration.empty();
    }

    protected QVToReconfiguration activateFilteringReconfiguration(Set<QVToReconfiguration> options) {
        this.isFilteringActivated = true;
        return this.selectOptionWith("ActivateFilterComponent", options);
    }

    protected QVToReconfiguration deactivateFilteringReconfiguration(Set<QVToReconfiguration> options) {
        this.isFilteringActivated = false;
        return this.selectOptionWith("DeactivateFilterComponent", options);
    }

    protected QVToReconfiguration switchToRobustMLModel(Set<QVToReconfiguration> options) {
        this.isDefaultMLModelActivated = false;
        return this.selectOptionWith("SwitchToRobustMLModel", options);
    }

    protected QVToReconfiguration switchToDefaultMLModel(Set<QVToReconfiguration> options) {
        this.isDefaultMLModelActivated = true;
        return this.selectOptionWith("SwitchToDefaultMLModel", options);
    }

    private QVToReconfiguration selectOptionWith(String queriedName, Set<QVToReconfiguration> options) {
        for (QVToReconfiguration each : options) {
            String reconfName = each.getReconfigurationName();
            if (!reconfName.equals(queriedName)) continue;
            return each;
        }
        throw new RuntimeException("");
    }
}

