/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.hri;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurement;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurementSpecification;
import org.palladiosimulator.simexp.core.process.Initializable;
import org.palladiosimulator.simexp.core.state.SelfAdaptiveSystemState;
import org.palladiosimulator.simexp.core.state.StateQuantity;
import org.palladiosimulator.simexp.core.util.Threshold;
import org.palladiosimulator.simexp.markovian.activity.Policy;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Action;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.pcm.action.EmptyQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;

public class RobotCognitionReconfigurationStrategy<C>
implements Policy<QVTOReconfigurator, Action<QVTOReconfigurator>>,
Initializable {
    private final Threshold thresholdRt;
    private final Threshold thresholdRel;
    private final SimulatedMeasurementSpecification reliabilitySpec;
    private final SimulatedMeasurementSpecification responseTimeSpec;
    private boolean isDefaultMLModelActivated = true;
    private boolean isFilteringActivated = false;

    public RobotCognitionReconfigurationStrategy(SimulatedMeasurementSpecification reliabilitySpec, SimulatedMeasurementSpecification responseTimeSpec, double thresholdRt, double thresholdRel) {
        this.reliabilitySpec = reliabilitySpec;
        this.responseTimeSpec = responseTimeSpec;
        this.thresholdRt = Threshold.lessThanOrEqualTo((double)thresholdRt);
        this.thresholdRel = Threshold.greaterThanOrEqualTo((double)thresholdRel);
    }

    public void initialize() {
        this.isDefaultMLModelActivated = true;
        this.isFilteringActivated = false;
    }

    public String getId() {
        return "SimpleStrategy";
    }

    public Action<QVTOReconfigurator> select(State source, Set<Action<QVTOReconfigurator>> options) {
        if (!(source instanceof SelfAdaptiveSystemState)) {
            throw new RuntimeException("");
        }
        StateQuantity stateQuantity = ((SelfAdaptiveSystemState)source).getQuantifiedState();
        SimulatedMeasurement relSimMeasurement = (SimulatedMeasurement)stateQuantity.findMeasurementWith(this.reliabilitySpec).orElseThrow();
        SimulatedMeasurement rtSimMeasurement = (SimulatedMeasurement)stateQuantity.findMeasurementWith(this.responseTimeSpec).orElseThrow();
        boolean isReliabilityNotSatisfied = this.thresholdRel.isNotSatisfied(relSimMeasurement.getValue());
        boolean isResponseTimeNotSatisfied = this.thresholdRt.isNotSatisfied(rtSimMeasurement.getValue());
        if (isReliabilityNotSatisfied) {
            return this.manageReliability(this.asReconfigurations(options));
        }
        if (isResponseTimeNotSatisfied) {
            return this.managePerformance(this.asReconfigurations(options));
        }
        return EmptyQVToReconfiguration.empty();
    }

    private Action<QVTOReconfigurator> manageReliability(List<QVToReconfiguration> options) {
        if (!this.isFilteringActivated) {
            return this.activateFilteringReconfiguration(options);
        }
        if (this.isDefaultMLModelActivated) {
            return this.switchToRobustMLModel(options);
        }
        return EmptyQVToReconfiguration.empty();
    }

    private Action<QVTOReconfigurator> managePerformance(List<QVToReconfiguration> options) {
        if (!this.isDefaultMLModelActivated) {
            return this.switchToDefaultMLModel(options);
        }
        if (this.isFilteringActivated) {
            return this.deactivateFilteringReconfiguration(options);
        }
        return EmptyQVToReconfiguration.empty();
    }

    private Action<QVTOReconfigurator> activateFilteringReconfiguration(List<QVToReconfiguration> options) {
        this.isFilteringActivated = true;
        return this.selectOptionWith("ActivateFilterComponent", options);
    }

    private Action<QVTOReconfigurator> deactivateFilteringReconfiguration(List<QVToReconfiguration> options) {
        this.isFilteringActivated = false;
        return this.selectOptionWith("DeactivateFilterComponent", options);
    }

    private Action<QVTOReconfigurator> switchToRobustMLModel(List<QVToReconfiguration> options) {
        this.isDefaultMLModelActivated = false;
        return this.selectOptionWith("SwitchToRobustMLModel", options);
    }

    private Action<QVTOReconfigurator> switchToDefaultMLModel(List<QVToReconfiguration> options) {
        this.isDefaultMLModelActivated = true;
        return this.selectOptionWith("SwitchToDefaultMLModel", options);
    }

    private Action<QVTOReconfigurator> selectOptionWith(String queriedName, List<QVToReconfiguration> options) {
        for (QVToReconfiguration each : options) {
            String reconfName = each.getReconfigurationName();
            if (!reconfName.equals(queriedName)) continue;
            return each;
        }
        throw new RuntimeException("");
    }

    private List<QVToReconfiguration> asReconfigurations(Set<Action<QVTOReconfigurator>> options) {
        return options.stream().map(each -> (QVToReconfiguration)each).collect(Collectors.toList());
    }
}

