/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.hri;

import com.google.common.collect.Lists;
import java.util.List;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurement;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurementSpecification;
import org.palladiosimulator.simexp.core.reward.SimpleRewardSignal;
import org.palladiosimulator.simexp.core.reward.ThresholdBasedRewardEvaluator;
import org.palladiosimulator.simexp.core.state.StateQuantity;
import org.palladiosimulator.simexp.core.util.Pair;
import org.palladiosimulator.simexp.core.util.Threshold;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Reward;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.impl.RewardImpl;

public class RobotCognitionRewardEvaluation
extends ThresholdBasedRewardEvaluator {
    private final Pair<SimulatedMeasurementSpecification, Threshold> responseTimeThreshold;
    private final Pair<SimulatedMeasurementSpecification, Threshold> reliabilityThreshold;

    public RobotCognitionRewardEvaluation(Pair<SimulatedMeasurementSpecification, Threshold> responseTimeThreshold, Pair<SimulatedMeasurementSpecification, Threshold> reliabilityThreshold) {
        super((List)Lists.newArrayList((Object[])new Pair[]{responseTimeThreshold, reliabilityThreshold}));
        this.responseTimeThreshold = responseTimeThreshold;
        this.reliabilityThreshold = reliabilityThreshold;
    }

    public Reward<Integer> evaluate(StateQuantity quantity) {
        Pair<SimulatedMeasurement, Threshold> relThreshold;
        boolean isRelSatisfied;
        List thresholds = this.filterThresholds(quantity);
        Pair<SimulatedMeasurement, Threshold> rtThreshold = this.findThreshold((SimulatedMeasurementSpecification)this.responseTimeThreshold.getFirst(), thresholds);
        boolean isRTSatisfied = ((Threshold)rtThreshold.getSecond()).isSatisfied(((SimulatedMeasurement)rtThreshold.getFirst()).getValue());
        if (Boolean.logicalAnd(isRTSatisfied, isRelSatisfied = ((Threshold)(relThreshold = this.findThreshold((SimulatedMeasurementSpecification)this.reliabilityThreshold.getFirst(), thresholds)).getSecond()).isSatisfied(((SimulatedMeasurement)relThreshold.getFirst()).getValue()))) {
            return SimpleRewardSignal.createPositivReward();
        }
        if (Boolean.logicalXor(isRTSatisfied, isRelSatisfied)) {
            return NeutralRewardSignal.create();
        }
        return SimpleRewardSignal.createNegativReward();
    }

    private Pair<SimulatedMeasurement, Threshold> findThreshold(SimulatedMeasurementSpecification spec, List<Pair<SimulatedMeasurement, Threshold>> thresholds) {
        return thresholds.stream().filter(t -> ((SimulatedMeasurement)t.getFirst()).getSpecification().getId().equals(spec.getId())).findFirst().get();
    }

    private static class NeutralRewardSignal
    extends RewardImpl<Integer> {
        private NeutralRewardSignal() {
            super.setValue((Object)0);
        }

        public static NeutralRewardSignal create() {
            return new NeutralRewardSignal();
        }

        public String toString() {
            return Integer.toString((Integer)this.getValue());
        }
    }
}

