/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.loadbalancing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurement;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurementSpecification;
import org.palladiosimulator.simexp.core.state.ArchitecturalConfiguration;
import org.palladiosimulator.simexp.core.state.SelfAdaptiveSystemState;
import org.palladiosimulator.simexp.core.util.Threshold;
import org.palladiosimulator.simexp.markovian.activity.Policy;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.pcm.action.EmptyQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.state.PcmMeasurementSpecification;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class LinearLoadBalancerStrategy<C, A>
implements Policy<QVTOReconfigurator, QVToReconfiguration> {
    private static final String LINEAR_ADAPTATION_STRATEGY_NAME = "LinearLoadBalancerAdaptationStrategy";
    private static final String OUT_SOURCE = "LinearOutsourcing";
    private static final String SCALE_IN = "LinearScaleIn";
    private static final double MAX_RT = 10.0;
    private static final double MAX_RECONFIGURATION_STEP = 0.5;
    private static final double SET_POINT_RT = 1.0;
    private static final Map<Predicate<Double>, Integer> balanceStepMap = new HashMap<Predicate<Double>, Integer>();
    private final Threshold setPointThreshold;
    private final PcmMeasurementSpecification pcmSpec;

    static {
        balanceStepMap.put(v -> v < 0.05, 0);
        balanceStepMap.put(v -> v >= 0.05 && v < 0.15, 1);
        balanceStepMap.put(v -> v >= 0.15 && v < 0.25, 2);
        balanceStepMap.put(v -> v >= 0.25 && v < 0.35, 3);
        balanceStepMap.put(v -> v >= 0.35 && v < 0.45, 4);
        balanceStepMap.put(v -> v >= 0.45, 5);
    }

    public LinearLoadBalancerStrategy(PcmMeasurementSpecification pcmSpec) {
        this.pcmSpec = pcmSpec;
        this.setPointThreshold = Threshold.greaterThan((double)1.0);
    }

    public QVToReconfiguration select(State source, Set<QVToReconfiguration> options) {
        if (!(source instanceof SelfAdaptiveSystemState)) {
            throw new RuntimeException("");
        }
        SelfAdaptiveSystemState sassState = (SelfAdaptiveSystemState)source;
        SimulatedMeasurement simMeasurement = (SimulatedMeasurement)sassState.getQuantifiedState().findMeasurementWith((SimulatedMeasurementSpecification)this.pcmSpec).orElseThrow(() -> new RuntimeException(""));
        Double value = simMeasurement.getValue();
        if (this.setPointThreshold.isSatisfied(value.doubleValue())) {
            int outSourceFactor = this.computeOutSourceFactor(value);
            outSourceFactor = this.adjustOutSourceFactor(outSourceFactor, sassState.getArchitecturalConfiguration());
            return this.linearOutSource(outSourceFactor, this.asReconfigurations(options));
        }
        int scaleInFactor = this.computeScaleInFactor(value);
        scaleInFactor = this.adjustScaleInFactor(scaleInFactor, sassState.getArchitecturalConfiguration());
        return this.linearScaleIn(scaleInFactor, this.asReconfigurations(options));
    }

    private int adjustOutSourceFactor(int outSourceFactor, ArchitecturalConfiguration<C, A> archConf) {
        PCMInstance pcm = (PCMInstance)archConf.getConfiguration();
        ProbabilisticBranchTransition probServer1 = this.findBranchProbability(pcm);
        double branchProb = probServer1.getBranchProbability();
        int i = outSourceFactor;
        while (i > 0) {
            double adjustedOSF = (double)i / 10.0;
            if (branchProb - adjustedOSF >= 0.5) {
                return i;
            }
            --i;
        }
        return 0;
    }

    private ProbabilisticBranchTransition findBranchProbability(PCMInstance pcm) {
        BasicComponent component = pcm.getRepositories().stream().flatMap(e -> e.getComponents__Repository().stream()).filter(e -> e instanceof BasicComponent).map(e -> (BasicComponent)e).filter(e -> e.getEntityName().equals("LoadBalancer")).findFirst().get();
        return this.findBranchProbability(component);
    }

    private ProbabilisticBranchTransition findBranchProbability(BasicComponent component) {
        TreeIterator iterator = component.eAllContents();
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            if (!this.branchProbabilityServer1().test(next)) continue;
            return (ProbabilisticBranchTransition)next;
        }
        throw new RuntimeException("Could not find the branch probability transition object.");
    }

    private Predicate<EObject> branchProbabilityServer1() {
        return e -> e instanceof ProbabilisticBranchTransition && ((ProbabilisticBranchTransition)e).getEntityName().equals("delegateToServer1");
    }

    private int computeOutSourceFactor(Double rt) {
        double outsourceFactor = this.getOutSourceSlope() * rt;
        return this.normalize(outsourceFactor);
    }

    private QVToReconfiguration linearOutSource(int outSourceFactor, List<QVToReconfiguration> options) {
        if (outSourceFactor == 0) {
            return EmptyQVToReconfiguration.empty();
        }
        String reconf = OUT_SOURCE + Integer.toString(outSourceFactor);
        return this.findReconfiguration(reconf, options);
    }

    private int adjustScaleInFactor(int scaleInFactor, ArchitecturalConfiguration<C, A> archConf) {
        PCMInstance pcm = (PCMInstance)archConf.getConfiguration();
        ProbabilisticBranchTransition probServer1 = this.findBranchProbability(pcm);
        double branchProb = probServer1.getBranchProbability();
        int i = scaleInFactor;
        while (i > 0) {
            double adjustedSIF = (double)i / 10.0;
            if (branchProb + adjustedSIF <= 1.0) {
                return i;
            }
            --i;
        }
        return 0;
    }

    private int computeScaleInFactor(Double rt) {
        double scaleInFactor = this.getScaleInSlope() * rt;
        return this.normalize(scaleInFactor);
    }

    private QVToReconfiguration linearScaleIn(int scaleInFactor, List<QVToReconfiguration> options) {
        if (scaleInFactor == 0) {
            return EmptyQVToReconfiguration.empty();
        }
        String reconf = SCALE_IN + Integer.toString(scaleInFactor);
        return this.findReconfiguration(reconf, options);
    }

    private double getOutSourceSlope() {
        return 0.05555555555555555;
    }

    private double getScaleInSlope() {
        return 0.5;
    }

    private int normalize(double factor) {
        return balanceStepMap.entrySet().stream().filter(each -> ((Predicate)each.getKey()).test(factor)).map(each -> (Integer)each.getValue()).findFirst().get();
    }

    private List<QVToReconfiguration> asReconfigurations(Set<QVToReconfiguration> options) {
        return options.stream().map(each -> each).collect(Collectors.toList());
    }

    private QVToReconfiguration findReconfiguration(String name, List<QVToReconfiguration> options) {
        for (QVToReconfiguration each : options) {
            String reconfName = each.getReconfigurationName();
            if (!reconfName.equals(name)) continue;
            return each;
        }
        throw new RuntimeException("");
    }

    public String getId() {
        return LINEAR_ADAPTATION_STRATEGY_NAME;
    }
}

