/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.loadbalancing;

import com.google.common.collect.Lists;
import java.util.List;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurement;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurementSpecification;
import org.palladiosimulator.simexp.core.reward.SimpleRewardSignal;
import org.palladiosimulator.simexp.core.reward.ThresholdBasedRewardEvaluator;
import org.palladiosimulator.simexp.core.state.StateQuantity;
import org.palladiosimulator.simexp.core.util.Pair;
import org.palladiosimulator.simexp.core.util.Threshold;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Reward;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.impl.RewardImpl;

public class LoadBalancingRewardEvaluation
extends ThresholdBasedRewardEvaluator {
    private static final Threshold TOTAL_UTIL_THRESHOLD = Threshold.lessThanOrEqualTo((double)1.0);
    private final Pair<SimulatedMeasurementSpecification, Threshold> upperResponseTimeThreshold;
    private final Pair<SimulatedMeasurementSpecification, Threshold> cpuServer1Threshold;
    private final Pair<SimulatedMeasurementSpecification, Threshold> cpuServer2Threshold;

    public LoadBalancingRewardEvaluation(Pair<SimulatedMeasurementSpecification, Threshold> upperResponseTimeThreshold, Pair<SimulatedMeasurementSpecification, Threshold> cpuServer1Threshold, Pair<SimulatedMeasurementSpecification, Threshold> cpuServer2Threshold) {
        super((List)Lists.newArrayList((Object[])new Pair[]{upperResponseTimeThreshold, cpuServer1Threshold, cpuServer2Threshold}));
        this.upperResponseTimeThreshold = upperResponseTimeThreshold;
        this.cpuServer1Threshold = cpuServer1Threshold;
        this.cpuServer2Threshold = cpuServer2Threshold;
    }

    public Reward<Integer> evaluate(StateQuantity quantity) {
        List thresholds = this.filterThresholds(quantity);
        Pair<SimulatedMeasurement, Threshold> rtThreshold = this.findThreshold((SimulatedMeasurementSpecification)this.upperResponseTimeThreshold.getFirst(), thresholds);
        boolean isRTSatisfied = ((Threshold)rtThreshold.getSecond()).isSatisfied(((SimulatedMeasurement)rtThreshold.getFirst()).getValue());
        SimulatedMeasurement utilServer1 = (SimulatedMeasurement)this.findThreshold((SimulatedMeasurementSpecification)this.cpuServer1Threshold.getFirst(), thresholds).getFirst();
        SimulatedMeasurement utilServer2 = (SimulatedMeasurement)this.findThreshold((SimulatedMeasurementSpecification)this.cpuServer2Threshold.getFirst(), thresholds).getFirst();
        Double totalUtil = utilServer1.getValue() + utilServer2.getValue();
        boolean isUtilSatisfied = TOTAL_UTIL_THRESHOLD.isSatisfied(totalUtil.doubleValue());
        if (Boolean.logicalAnd(isRTSatisfied, isUtilSatisfied)) {
            return SimpleRewardSignal.createPositivReward();
        }
        if (Boolean.logicalXor(isRTSatisfied, isUtilSatisfied)) {
            return NeutralRewardSignal.create();
        }
        return SimpleRewardSignal.createNegativReward();
    }

    private Pair<SimulatedMeasurement, Threshold> findThreshold(SimulatedMeasurementSpecification spec, List<Pair<SimulatedMeasurement, Threshold>> thresholds) {
        return thresholds.stream().filter(t -> ((SimulatedMeasurement)t.getFirst()).getSpecification().getId().equals(spec.getId())).findFirst().get();
    }

    private static class NeutralRewardSignal
    extends RewardImpl<Integer> {
        private NeutralRewardSignal() {
            super.setValue((Object)0);
        }

        public static NeutralRewardSignal create() {
            return new NeutralRewardSignal();
        }

        public String toString() {
            return Integer.toString((Integer)this.getValue());
        }
    }
}

