/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.loadbalancing;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.palladiosimulator.envdyn.api.entity.bn.DynamicBayesianNetwork;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.experimentautomation.experiments.Experiment;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurementSpecification;
import org.palladiosimulator.simexp.core.evaluation.SimulatedExperienceEvaluator;
import org.palladiosimulator.simexp.core.evaluation.TotalRewardCalculation;
import org.palladiosimulator.simexp.core.process.ExperienceSimulator;
import org.palladiosimulator.simexp.core.reward.RewardEvaluator;
import org.palladiosimulator.simexp.core.reward.ThresholdBasedRewardEvaluator;
import org.palladiosimulator.simexp.core.state.SimulationRunnerHolder;
import org.palladiosimulator.simexp.core.store.SimulatedExperienceStore;
import org.palladiosimulator.simexp.core.util.Pair;
import org.palladiosimulator.simexp.core.util.SimulatedExperienceConstants;
import org.palladiosimulator.simexp.core.util.Threshold;
import org.palladiosimulator.simexp.environmentaldynamics.process.EnvironmentProcess;
import org.palladiosimulator.simexp.pcm.action.IQVToReconfigurationManager;
import org.palladiosimulator.simexp.pcm.action.IQVToReconfigurationProvider;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.config.ITransformationConfiguration;
import org.palladiosimulator.simexp.pcm.examples.executor.ModelLoader;
import org.palladiosimulator.simexp.pcm.examples.executor.PcmExperienceSimulationExecutor;
import org.palladiosimulator.simexp.pcm.examples.loadbalancing.NStepLoadBalancerStrategy;
import org.palladiosimulator.simexp.pcm.examples.loadbalancing.VaryingInterarrivelRateProcess;
import org.palladiosimulator.simexp.pcm.init.GlobalPcmBeforeExecutionInitialization;
import org.palladiosimulator.simexp.pcm.process.PcmExperienceSimulationRunner;
import org.palladiosimulator.simexp.pcm.simulator.SimulatorPcmExperienceSimulationExecutorFactory;
import org.palladiosimulator.simexp.pcm.simulator.config.IPCMWorkflowConfiguration;
import org.palladiosimulator.simexp.pcm.state.InitialPcmStateCreator;
import org.palladiosimulator.simexp.pcm.state.PcmMeasurementSpecification;
import org.palladiosimulator.simexp.pcm.util.IExperimentProvider;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import org.palladiosimulator.solver.core.models.PCMInstance;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.random.ISeedProvider;

public class LoadBalancingSimulationExecutorFactory
extends SimulatorPcmExperienceSimulationExecutorFactory<Integer, List<InputValue<CategoricalValue>>> {
    public static final double UPPER_THRESHOLD_RT = 2.0;
    public static final double LOWER_THRESHOLD_RT = 0.3;

    public LoadBalancingSimulationExecutorFactory(IPCMWorkflowConfiguration workflowConfiguration, ModelLoader.Factory modelLoaderFactory, SimulatedExperienceStore<QVTOReconfigurator, Integer> simulatedExperienceStore, Optional<ISeedProvider> seedProvider) {
        super(workflowConfiguration, modelLoaderFactory, simulatedExperienceStore, seedProvider);
    }

    protected PcmExperienceSimulationExecutor<PCMInstance, QVTOReconfigurator, QVToReconfiguration, Integer> doCreate(Experiment experiment, DynamicBayesianNetwork<CategoricalValue> dbn) {
        IExperimentProvider experimentProvider = this.createExperimentProvider(experiment);
        VaryingInterarrivelRateProcess p = new VaryingInterarrivelRateProcess(dbn, experimentProvider);
        EnvironmentProcess envProcess = p.getEnvironmentProcess();
        p.init(this.getSeedProvider());
        List pcmMeasurementSpecs = this.createSpecs(experiment);
        LinkedHashSet simulatedMeasurementSpecs = new LinkedHashSet(pcmMeasurementSpecs);
        SimulationRunnerHolder simulationRunnerHolder = this.createSimulationRunnerHolder();
        InitialPcmStateCreator initialStateCreator = new InitialPcmStateCreator(simulatedMeasurementSpecs, experimentProvider, simulationRunnerHolder);
        List<PcmExperienceSimulationRunner> simulationRunners = List.of(new PcmExperienceSimulationRunner(experimentProvider, initialStateCreator));
        IQVToReconfigurationManager qvtoReconfigurationManager = this.createQvtoReconfigurationManager(experiment, (ITransformationConfiguration)this.getWorkflowConfiguration());
        ArrayList<GlobalPcmBeforeExecutionInitialization> beforeExecutionInitializables = new ArrayList<GlobalPcmBeforeExecutionInitialization>();
        GlobalPcmBeforeExecutionInitialization beforeExecutionInitializable = new GlobalPcmBeforeExecutionInitialization(experimentProvider, qvtoReconfigurationManager);
        beforeExecutionInitializables.add(beforeExecutionInitializable);
        NStepLoadBalancerStrategy reconfSelectionPolicy = new NStepLoadBalancerStrategy(1, (PcmMeasurementSpecification)pcmMeasurementSpecs.get(0), 2.0, 0.3);
        Pair threshold = Pair.of((Object)((SimulatedMeasurementSpecification)pcmMeasurementSpecs.get(0)), (Object)Threshold.lessThanOrEqualTo((double)2.0));
        ThresholdBasedRewardEvaluator evaluator = ThresholdBasedRewardEvaluator.with((Pair[])new Pair[]{threshold});
        IQVToReconfigurationProvider qvToReconfigurationProvider = qvtoReconfigurationManager.getQVToReconfigurationProvider();
        Set reconfigurations = qvToReconfigurationProvider.getReconfigurations();
        ExperienceSimulator simulator = this.createExperienceSimulator(experiment, pcmMeasurementSpecs, simulationRunners, this.getSimulationParameters(), beforeExecutionInitializables, envProcess, this.getSimulatedExperienceStore(), null, reconfSelectionPolicy, reconfigurations, (RewardEvaluator)evaluator, false, experimentProvider, simulationRunnerHolder, null, this.getSeedProvider());
        String sampleSpaceId = SimulatedExperienceConstants.constructSampleSpaceId((String)this.getSimulationParameters().getSimulationID(), (String)reconfSelectionPolicy.getId());
        TotalRewardCalculation rewardCalculation = SimulatedExperienceEvaluator.of((String)this.getSimulationParameters().getSimulationID(), (String)sampleSpaceId);
        return new PcmExperienceSimulationExecutor(simulator, experiment, this.getSimulationParameters(), reconfSelectionPolicy, rewardCalculation, experimentProvider);
    }
}

