/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.loadbalancing;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurement;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurementSpecification;
import org.palladiosimulator.simexp.core.state.SelfAdaptiveSystemState;
import org.palladiosimulator.simexp.core.util.Threshold;
import org.palladiosimulator.simexp.markovian.activity.Policy;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.pcm.action.EmptyQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.state.PcmMeasurementSpecification;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;

public class NStepLoadBalancerStrategy<C, A>
implements Policy<QVTOReconfigurator, QVToReconfiguration> {
    private static final String SIMPLE_ADAPTATION_STRATEGY_NAME = "StepAdaptationStrategy";
    private final Threshold upperRtThreshold;
    private final Threshold lowerRtThreshold;
    private final int stepSize;
    private final PcmMeasurementSpecification pcmSpec;

    public NStepLoadBalancerStrategy(int stepSize, PcmMeasurementSpecification pcmSpec, double upperThresholdRt, double lowerThresholdRt) {
        this.stepSize = stepSize;
        this.pcmSpec = pcmSpec;
        this.upperRtThreshold = Threshold.lessThanOrEqualTo((double)upperThresholdRt);
        this.lowerRtThreshold = Threshold.greaterThanOrEqualTo((double)lowerThresholdRt);
    }

    public String getId() {
        return String.valueOf(this.stepSize) + SIMPLE_ADAPTATION_STRATEGY_NAME;
    }

    public QVToReconfiguration select(State source, Set<QVToReconfiguration> options) {
        if (!(source instanceof SelfAdaptiveSystemState)) {
            throw new RuntimeException("");
        }
        SelfAdaptiveSystemState sassState = (SelfAdaptiveSystemState)source;
        SimulatedMeasurement simMeasurement = (SimulatedMeasurement)sassState.getQuantifiedState().findMeasurementWith((SimulatedMeasurementSpecification)this.pcmSpec).orElseThrow(() -> new RuntimeException(""));
        Double value = simMeasurement.getValue();
        if (this.upperRtThreshold.isNotSatisfied(value.doubleValue())) {
            return this.outSource(this.asReconfigurations(options));
        }
        if (this.lowerRtThreshold.isNotSatisfied(value.doubleValue())) {
            return this.scaleIn(this.asReconfigurations(options));
        }
        return EmptyQVToReconfiguration.empty();
    }

    private QVToReconfiguration outSource(List<QVToReconfiguration> options) {
        for (QVToReconfiguration each : options) {
            String reconfName = each.getReconfigurationName();
            if (!reconfName.equals(this.outsource())) continue;
            return each;
        }
        throw new RuntimeException("");
    }

    private QVToReconfiguration scaleIn(List<QVToReconfiguration> options) {
        for (QVToReconfiguration each : options) {
            String reconfName = each.getReconfigurationName();
            if (!reconfName.equals(this.scaleIn())) continue;
            return each;
        }
        throw new RuntimeException("");
    }

    private List<QVToReconfiguration> asReconfigurations(Set<QVToReconfiguration> options) {
        return options.stream().map(each -> each).collect(Collectors.toList());
    }

    private String scaleIn() {
        return String.format("Step%sScaleIn", Integer.toString(this.stepSize));
    }

    private String outsource() {
        return String.format("Step%sOutsource", Integer.toString(this.stepSize));
    }
}

