/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.loadbalancing;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.palladiosimulator.envdyn.environment.dynamicmodel.DynamicBehaviour;
import org.palladiosimulator.envdyn.environment.dynamicmodel.DynamicBehaviourExtension;
import org.palladiosimulator.envdyn.environment.dynamicmodel.DynamicBehaviourRepository;
import org.palladiosimulator.envdyn.environment.dynamicmodel.DynamicmodelFactory;
import org.palladiosimulator.envdyn.environment.dynamicmodel.InductiveDynamicBehaviour;
import org.palladiosimulator.envdyn.environment.dynamicmodel.InterTimeSliceInduction;
import org.palladiosimulator.envdyn.environment.dynamicmodel.TemporalDynamic;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundProbabilisticModel;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundProbabilisticNetwork;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundRandomVariable;
import org.palladiosimulator.envdyn.environment.staticmodel.LocalProbabilisticNetwork;
import org.palladiosimulator.envdyn.environment.staticmodel.ProbabilisticModelRepository;
import org.palladiosimulator.envdyn.environment.staticmodel.StaticmodelFactory;
import org.palladiosimulator.envdyn.environment.templatevariable.Argument;
import org.palladiosimulator.envdyn.environment.templatevariable.LogicalVariable;
import org.palladiosimulator.envdyn.environment.templatevariable.PersistenceRelation;
import org.palladiosimulator.envdyn.environment.templatevariable.ProbabilisticTemplateFactor;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateFactor;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariable;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariableDefinitions;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplatevariableFactory;
import org.palladiosimulator.envdyn.environment.templatevariable.TemporalRelation;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.scaledl.usageevolution.Usage;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.generator.ModelEvaluator;
import tools.mdsd.probdist.distributionfunction.ComplexParameter;
import tools.mdsd.probdist.distributionfunction.DistributionfunctionFactory;
import tools.mdsd.probdist.distributionfunction.ParamRepresentation;
import tools.mdsd.probdist.distributionfunction.Parameter;
import tools.mdsd.probdist.distributionfunction.ParameterType;
import tools.mdsd.probdist.distributionfunction.ProbabilityDistribution;
import tools.mdsd.probdist.distributionfunction.ProbabilityDistributionFunctionRepository;
import tools.mdsd.probdist.distributionfunction.SimpleParameter;
import tools.mdsd.probdist.distributionfunction.TabularCPD;
import tools.mdsd.probdist.distributionfunction.TabularCPDEntry;
import tools.mdsd.probdist.distributiontype.ParameterSignature;
import tools.mdsd.probdist.distributiontype.ProbabilityDistributionSkeleton;
import tools.mdsd.probdist.model.basic.loader.BasicDistributionTypesLoader;

public class UsageScenarioToDBNTransformer {
    private static final String LOAD_BALANCER_PATH = "/org.palladiosimulator.simexp.pcm.examples.loadbalancer";
    private static final String BN_FILE = String.format("%1s/%2s.%3s", "/org.palladiosimulator.simexp.pcm.examples.loadbalancer", "LoadBalancingTOBEREPLACEDStativEnv", "staticmodel");
    private static final String DBN_FILE = String.format("%1s/%2s.%3s", "/org.palladiosimulator.simexp.pcm.examples.loadbalancer", "LoadBalancingTOBEREPLACEDEnvDyn", "dynamicmodel");
    private static final String TEMPLATE_FILE = String.format("%1s/%2s.%3s", "/org.palladiosimulator.simexp.pcm.examples.loadbalancer", "LoadBalancerTOBEREPLACEDTemplates", "templatevariable");
    private static final String DIST_FILE = String.format("%1s/%2s.%3s", "/org.palladiosimulator.simexp.pcm.examples.loadbalancer", "LoadBalancerTOBEREPLACEDDist", "distributionfunction");
    private static final double SAMPLE_RATE = 1.0;
    private final TemplatevariableFactory templateFactory = TemplatevariableFactory.eINSTANCE;
    private final StaticmodelFactory staticModelFactory = StaticmodelFactory.eINSTANCE;
    private final DynamicmodelFactory dynamicModelFactory = DynamicmodelFactory.eINSTANCE;
    private final DistributionfunctionFactory distributionFactory = DistributionfunctionFactory.eINSTANCE;
    private final ProbabilityDistributionSkeleton skeleton = BasicDistributionTypesLoader.loadRepository().getDistributionFamilies().stream().filter(each -> each.getEntityName().equals("MultinomialDistribution")).findFirst().get();
    private TemplateVariableDefinitions templateDefinitions;
    private ProbabilisticModelRepository bnRepository;
    private DynamicBehaviourRepository dbnExtension;
    private ProbabilityDistributionFunctionRepository distributionRepository;

    public DynamicBehaviourExtension transformAndPersist(Usage usage) {
        DynamicBehaviourExtension result = this.transform(usage);
        this.persistAll(usage);
        return result;
    }

    public DynamicBehaviourExtension transform(Usage usage) {
        List<Double> samples = this.samplingUsageEvolution(usage.getLoadEvolution());
        return this.generateDBNFrom(samples, usage.getScenario());
    }

    private List<Double> samplingUsageEvolution(Sequence loadEvolution) {
        ModelEvaluator evaluator = new ModelEvaluator(loadEvolution);
        ArrayList samples = Lists.newArrayList();
        double time = 0.0;
        while (time < loadEvolution.getFinalDuration()) {
            double arrivalRate = evaluator.getArrivalRateAtTime(time);
            double interArrivalTime = 1.0 / arrivalRate;
            samples.add(interArrivalTime);
            time += 1.0;
        }
        return samples;
    }

    private DynamicBehaviourExtension generateDBNFrom(List<Double> samples, UsageScenario scenario) {
        this.buildInitialStructure(scenario);
        this.buildDistributionsFrom(samples);
        this.complementInitialStructureWithDistributions();
        return (DynamicBehaviourExtension)this.dbnExtension.getExtensions().get(0);
    }

    private void buildInitialStructure(UsageScenario scenario) {
        this.buildTemplateDefinition();
        this.buildBayesianNetwork(scenario);
        this.buildDynamicsBayesianNetwork();
    }

    private void buildTemplateDefinition() {
        this.templateDefinitions = this.templateFactory.createTemplateVariableDefinitions();
        this.templateDefinitions.setEntityName("LoadBalancerTemplateDefs");
        Argument interArrivalTimeArg = this.templateFactory.createArgument();
        interArrivalTimeArg.setEntityName("OpenWorkload");
        LogicalVariable interArrivalTimeVar = this.templateFactory.createLogicalVariable();
        interArrivalTimeVar.setArgument(interArrivalTimeArg);
        TemplateVariable interArrivalTimeTemplate = this.templateFactory.createTemplateVariable();
        interArrivalTimeTemplate.setEntityName("InterArrivalTimeTemplate");
        interArrivalTimeTemplate.getSignature().add((Object)interArrivalTimeVar);
        ProbabilisticTemplateFactor staticInterArrivalTimeFactor = this.templateFactory.createProbabilisticTemplateFactor();
        staticInterArrivalTimeFactor.setEntityName("StaticInterArrivalTimeFactor");
        staticInterArrivalTimeFactor.setDistributionFamily(this.skeleton);
        staticInterArrivalTimeFactor.getScope().add((Object)interArrivalTimeTemplate);
        ProbabilisticTemplateFactor dynamicInterArrivalTimeFactor = this.templateFactory.createProbabilisticTemplateFactor();
        dynamicInterArrivalTimeFactor.setEntityName("DynamicInterArrivalTimeFactor");
        dynamicInterArrivalTimeFactor.setDistributionFamily(this.skeleton);
        dynamicInterArrivalTimeFactor.setTemporal(true);
        dynamicInterArrivalTimeFactor.getScope().add((Object)interArrivalTimeTemplate);
        PersistenceRelation dynamicInterArrivalTimeRelation = this.templateFactory.createPersistenceRelation();
        dynamicInterArrivalTimeRelation.setEntityName("InterArrivalTimeDynamics");
        dynamicInterArrivalTimeRelation.setInterfaceVariable(interArrivalTimeTemplate);
        this.templateDefinitions.getVariables().add((Object)interArrivalTimeTemplate);
        this.templateDefinitions.getArguments().add((Object)interArrivalTimeArg);
        this.templateDefinitions.getFactors().add((Object)staticInterArrivalTimeFactor);
        this.templateDefinitions.getFactors().add((Object)dynamicInterArrivalTimeFactor);
        this.templateDefinitions.getRelation().add((Object)dynamicInterArrivalTimeRelation);
    }

    private void buildBayesianNetwork(UsageScenario scenario) {
        this.bnRepository = this.staticModelFactory.createProbabilisticModelRepository();
        this.bnRepository.setEntityName("InterArrivalTimeDistributionRepo");
        GroundProbabilisticModel groundModel = this.staticModelFactory.createGroundProbabilisticModel();
        groundModel.setEntityName("StaticInterArrivalTimeModel");
        groundModel.setInstantiatedFactor(this.retrieveNonTemporalFactor());
        GroundRandomVariable groundVariable = this.staticModelFactory.createGroundRandomVariable();
        groundVariable.setEntityName("WorkloadVariation_VaryingWorkloadInstantiation");
        groundVariable.setDescriptiveModel(groundModel);
        groundVariable.setInstantiatedTemplate((TemplateVariable)this.templateDefinitions.getVariables().get(0));
        groundVariable.getAppliedObjects().add((Object)scenario.getWorkload_UsageScenario());
        LocalProbabilisticNetwork localNetwork = this.staticModelFactory.createLocalProbabilisticNetwork();
        localNetwork.getGroundRandomVariables().add((Object)groundVariable);
        GroundProbabilisticNetwork groundNetwork = this.staticModelFactory.createGroundProbabilisticNetwork();
        groundNetwork.setEntityName("StaticInterArrivalTimeNetwork");
        groundNetwork.getLocalModels().add((Object)groundModel);
        groundNetwork.getLocalProbabilisticModels().add((Object)localNetwork);
        this.bnRepository.getModels().add((Object)groundNetwork);
    }

    private void buildDynamicsBayesianNetwork() {
        this.dbnExtension = this.dynamicModelFactory.createDynamicBehaviourRepository();
        this.dbnExtension.setEntityName("InterArrivalTimeDistributionDynamicsRepo");
        TemporalDynamic temporalDynamic = this.dynamicModelFactory.createTemporalDynamic();
        temporalDynamic.setEntityName("DynamicInterArrivalTime");
        temporalDynamic.setInstantiatedFactor(this.retrieveTemporalFactor());
        InterTimeSliceInduction timeSlice = this.dynamicModelFactory.createInterTimeSliceInduction();
        timeSlice.setAppliedGroundVariable((GroundRandomVariable)((LocalProbabilisticNetwork)((GroundProbabilisticNetwork)this.bnRepository.getModels().get(0)).getLocalProbabilisticModels().get(0)).getGroundRandomVariables().get(0));
        timeSlice.setDescriptiveModel(temporalDynamic);
        timeSlice.getTemporalStructure().add((Object)((TemporalRelation)this.templateDefinitions.getRelation().get(0)));
        InductiveDynamicBehaviour dynamicBehaviour = this.dynamicModelFactory.createInductiveDynamicBehaviour();
        dynamicBehaviour.getLocalModels().add((Object)temporalDynamic);
        dynamicBehaviour.getTimeSliceInductions().add((Object)timeSlice);
        DynamicBehaviourExtension dynamicBehaviourExt = this.dynamicModelFactory.createDynamicBehaviourExtension();
        dynamicBehaviourExt.setEntityName("InterArrivalTimeDistributionDynamics");
        dynamicBehaviourExt.setModel((GroundProbabilisticNetwork)this.bnRepository.getModels().get(0));
        dynamicBehaviourExt.setBehaviour((DynamicBehaviour)dynamicBehaviour);
        this.dbnExtension.getExtensions().add((Object)dynamicBehaviourExt);
    }

    private void buildDistributionsFrom(List<Double> samples) {
        this.distributionRepository = this.distributionFactory.createProbabilityDistributionFunctionRepository();
        this.distributionRepository.setEntityName("DistributionRepo");
        List<Double> adjustedSamples = this.adjustSamples(samples);
        Parameter initialInterArrivalTimeParam = this.distributionFactory.createParameter();
        initialInterArrivalTimeParam.setEntityName("InitialInterArrivalTimeParam");
        initialInterArrivalTimeParam.setInstantiated((ParameterSignature)this.skeleton.getParamStructures().get(0));
        initialInterArrivalTimeParam.setRepresentation((ParamRepresentation)this.createSimpleRepresentationFrom(adjustedSamples));
        Parameter temporalInterArrivalTimeParam = this.distributionFactory.createParameter();
        temporalInterArrivalTimeParam.setEntityName("TemporalInterArrivalTimeParam");
        temporalInterArrivalTimeParam.setInstantiated((ParameterSignature)this.skeleton.getParamStructures().get(0));
        temporalInterArrivalTimeParam.setRepresentation((ParamRepresentation)this.createComplexRepresentationFrom(adjustedSamples));
        ProbabilityDistribution initialInterArrivalTimeDist = this.distributionFactory.createProbabilityDistribution();
        initialInterArrivalTimeDist.setEntityName("InitialInterArrivalTimeDist");
        initialInterArrivalTimeDist.setInstantiated(this.skeleton);
        initialInterArrivalTimeDist.getParams().add((Object)initialInterArrivalTimeParam);
        ProbabilityDistribution temporalInterArrivalTimeDist = this.distributionFactory.createProbabilityDistribution();
        temporalInterArrivalTimeDist.setEntityName("TemporalInterArrivalTimeDist");
        temporalInterArrivalTimeDist.setInstantiated(this.skeleton);
        temporalInterArrivalTimeDist.getParams().add((Object)temporalInterArrivalTimeParam);
        this.distributionRepository.getParams().add((Object)initialInterArrivalTimeParam);
        this.distributionRepository.getParams().add((Object)temporalInterArrivalTimeParam);
        this.distributionRepository.getDistributions().add((Object)initialInterArrivalTimeDist);
        this.distributionRepository.getDistributions().add((Object)temporalInterArrivalTimeDist);
    }

    private List<Double> adjustSamples(List<Double> samples) {
        List<Double> distinctSamples = samples.stream().distinct().collect(Collectors.toList());
        if (distinctSamples.size() == 1) {
            return distinctSamples;
        }
        if (distinctSamples.size() == samples.size()) {
            return samples;
        }
        ArrayList adjustedSamples = Lists.newArrayList();
        for (Double each : samples) {
            if (adjustedSamples.contains(each)) {
                adjustedSamples.add(each + 1.0E-5);
                continue;
            }
            adjustedSamples.add(each);
        }
        return adjustedSamples;
    }

    private void complementInitialStructureWithDistributions() {
        ((GroundProbabilisticModel)((GroundProbabilisticNetwork)this.bnRepository.getModels().get(0)).getLocalModels().get(0)).setDistribution(this.retrieveInitialDist());
        ((TemporalDynamic)((DynamicBehaviourExtension)this.dbnExtension.getExtensions().get(0)).getBehaviour().getLocalModels().get(0)).setDistributionFunction(this.retrieveTemporalDist());
    }

    private ComplexParameter createComplexRepresentationFrom(List<Double> samples) {
        TabularCPD tabularCPD = this.distributionFactory.createTabularCPD();
        int i = 0;
        while (i < samples.size()) {
            TabularCPDEntry tabularCPDEntry = this.distributionFactory.createTabularCPDEntry();
            tabularCPDEntry.getConditonals().add((Object)samples.get(i).toString());
            SimpleParameter param = i + 1 == samples.size() ? this.createSimpleRepresentationFrom(samples, i) : this.createSimpleRepresentationFrom(samples, i + 1);
            tabularCPDEntry.setEntry(param);
            tabularCPD.getCpdEntries().add((Object)tabularCPDEntry);
            ++i;
        }
        return tabularCPD;
    }

    private SimpleParameter createSimpleRepresentationFrom(List<Double> samples) {
        return this.createSimpleRepresentationFrom(samples, 0);
    }

    private SimpleParameter createSimpleRepresentationFrom(List<Double> samples, int peak) {
        SimpleParameter param = this.distributionFactory.createSimpleParameter();
        param.setType(ParameterType.SAMPLESPACE);
        param.setValue(this.parseToDiracDistribution(samples, peak));
        return param;
    }

    private String parseToDiracDistribution(List<Double> samples, int peak) {
        HashMap sampleSpace = Maps.newHashMap();
        int i = 0;
        while (i < samples.size()) {
            sampleSpace.put(samples.get(i).toString(), Double.toString(i == peak ? 1.0 : 0.0));
            ++i;
        }
        return this.parseToString(sampleSpace);
    }

    private String parseToString(Map<String, String> sampleSpace) {
        StringBuilder builder = new StringBuilder();
        for (String eachCategory : sampleSpace.keySet()) {
            builder.append(String.format("{%1s,%2s};", eachCategory, sampleSpace.get(eachCategory)));
        }
        return builder.deleteCharAt(builder.length() - 1).toString();
    }

    private TemplateFactor retrieveTemporalFactor() {
        return this.templateDefinitions.getFactors().stream().filter(f -> f.isTemporal()).findFirst().get();
    }

    private TemplateFactor retrieveNonTemporalFactor() {
        return this.templateDefinitions.getFactors().stream().filter(f -> !f.isTemporal()).findFirst().get();
    }

    private ProbabilityDistribution retrieveInitialDist() {
        return this.distributionRepository.getDistributions().stream().map(ProbabilityDistribution.class::cast).filter(d -> ((Parameter)d.getParams().get(0)).getRepresentation() instanceof SimpleParameter).findFirst().get();
    }

    private ProbabilityDistribution retrieveTemporalDist() {
        return this.distributionRepository.getDistributions().stream().map(ProbabilityDistribution.class::cast).filter(d -> ((Parameter)d.getParams().get(0)).getRepresentation() instanceof ComplexParameter).findFirst().get();
    }

    private void persistAll(Usage usage) {
        String usageEvolutionName = usage.getLoadEvolution().getName();
        String resolvedDistFile = DIST_FILE.replaceFirst("TOBEREPLACED", usageEvolutionName);
        URI DIST_URI = URI.createPlatformResourceURI((String)resolvedDistFile, (boolean)true);
        String resolvedDBNFile = DBN_FILE.replaceFirst("TOBEREPLACED", usageEvolutionName);
        URI DBN_URI = URI.createPlatformResourceURI((String)resolvedDBNFile, (boolean)true);
        String resolvedBNFile = BN_FILE.replaceFirst("TOBEREPLACED", usageEvolutionName);
        URI BN_URI = URI.createPlatformResourceURI((String)resolvedBNFile, (boolean)true);
        String resolvedTemplateFile = TEMPLATE_FILE.replaceFirst("TOBEREPLACED", usageEvolutionName);
        URI TEMPLATE_URI = URI.createPlatformResourceURI((String)resolvedTemplateFile, (boolean)true);
        this.persist((EObject)this.distributionRepository, DIST_URI);
        this.persist((EObject)this.templateDefinitions, TEMPLATE_URI);
        this.persist((EObject)this.bnRepository, BN_URI);
        this.persist((EObject)this.dbnExtension, DBN_URI);
    }

    private void persist(EObject eObj, URI uri) {
        Resource resource = new ResourceSetImpl().createResource(uri);
        resource.getContents().add((Object)eObj);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

