/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.performability.loadbalancing;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.palladiosimulator.envdyn.api.entity.bn.DynamicBayesianNetwork;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.experimentautomation.experiments.Experiment;
import org.palladiosimulator.pcm.query.RepositoryModelLookup;
import org.palladiosimulator.pcm.query.ResourceEnvironmentModelLookup;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurementSpecification;
import org.palladiosimulator.simexp.core.evaluation.PerformabilityEvaluator;
import org.palladiosimulator.simexp.core.evaluation.TotalRewardCalculation;
import org.palladiosimulator.simexp.core.process.ExperienceSimulator;
import org.palladiosimulator.simexp.core.reward.RewardEvaluator;
import org.palladiosimulator.simexp.core.state.SimulationRunnerHolder;
import org.palladiosimulator.simexp.core.store.SimulatedExperienceStore;
import org.palladiosimulator.simexp.core.util.Pair;
import org.palladiosimulator.simexp.core.util.SimulatedExperienceConstants;
import org.palladiosimulator.simexp.core.util.Threshold;
import org.palladiosimulator.simexp.environmentaldynamics.process.EnvironmentProcess;
import org.palladiosimulator.simexp.markovian.activity.Policy;
import org.palladiosimulator.simexp.pcm.action.IQVToReconfigurationManager;
import org.palladiosimulator.simexp.pcm.action.IQVToReconfigurationProvider;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.config.ITransformationConfiguration;
import org.palladiosimulator.simexp.pcm.examples.executor.ModelLoader;
import org.palladiosimulator.simexp.pcm.examples.executor.PcmExperienceSimulationExecutor;
import org.palladiosimulator.simexp.pcm.examples.performability.PerformabilityStrategy;
import org.palladiosimulator.simexp.pcm.examples.performability.PerformabilityStrategyConfiguration;
import org.palladiosimulator.simexp.pcm.examples.performability.RepositoryModelUpdater;
import org.palladiosimulator.simexp.pcm.examples.performability.loadbalancing.FaultTolerantScalingNodeFailureRecoveryStrategy;
import org.palladiosimulator.simexp.pcm.examples.performability.loadbalancing.FaultTolerantScalingPlanningStrategy;
import org.palladiosimulator.simexp.pcm.examples.performability.loadbalancing.FaultTolerantVaryingInterarrivelRateProcess;
import org.palladiosimulator.simexp.pcm.examples.performability.loadbalancing.LoadBalancingEmptyReconfigurationPlanningStrategy;
import org.palladiosimulator.simexp.pcm.examples.performability.loadbalancing.LoadBalancingScalingPlanningStrategy;
import org.palladiosimulator.simexp.pcm.init.GlobalPcmBeforeExecutionInitialization;
import org.palladiosimulator.simexp.pcm.performability.PerformabilityRewardEvaluation;
import org.palladiosimulator.simexp.pcm.process.PerformabilityPcmExperienceSimulationRunner;
import org.palladiosimulator.simexp.pcm.simulator.SimulatorPcmExperienceSimulationExecutorFactory;
import org.palladiosimulator.simexp.pcm.simulator.config.IPCMWorkflowConfiguration;
import org.palladiosimulator.simexp.pcm.state.InitialPcmStateCreator;
import org.palladiosimulator.simexp.pcm.state.PcmMeasurementSpecification;
import org.palladiosimulator.simexp.pcm.util.IExperimentProvider;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import org.palladiosimulator.solver.core.models.PCMInstance;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.random.ISeedProvider;

public class FaultTolerantLoadBalancingSimulationExecutorFactory
extends SimulatorPcmExperienceSimulationExecutorFactory<Double, List<InputValue<CategoricalValue>>> {
    public static final Threshold LOWER_THRESHOLD_RT = Threshold.greaterThanOrEqualTo((double)0.1);
    public static final Threshold UPPER_THRESHOLD_RT = Threshold.lessThanOrEqualTo((double)0.4);
    public static final String SERVER_FAILURE_TEMPLATE_ID = "_VtIJEPtrEeuPUtFH1XJrHw";
    public static final String LOAD_BALANCER_ID = "_NvLi8AEmEeS7FKokKTKFow";

    public FaultTolerantLoadBalancingSimulationExecutorFactory(IPCMWorkflowConfiguration workflowConfiguration, ModelLoader.Factory modelLoaderFactory, SimulatedExperienceStore<QVTOReconfigurator, Double> simulatedExperienceStore, Optional<ISeedProvider> seedProvider) {
        super(workflowConfiguration, modelLoaderFactory, simulatedExperienceStore, seedProvider);
    }

    protected PcmExperienceSimulationExecutor<PCMInstance, QVTOReconfigurator, QVToReconfiguration, Double> doCreate(Experiment experiment, DynamicBayesianNetwork<CategoricalValue> dbn) {
        PerformabilityStrategy reconfStrategy;
        FaultTolerantScalingPlanningStrategy ftLoadBalancingScalingPlanningStrategy;
        IExperimentProvider experimentProvider = this.createExperimentProvider(experiment);
        FaultTolerantVaryingInterarrivelRateProcess p = new FaultTolerantVaryingInterarrivelRateProcess(dbn, experimentProvider);
        p.init(this.getSeedProvider());
        EnvironmentProcess envProcess = p.getEnvironmentProcess();
        List pcmMeasurementSpecs = this.createSpecs(experiment);
        LinkedHashSet simulatedMeasurementSpecs = new LinkedHashSet(pcmMeasurementSpecs);
        SimulationRunnerHolder simulationRunnerHolder = this.createSimulationRunnerHolder();
        InitialPcmStateCreator initialStateCreator = new InitialPcmStateCreator(simulatedMeasurementSpecs, experimentProvider, simulationRunnerHolder);
        List<PerformabilityPcmExperienceSimulationRunner> runners = List.of(new PerformabilityPcmExperienceSimulationRunner(experimentProvider, initialStateCreator));
        IQVToReconfigurationManager qvtoReconfigurationManager = this.createQvtoReconfigurationManager(experiment, (ITransformationConfiguration)this.getWorkflowConfiguration());
        ArrayList<GlobalPcmBeforeExecutionInitialization> beforeExecutionInitializables = new ArrayList<GlobalPcmBeforeExecutionInitialization>();
        GlobalPcmBeforeExecutionInitialization beforeExecutionInitializable = new GlobalPcmBeforeExecutionInitialization(experimentProvider, qvtoReconfigurationManager);
        beforeExecutionInitializables.add(beforeExecutionInitializable);
        Pair upperThresh = Pair.of((Object)((SimulatedMeasurementSpecification)pcmMeasurementSpecs.get(0)), (Object)Threshold.lessThanOrEqualTo((double)UPPER_THRESHOLD_RT.getValue()));
        Pair lowerThresh = Pair.of((Object)((SimulatedMeasurementSpecification)pcmMeasurementSpecs.get(0)), (Object)Threshold.lessThanOrEqualTo((double)LOWER_THRESHOLD_RT.getValue()));
        PerformabilityRewardEvaluation evaluator = new PerformabilityRewardEvaluation((PcmMeasurementSpecification)pcmMeasurementSpecs.get(0), (PcmMeasurementSpecification)pcmMeasurementSpecs.get(1), upperThresh, lowerThresh);
        PerformabilityStrategyConfiguration config = new PerformabilityStrategyConfiguration(SERVER_FAILURE_TEMPLATE_ID, LOAD_BALANCER_ID);
        FaultTolerantScalingNodeFailureRecoveryStrategy nodeRecoveryStrategy = new FaultTolerantScalingNodeFailureRecoveryStrategy(config, new RepositoryModelLookup(), new ResourceEnvironmentModelLookup(), new RepositoryModelUpdater());
        LoadBalancingEmptyReconfigurationPlanningStrategy emptyStrategy = new LoadBalancingEmptyReconfigurationPlanningStrategy((PcmMeasurementSpecification)pcmMeasurementSpecs.get(0), config, nodeRecoveryStrategy);
        LoadBalancingScalingPlanningStrategy loadBalancingPlanningStrategy = new LoadBalancingScalingPlanningStrategy((PcmMeasurementSpecification)pcmMeasurementSpecs.get(0), config, nodeRecoveryStrategy, LOWER_THRESHOLD_RT, UPPER_THRESHOLD_RT);
        FaultTolerantScalingPlanningStrategy reconfigurationPlanningStrategy = ftLoadBalancingScalingPlanningStrategy = new FaultTolerantScalingPlanningStrategy((PcmMeasurementSpecification)pcmMeasurementSpecs.get(0), config, nodeRecoveryStrategy, LOWER_THRESHOLD_RT, UPPER_THRESHOLD_RT);
        PerformabilityStrategy reconfSelectionPolicy = reconfStrategy = new PerformabilityStrategy((PcmMeasurementSpecification)pcmMeasurementSpecs.get(0), config, reconfigurationPlanningStrategy);
        IQVToReconfigurationProvider qvToReconfigurationProvider = qvtoReconfigurationManager.getQVToReconfigurationProvider();
        Set reconfigurations = qvToReconfigurationProvider.getReconfigurations();
        ExperienceSimulator simulator = this.createExperienceSimulator(experiment, pcmMeasurementSpecs, runners, this.getSimulationParameters(), beforeExecutionInitializables, envProcess, this.getSimulatedExperienceStore(), null, (Policy)reconfSelectionPolicy, reconfigurations, (RewardEvaluator)evaluator, false, experimentProvider, simulationRunnerHolder, null, this.getSeedProvider());
        String sampleSpaceId = SimulatedExperienceConstants.constructSampleSpaceId((String)this.getSimulationParameters().getSimulationID(), (String)reconfSelectionPolicy.getId());
        PerformabilityEvaluator rewardCalculation = new PerformabilityEvaluator(this.getSimulationParameters().getSimulationID(), sampleSpaceId);
        return new PcmExperienceSimulationExecutor(simulator, experiment, this.getSimulationParameters(), (Policy)reconfSelectionPolicy, (TotalRewardCalculation)rewardCalculation, experimentProvider);
    }
}

