/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.performability.loadbalancing;

import java.util.Optional;
import org.palladiosimulator.core.simulation.SimulationExecutor;
import org.palladiosimulator.simexp.commons.constants.model.QualityObjective;
import org.palladiosimulator.simexp.commons.constants.model.SimulationEngine;
import org.palladiosimulator.simexp.commons.constants.model.SimulatorType;
import org.palladiosimulator.simexp.core.store.DescriptionProvider;
import org.palladiosimulator.simexp.core.store.SimulatedExperienceStore;
import org.palladiosimulator.simexp.pcm.config.IWorkflowConfiguration;
import org.palladiosimulator.simexp.pcm.examples.executor.ModelLoader;
import org.palladiosimulator.simexp.pcm.examples.performability.loadbalancing.FaultTolerantLoadBalancingSimulationExecutorFactory;
import org.palladiosimulator.simexp.pcm.simulator.config.IPCMWorkflowConfiguration;
import org.palladiosimulator.simexp.workflow.api.ILaunchFactory;
import org.palladiosimulator.simexp.workflow.api.LaunchDescriptionProvider;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import tools.mdsd.probdist.api.random.ISeedProvider;

public class CustomFaultTolerantLoadBalancingLaunchFactory
implements ILaunchFactory {
    public boolean canHandle(IWorkflowConfiguration config) {
        SimulatorType simulatorType = config.getSimulatorType();
        if (simulatorType != SimulatorType.CUSTOM) {
            return false;
        }
        SimulationEngine simulationEngine = config.getSimulationEngine();
        if (simulationEngine != SimulationEngine.PCM) {
            return false;
        }
        IPCMWorkflowConfiguration pcmWorkflowConfiguration = (IPCMWorkflowConfiguration)config;
        QualityObjective qualityObjective = pcmWorkflowConfiguration.getQualityObjective();
        return qualityObjective == QualityObjective.PERFORMABILITY;
    }

    public SimulationExecutor createSimulationExecutor(IWorkflowConfiguration config, LaunchDescriptionProvider descriptionProvider, Optional<ISeedProvider> seedProvider, ModelLoader.Factory modelLoaderFactory) {
        IPCMWorkflowConfiguration workflowConfiguration = (IPCMWorkflowConfiguration)config;
        FaultTolerantLoadBalancingSimulationExecutorFactory factory = new FaultTolerantLoadBalancingSimulationExecutorFactory(workflowConfiguration, modelLoaderFactory, (SimulatedExperienceStore<QVTOReconfigurator, Double>)new SimulatedExperienceStore((DescriptionProvider)descriptionProvider), seedProvider);
        return factory.create();
    }
}

