/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.performability.loadbalancing;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.uka.ipd.sdq.stoex.StoexPackage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.naming.OperationNotSupportedException;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.envdyn.api.entity.bn.BayesianNetwork;
import org.palladiosimulator.envdyn.api.entity.bn.ConditionalInputValueUtil;
import org.palladiosimulator.envdyn.api.entity.bn.DynamicBayesianNetwork;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.pcm.usagemodel.OpenWorkload;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.simexp.distribution.function.ProbabilityMassFunction;
import org.palladiosimulator.simexp.environmentaldynamics.entity.DerivableEnvironmentalDynamic;
import org.palladiosimulator.simexp.environmentaldynamics.entity.EnvironmentalState;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivedElement;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivedSelectedInputValues;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivedValue;
import org.palladiosimulator.simexp.environmentaldynamics.process.EnvironmentProcess;
import org.palladiosimulator.simexp.environmentaldynamics.process.ObservableEnvironmentProcess;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Action;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.markovian.statespace.StateSpaceNavigator;
import org.palladiosimulator.simexp.pcm.binding.api.PcmModelChangeFactory;
import org.palladiosimulator.simexp.pcm.perceiption.PcmAttributeChange;
import org.palladiosimulator.simexp.pcm.perceiption.PcmEnvironmentalState;
import org.palladiosimulator.simexp.pcm.perceiption.PcmModelChange;
import org.palladiosimulator.simexp.pcm.perceiption.PerceivedValueConverter;
import org.palladiosimulator.simexp.pcm.util.ExperimentRunner;
import org.palladiosimulator.simexp.pcm.util.IExperimentProvider;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.random.ISeedProvider;
import tools.mdsd.probdist.api.random.ISeedable;

public class FaultTolerantVaryingInterarrivelRateProcess<C, A, Aa extends Action<A>, R>
implements ISeedable {
    private static final Logger LOGGER = Logger.getLogger((String)FaultTolerantVaryingInterarrivelRateProcess.class.getName());
    private static final String PCM_SPECIFICATION_ATTRIBUTE = StoexPackage.Literals.RANDOM_VARIABLE__SPECIFICATION.getName();
    private static final String WORKLOAD_VARIABLE = "GRV_StaticInstance_VaryingWorkload";
    private static final String PCM_RESOURCE_CONTAINER_SERVER_1_ATTRIBUTE = "ServerNode1";
    private static final String SERVER_NODE_1_VARIABLE = "GRV_StaticInstance_ServerNode1";
    private static final String PCM_RESOURCE_CONTAINER_SERVER_2_ATTRIBUTE = "ServerNode2";
    private static final String SERVER_NODE_2_VARIABLE = "GRV_StaticInstance_ServerNode2";
    private final PcmAttributeChange<List<InputValue<CategoricalValue>>> attrChange;
    private final PcmModelChange<List<InputValue<CategoricalValue>>> attrChangeServerNode1;
    private final PcmModelChange<List<InputValue<CategoricalValue>>> attrChangeServerNode2;
    private final EnvironmentProcess<A, R, List<InputValue<CategoricalValue>>> envProcess;
    private final ProbabilityMassFunction<State> initialDist;
    private final ConditionalInputValueUtil<CategoricalValue> conditionalInputValueUtil = new ConditionalInputValueUtil();
    private boolean initialized = false;

    public FaultTolerantVaryingInterarrivelRateProcess(DynamicBayesianNetwork<CategoricalValue> dbn, IExperimentProvider experimentProvider) {
        PerceivedValueConverter<List<InputValue<CategoricalValue>>> perceivedValueConverter = new PerceivedValueConverter<List<InputValue<CategoricalValue>>>(){

            public CategoricalValue convertElement(PerceivedValue<List<InputValue<CategoricalValue>>> change, String key) {
                PerceivedElement pe = (PerceivedElement)change;
                Optional values = pe.getElement(key);
                List valueList = (List)values.get();
                InputValue inputValue = (InputValue)valueList.get(0);
                CategoricalValue changedValue = (CategoricalValue)inputValue.getValue();
                return changedValue;
            }
        };
        this.attrChange = new PcmAttributeChange(this.retrieveInterArrivalTimeRandomVariableHandler(), PCM_SPECIFICATION_ATTRIBUTE, experimentProvider, (PerceivedValueConverter)perceivedValueConverter);
        this.attrChangeServerNode1 = PcmModelChangeFactory.createResourceContainerPcmModelChange((String)PCM_RESOURCE_CONTAINER_SERVER_1_ATTRIBUTE, (PerceivedValueConverter)perceivedValueConverter, (IExperimentProvider)experimentProvider);
        this.attrChangeServerNode2 = PcmModelChangeFactory.createResourceContainerPcmModelChange((String)PCM_RESOURCE_CONTAINER_SERVER_2_ATTRIBUTE, (PerceivedValueConverter)perceivedValueConverter, (IExperimentProvider)experimentProvider);
        this.initialDist = this.createInitialDist(dbn);
        this.envProcess = this.createEnvironmentalProcess(dbn);
    }

    public void init(Optional<ISeedProvider> seedProvider) {
        this.initialized = true;
        this.initialDist.init(seedProvider);
    }

    public EnvironmentProcess<A, R, List<InputValue<CategoricalValue>>> getEnvironmentProcess() {
        if (!this.initialized) {
            throw new RuntimeException("not initialized");
        }
        return this.envProcess;
    }

    private Function<ExperimentRunner, EObject> retrieveInterArrivalTimeRandomVariableHandler() {
        return expRunner -> {
            PCMResourceSetPartition pcm = expRunner.getWorkingPartition();
            OpenWorkload workload = (OpenWorkload)((UsageScenario)pcm.getUsageModel().getUsageScenario_UsageModel().get(0)).getWorkload_UsageScenario();
            return workload.getInterArrivalTime_OpenWorkload();
        };
    }

    private EnvironmentProcess<A, R, List<InputValue<CategoricalValue>>> createEnvironmentalProcess(DynamicBayesianNetwork<CategoricalValue> dbn) {
        return new ObservableEnvironmentProcess(this.createDerivableProcess(dbn), null, this.initialDist);
    }

    private ProbabilityMassFunction<State> createInitialDist(DynamicBayesianNetwork<CategoricalValue> dbn) {
        return new ProbabilityMassFunction<State>(dbn){
            private final BayesianNetwork<CategoricalValue> bn;
            private boolean initialized;
            {
                this.bn = dynamicBayesianNetwork.getBayesianNetwork();
                this.initialized = false;
            }

            public void init(Optional<ISeedProvider> seedProvider) {
                this.initialized = true;
                this.bn.init(seedProvider);
            }

            public ProbabilityMassFunction.Sample<State> drawSample() {
                if (!this.initialized) {
                    throw new RuntimeException("not initialized");
                }
                List sample = this.bn.sample();
                return ProbabilityMassFunction.Sample.of(FaultTolerantVaryingInterarrivelRateProcess.this.asPcmEnvironmentalState(sample), (double)this.bn.probability(sample));
            }

            public double probability(ProbabilityMassFunction.Sample<State> sample) {
                List<InputValue<CategoricalValue>> inputs = FaultTolerantVaryingInterarrivelRateProcess.toInputs(sample);
                if (inputs.isEmpty()) {
                    return 0.0;
                }
                return this.bn.probability(inputs);
            }
        };
    }

    private DerivableEnvironmentalDynamic<A> createDerivableProcess(final DynamicBayesianNetwork<CategoricalValue> dbn) {
        return new DerivableEnvironmentalDynamic<A>(){
            private boolean explorationMode = false;

            public void pursueExplorationStrategy() {
                this.explorationMode = true;
            }

            public void pursueExploitationStrategy() {
                this.explorationMode = false;
            }

            public EnvironmentalState<List<InputValue<CategoricalValue>>> navigate(StateSpaceNavigator.NavigationContext<A> context) {
                EnvironmentalState envState = (EnvironmentalState)EnvironmentalState.class.cast(context.getSource());
                List<InputValue<CategoricalValue>> inputs = FaultTolerantVaryingInterarrivelRateProcess.toInputs(envState.getValue().getValue());
                if (this.explorationMode) {
                    return this.sampleRandomly(FaultTolerantVaryingInterarrivelRateProcess.this.conditionalInputValueUtil.toConditionalInputs(inputs));
                }
                return this.sample(FaultTolerantVaryingInterarrivelRateProcess.this.conditionalInputValueUtil.toConditionalInputs(inputs));
            }

            private EnvironmentalState<List<InputValue<CategoricalValue>>> sample(List<DynamicBayesianNetwork.ConditionalInputValue<CategoricalValue>> conditionalInputs) {
                DynamicBayesianNetwork.Trajectory traj = dbn.given(FaultTolerantVaryingInterarrivelRateProcess.this.conditionalInputValueUtil.asConditionals(conditionalInputs)).sample();
                return FaultTolerantVaryingInterarrivelRateProcess.this.asPcmEnvironmentalState(traj.valueAtTime(0));
            }

            private EnvironmentalState<List<InputValue<CategoricalValue>>> sampleRandomly(List<DynamicBayesianNetwork.ConditionalInputValue<CategoricalValue>> conditionalInputs) {
                throw new RuntimeException(new OperationNotSupportedException("The method is not implemented yet."));
            }
        };
    }

    public static List<InputValue<CategoricalValue>> toInputs(Object sample) {
        List inputs;
        if (List.class.isInstance(sample) && !(inputs = (List)List.class.cast(sample)).isEmpty() && InputValue.class.isInstance(inputs.get(0))) {
            return inputs.stream().map(InputValue.class::cast).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    private EnvironmentalState<List<InputValue<CategoricalValue>>> asPcmEnvironmentalState(List<InputValue<CategoricalValue>> sample) {
        ArrayList<Object> attrChanges = new ArrayList<Object>();
        attrChanges.add(this.attrChange);
        attrChanges.add(this.attrChangeServerNode1);
        attrChanges.add(this.attrChangeServerNode2);
        return new PcmEnvironmentalState(attrChanges, this.asPerceivedValue(sample));
    }

    private PerceivedValue<List<InputValue<CategoricalValue>>> asPerceivedValue(List<InputValue<CategoricalValue>> sample) {
        HashMap attributeMap = Maps.newHashMap();
        attributeMap.put(PCM_SPECIFICATION_ATTRIBUTE, WORKLOAD_VARIABLE);
        attributeMap.put(PCM_RESOURCE_CONTAINER_SERVER_1_ATTRIBUTE, SERVER_NODE_1_VARIABLE);
        attributeMap.put(PCM_RESOURCE_CONTAINER_SERVER_2_ATTRIBUTE, SERVER_NODE_2_VARIABLE);
        PerceivedSelectedInputValues perceivedValue = new PerceivedSelectedInputValues(sample, (Map)attributeMap);
        return perceivedValue;
    }
}

