/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.performability.loadbalancing;

import java.util.List;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.pcm.query.RepositoryModelLookup;
import org.palladiosimulator.pcm.query.ResourceEnvironmentModelLookup;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.simexp.core.state.ArchitecturalConfiguration;
import org.palladiosimulator.simexp.core.state.SelfAdaptiveSystemState;
import org.palladiosimulator.simexp.core.strategy.SharedKnowledge;
import org.palladiosimulator.simexp.pcm.examples.performability.AbstractNodeRecoveryStrategy;
import org.palladiosimulator.simexp.pcm.examples.performability.PerformabilityStrategyConfiguration;
import org.palladiosimulator.simexp.pcm.examples.performability.RepositoryModelUpdater;
import org.palladiosimulator.solver.core.models.PCMInstance;
import tools.mdsd.probdist.api.entity.CategoricalValue;

public class LoadBalancerNodeFailureRecoveryStrategy<A>
extends AbstractNodeRecoveryStrategy<PCMInstance, A> {
    private final String loadBalancerId = "_xISeMAEpEeS7FKokKTKFow";
    private final String loadBalancerEntityName = "LoadBalancer";
    private final String loadBalancerSeffBranchActionId = "_m2PcEAEoEeS7FKokKTKFow";
    private final String serverNodeOneId = "_yaTfsAEpEeS7FKokKTKFow";
    private final String serverNodeOneEntityName = "ServerNode1";
    private final String serverNodeTwoId = "_3uVlIAEpEeS7FKokKTKFow";
    private final String serverNodeTwoEntityName = "ServerNode2";

    public LoadBalancerNodeFailureRecoveryStrategy(PerformabilityStrategyConfiguration strategyConfiguration, RepositoryModelLookup repositoryLookup, ResourceEnvironmentModelLookup resourceEnvLookup, RepositoryModelUpdater repositoryUpdater) {
        super(strategyConfiguration, repositoryLookup, resourceEnvLookup, repositoryUpdater);
    }

    public void execute(SelfAdaptiveSystemState<PCMInstance, A, List<InputValue<CategoricalValue>>> sasState, SharedKnowledge knowledge) {
        LOGGER.info((Object)String.format("'EXECUTE' apply reconfiguration 'nodeRecovery' workaround %s ", LoadBalancerNodeFailureRecoveryStrategy.class.getName()));
        String serverNode1State = knowledge.getValue("_yaTfsAEpEeS7FKokKTKFow").get().toString();
        String serverNode2State = knowledge.getValue("_3uVlIAEpEeS7FKokKTKFow").get().toString();
        LOGGER.info((Object)String.format("Knowledge: [%s,%s], [%s,&%s]", "_yaTfsAEpEeS7FKokKTKFow", serverNode1State, "_3uVlIAEpEeS7FKokKTKFow", serverNode2State));
        ArchitecturalConfiguration architecturalConfig = sasState.getArchitecturalConfiguration();
        PCMInstance pcmInstance = (PCMInstance)architecturalConfig.getConfiguration();
        List repositories = pcmInstance.getRepositories();
        Repository defaultRepository = this.repositoryLookup.findRepositoryByEntityName(repositories, "defaultRepository");
        ProbabilisticBranchTransition probBranchTransitionToServerNode1 = this.findProbabilisticBranchTransitionToServerNode(defaultRepository, "_xISeMAEpEeS7FKokKTKFow", "processRequest", "delegateToServer1", "AC_Server1", "_m2PcEAEoEeS7FKokKTKFow");
        ProbabilisticBranchTransition probBranchTransitionToServerNode2 = this.findProbabilisticBranchTransitionToServerNode(defaultRepository, "_xISeMAEpEeS7FKokKTKFow", "processRequest", "delegateToServer2", "AC_Server2", "_m2PcEAEoEeS7FKokKTKFow");
        if (serverNode1State.equals("unavailable") && serverNode2State.equals("unavailable")) {
            this.repositoryUpdater.updateBranchProbability(probBranchTransitionToServerNode1, 0.0);
            this.repositoryUpdater.updateBranchProbability(probBranchTransitionToServerNode2, 0.0);
        } else if (serverNode1State.equals("available") && serverNode2State.equals("available")) {
            if (0.0 == probBranchTransitionToServerNode1.getBranchProbability() || 0.0 == probBranchTransitionToServerNode2.getBranchProbability()) {
                this.repositoryUpdater.updateBranchProbability(probBranchTransitionToServerNode1, 0.5);
                this.repositoryUpdater.updateBranchProbability(probBranchTransitionToServerNode2, 0.5);
            }
        } else if (serverNode1State.equals("unavailable") && serverNode2State.equals("available")) {
            this.repositoryUpdater.updateBranchProbability(probBranchTransitionToServerNode1, 0.0);
            this.repositoryUpdater.updateBranchProbability(probBranchTransitionToServerNode2, 1.0);
        } else if (serverNode1State.equals("available") && serverNode2State.equals("unavailable")) {
            this.repositoryUpdater.updateBranchProbability(probBranchTransitionToServerNode1, 1.0);
            this.repositoryUpdater.updateBranchProbability(probBranchTransitionToServerNode2, 0.0);
        } else {
            LOGGER.debug((Object)"Failed to perform load balancer node failure recovery strategy. Unable to identify connected nodes.");
        }
        ResourceEnvironment resourceEnv = pcmInstance.getResourceEnvironment();
        ResourceContainer node1 = this.resourceEnvLookup.findResourceContainerById(resourceEnv, "_yaTfsAEpEeS7FKokKTKFow");
        ResourceContainer node2 = this.resourceEnvLookup.findResourceContainerById(resourceEnv, "_3uVlIAEpEeS7FKokKTKFow");
        this.logMsg(node1.getEntityName(), node2.getEntityName(), "_yaTfsAEpEeS7FKokKTKFow", "_3uVlIAEpEeS7FKokKTKFow", serverNode1State, serverNode2State, probBranchTransitionToServerNode1.getBranchProbability(), probBranchTransitionToServerNode2.getBranchProbability());
        LOGGER.info((Object)String.format("'EXECUTE' applied reconfiguration 'nodeRecovery' workaround %s ", LoadBalancerNodeFailureRecoveryStrategy.class.getName()));
    }
}

