/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.performability.loadbalancing;

import java.util.Set;
import org.palladiosimulator.simexp.core.state.SelfAdaptiveSystemState;
import org.palladiosimulator.simexp.core.strategy.SharedKnowledge;
import org.palladiosimulator.simexp.core.util.Threshold;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.performability.NodeRecoveryStrategy;
import org.palladiosimulator.simexp.pcm.examples.performability.PerformabilityStrategyConfiguration;
import org.palladiosimulator.simexp.pcm.examples.performability.PolicySelectionException;
import org.palladiosimulator.simexp.pcm.examples.performability.loadbalancing.AbstractLoadBalancingScalingPlanningStrategy;
import org.palladiosimulator.simexp.pcm.state.PcmMeasurementSpecification;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;

public class LoadBalancingScalingPlanningStrategy<C>
extends AbstractLoadBalancingScalingPlanningStrategy<C> {
    private static final String SCALE_IN_QVTO_NAME = "scaleIn";
    private static final String SCALE_OUT_SOURCE_QVTO_NAME = "scaleOut";

    public LoadBalancingScalingPlanningStrategy(PcmMeasurementSpecification responseTimeSpec, PerformabilityStrategyConfiguration strategyConfiguration, NodeRecoveryStrategy<C, QVTOReconfigurator> recoveryStrategy, Threshold lowerThresholdResponseTime, Threshold upperThresholdResponseTime) {
        super(responseTimeSpec, strategyConfiguration, recoveryStrategy, lowerThresholdResponseTime, upperThresholdResponseTime);
    }

    public QVToReconfiguration planReconfigurationSteps(State source, Set<QVToReconfiguration> options, SharedKnowledge knowledge) throws PolicySelectionException {
        SelfAdaptiveSystemState sasState = (SelfAdaptiveSystemState)source;
        Double responseTime = this.retrieveResponseTime(sasState);
        if (this.isExceeded(responseTime)) {
            return this.lookupReconfigure(SCALE_OUT_SOURCE_QVTO_NAME, options);
        }
        if (this.isSubceeded(responseTime)) {
            return this.lookupReconfigure(SCALE_IN_QVTO_NAME, options);
        }
        return this.emptyReconfiguration();
    }
}

