/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.performability.loadbalancing;

import java.util.Map;
import java.util.Set;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.simexp.core.state.SelfAdaptiveSystemState;
import org.palladiosimulator.simexp.core.strategy.SharedKnowledge;
import org.palladiosimulator.simexp.core.util.Threshold;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.performability.NodeRecoveryStrategy;
import org.palladiosimulator.simexp.pcm.examples.performability.PerformabilityStrategyConfiguration;
import org.palladiosimulator.simexp.pcm.examples.performability.PolicySelectionException;
import org.palladiosimulator.simexp.pcm.examples.performability.loadbalancing.AbstractLoadBalancingScalingPlanningStrategy;
import org.palladiosimulator.simexp.pcm.state.PcmMeasurementSpecification;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import tools.mdsd.probdist.api.entity.CategoricalValue;

public class FaultTolerantScalingPlanningStrategy<C>
extends AbstractLoadBalancingScalingPlanningStrategy<C> {
    private static final String SCALE_IN_QVTO_NAME = "scaleIn";
    private static final String SCALE_OUT_SOURCE_QVTO_NAME = "scaleOut";

    public FaultTolerantScalingPlanningStrategy(PcmMeasurementSpecification responseTimeSpec, PerformabilityStrategyConfiguration strategyConfiguration, NodeRecoveryStrategy<C, QVTOReconfigurator> recoveryStrategy, Threshold lowerThresholdResponseTime, Threshold upperThresholdResponseTime) {
        super(responseTimeSpec, strategyConfiguration, recoveryStrategy, lowerThresholdResponseTime, upperThresholdResponseTime);
    }

    public QVToReconfiguration planReconfigurationSteps(State source, Set<QVToReconfiguration> options, SharedKnowledge knowledge) throws PolicySelectionException {
        SelfAdaptiveSystemState sasState = (SelfAdaptiveSystemState)source;
        Double responseTime = this.retrieveResponseTime(sasState);
        Map serverNodeStates = this.retrieveServerNodeStates(sasState.getPerceivedEnvironmentalState());
        if (this.allNodesAreAvailable(serverNodeStates)) {
            if (this.isExceeded(responseTime)) {
                return this.lookupReconfigure(SCALE_OUT_SOURCE_QVTO_NAME, options);
            }
            if (this.isSubceeded(responseTime)) {
                return this.lookupReconfigure(SCALE_IN_QVTO_NAME, options);
            }
        } else {
            this.recoveryStrategy.execute(sasState, knowledge);
        }
        return this.emptyReconfiguration();
    }

    private boolean allNodesAreAvailable(Map<ResourceContainer, CategoricalValue> serverNodeStates) {
        return serverNodeStates.values().stream().allMatch(v -> ((String)v.get()).equals("available"));
    }
}

