/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.performability;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundRandomVariable;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurement;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurementSpecification;
import org.palladiosimulator.simexp.core.state.SelfAdaptiveSystemState;
import org.palladiosimulator.simexp.core.strategy.ReconfigurationStrategy;
import org.palladiosimulator.simexp.core.strategy.SharedKnowledge;
import org.palladiosimulator.simexp.core.util.Threshold;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivableEnvironmentalState;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.pcm.action.EmptyQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.performability.PerformabilityStrategyConfiguration;
import org.palladiosimulator.simexp.pcm.examples.performability.PolicySelectionException;
import org.palladiosimulator.simexp.pcm.examples.performability.ReconfigurationPlanningStrategy;
import org.palladiosimulator.simexp.pcm.examples.utils.EnvironmentalDynamicsUtils;
import org.palladiosimulator.simexp.pcm.state.PcmMeasurementSpecification;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import tools.mdsd.probdist.api.entity.CategoricalValue;

public class PerformabilityStrategy<C>
extends ReconfigurationStrategy<QVTOReconfigurator, QVToReconfiguration> {
    private static final Logger LOGGER = Logger.getLogger((String)PerformabilityStrategy.class.getName());
    private static final String SCALE_IN_QVTO_NAME = "scaleIn";
    private static final String SCALE_OUT_SOURCE_QVTO_NAME = "scaleOut";
    private static final String NODE_RECOVERY_QVTO_NAME = "nodeRecovery";
    private static final String AVAILABLE_STATE = "available";
    private static final Threshold UPPER_THRESHOLD = Threshold.lessThanOrEqualTo((double)2.0);
    private static final Threshold LOWER_THRESHOLD = Threshold.greaterThanOrEqualTo((double)1.0);
    private final PcmMeasurementSpecification responseTimeSpec;
    private final PerformabilityStrategyConfiguration strategyConfiguration;
    private final ReconfigurationPlanningStrategy reconfigurationPlanningStrategy;

    public PerformabilityStrategy(PcmMeasurementSpecification responseTimeSpec, PerformabilityStrategyConfiguration strategyConfiguration, ReconfigurationPlanningStrategy reconfigurationPlanningStrategy) {
        super(null);
        this.responseTimeSpec = responseTimeSpec;
        this.strategyConfiguration = strategyConfiguration;
        this.reconfigurationPlanningStrategy = reconfigurationPlanningStrategy;
    }

    public String getId() {
        return PerformabilityStrategy.class.getName();
    }

    protected void monitor(State source, SharedKnowledge knowledge) {
        SelfAdaptiveSystemState sasState = (SelfAdaptiveSystemState)source;
        Map<ResourceContainer, CategoricalValue> serverNodeStates = this.retrieveServerNodeStates((PerceivableEnvironmentalState<List<InputValue<CategoricalValue>>>)sasState.getPerceivedEnvironmentalState());
        for (Map.Entry<ResourceContainer, CategoricalValue> entry : serverNodeStates.entrySet()) {
            String key = entry.getKey().getId();
            CategoricalValue value = entry.getValue();
            knowledge.store(key, (Object)value);
        }
    }

    protected boolean analyse(State source, SharedKnowledge knowledge) {
        boolean hasConstraintViolations = false;
        SelfAdaptiveSystemState sasState = (SelfAdaptiveSystemState)source;
        Double responseTime = this.retrieveResponseTime(sasState);
        Map<ResourceContainer, CategoricalValue> serverNodeStates = this.retrieveServerNodeStates((PerceivableEnvironmentalState<List<InputValue<CategoricalValue>>>)sasState.getPerceivedEnvironmentalState());
        if (this.isExceeded(responseTime) || this.isSubceeded(responseTime)) {
            hasConstraintViolations = true;
        }
        if (!this.allNodesAreAvailable(serverNodeStates)) {
            hasConstraintViolations = true;
        }
        return hasConstraintViolations;
    }

    protected QVToReconfiguration plan(State source, Set<QVToReconfiguration> options, SharedKnowledge knowledge) {
        QVToReconfiguration plannedAction = this.emptyReconfiguration();
        try {
            plannedAction = this.reconfigurationPlanningStrategy.planReconfigurationSteps(source, options, knowledge);
            return plannedAction;
        }
        catch (PolicySelectionException e) {
            LOGGER.error((Object)"Failed to select an adaptation strategy", (Throwable)e);
            return this.emptyReconfiguration();
        }
    }

    protected QVToReconfiguration emptyReconfiguration() {
        return EmptyQVToReconfiguration.empty();
    }

    private Double retrieveResponseTime(SelfAdaptiveSystemState<C, QVTOReconfigurator, List<InputValue<CategoricalValue>>> sasState) {
        SimulatedMeasurement simMeasurement = (SimulatedMeasurement)sasState.getQuantifiedState().findMeasurementWith((SimulatedMeasurementSpecification)this.responseTimeSpec).orElseThrow();
        return simMeasurement.getValue();
    }

    private Map<ResourceContainer, CategoricalValue> retrieveServerNodeStates(PerceivableEnvironmentalState<List<InputValue<CategoricalValue>>> state) {
        HashMap serverNodeStates = Maps.newHashMap();
        List inputs = EnvironmentalDynamicsUtils.toInputs((Object)state.getValue().getValue());
        for (InputValue each : inputs) {
            ResourceContainer container = this.findAppliedObjectsReferencedResourceContainer((InputValue<CategoricalValue>)each);
            if (container == null) continue;
            CategoricalValue nodeState = (CategoricalValue)each.getValue();
            serverNodeStates.put(container, nodeState);
        }
        if (serverNodeStates.isEmpty()) {
            throw new RuntimeException("Environment model holds no specification of node failure random variables. Unabled to run performability strategy.");
        }
        return serverNodeStates;
    }

    private ResourceContainer findAppliedObjectsReferencedResourceContainer(InputValue<CategoricalValue> inputValue) {
        GroundRandomVariable grVariable = inputValue.getVariable();
        if (this.isServerNodeVariable(grVariable)) {
            EList appliedObjects = grVariable.getAppliedObjects();
            for (EObject appliedObject : appliedObjects) {
                if (!(appliedObject instanceof ResourceContainer)) continue;
                return (ResourceContainer)appliedObject;
            }
        }
        return null;
    }

    private boolean allNodesAreAvailable(Map<ResourceContainer, CategoricalValue> serverNodeStates) {
        return serverNodeStates.values().stream().allMatch(v -> ((String)v.get()).equals(AVAILABLE_STATE));
    }

    private boolean isExceeded(Double responseTime) {
        return UPPER_THRESHOLD.isNotSatisfied(responseTime.doubleValue());
    }

    private boolean isSubceeded(Double responseTime) {
        return LOWER_THRESHOLD.isNotSatisfied(responseTime.doubleValue());
    }

    private QVToReconfiguration scaleIn(Set<QVToReconfiguration> options) throws PolicySelectionException {
        return this.findReconfiguration(SCALE_IN_QVTO_NAME, options).orElseThrow(() -> new PolicySelectionException(this.missingQvtoTransformationMessage(SCALE_IN_QVTO_NAME)));
    }

    private QVToReconfiguration outSource(Set<QVToReconfiguration> options) throws PolicySelectionException {
        return this.findReconfiguration(SCALE_OUT_SOURCE_QVTO_NAME, options).orElseThrow(() -> new PolicySelectionException(this.missingQvtoTransformationMessage(SCALE_OUT_SOURCE_QVTO_NAME)));
    }

    private QVToReconfiguration nodeRecovery(Set<QVToReconfiguration> options) throws PolicySelectionException {
        return this.findReconfiguration(NODE_RECOVERY_QVTO_NAME, options).orElseThrow(() -> new PolicySelectionException(this.missingQvtoTransformationMessage(NODE_RECOVERY_QVTO_NAME)));
    }

    private boolean isServerNodeVariable(GroundRandomVariable variable) {
        return variable.getInstantiatedTemplate().getId().equals(this.strategyConfiguration.getNodeFailureTemplateId());
    }

    private Optional<QVToReconfiguration> findReconfiguration(String name, Set<QVToReconfiguration> options2) {
        List options = options2.stream().filter(QVToReconfiguration.class::isInstance).map(QVToReconfiguration.class::cast).collect(Collectors.toList());
        for (QVToReconfiguration each : options) {
            String reconfName = each.getReconfigurationName();
            if (!reconfName.equals(name)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private String missingQvtoTransformationMessage(String qvtoTransformationName) {
        return String.format("No QVT transformation named '%s' available. Ensure your model defines a corresponding transformation.", qvtoTransformationName);
    }
}

