/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.performability;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundRandomVariable;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurement;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurementSpecification;
import org.palladiosimulator.simexp.core.state.SelfAdaptiveSystemState;
import org.palladiosimulator.simexp.core.strategy.SharedKnowledge;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivableEnvironmentalState;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.pcm.action.EmptyQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.performability.NodeRecoveryStrategy;
import org.palladiosimulator.simexp.pcm.examples.performability.PerformabilityStrategyConfiguration;
import org.palladiosimulator.simexp.pcm.examples.performability.PolicySelectionException;
import org.palladiosimulator.simexp.pcm.examples.performability.ReconfigurationPlanningStrategy;
import org.palladiosimulator.simexp.pcm.examples.utils.EnvironmentalDynamicsUtils;
import org.palladiosimulator.simexp.pcm.state.PcmMeasurementSpecification;
import tools.mdsd.probdist.api.entity.CategoricalValue;

public abstract class AbstractReconfigurationPlanningStrategy<C, A>
implements ReconfigurationPlanningStrategy {
    protected static final Logger LOGGER = Logger.getLogger((String)ReconfigurationPlanningStrategy.class.getName());
    private final PcmMeasurementSpecification responseTimeSpec;
    private final PerformabilityStrategyConfiguration strategyConfiguration;
    protected final NodeRecoveryStrategy<C, A> recoveryStrategy;

    public AbstractReconfigurationPlanningStrategy(PcmMeasurementSpecification responseTimeSpec, PerformabilityStrategyConfiguration strategyConfiguration, NodeRecoveryStrategy<C, A> recoveryStrategy) {
        this.responseTimeSpec = responseTimeSpec;
        this.strategyConfiguration = strategyConfiguration;
        this.recoveryStrategy = recoveryStrategy;
    }

    @Override
    public abstract QVToReconfiguration planReconfigurationSteps(State var1, Set<QVToReconfiguration> var2, SharedKnowledge var3) throws PolicySelectionException;

    protected Double retrieveResponseTime(SelfAdaptiveSystemState<C, A, List<InputValue<CategoricalValue>>> sasState) {
        SimulatedMeasurement simMeasurement = (SimulatedMeasurement)sasState.getQuantifiedState().findMeasurementWith((SimulatedMeasurementSpecification)this.responseTimeSpec).orElseThrow();
        return simMeasurement.getValue();
    }

    protected Map<ResourceContainer, CategoricalValue> retrieveServerNodeStates(PerceivableEnvironmentalState<List<InputValue<CategoricalValue>>> state) {
        HashMap serverNodeStates = Maps.newHashMap();
        List inputs = EnvironmentalDynamicsUtils.toInputs((Object)state.getValue().getValue());
        for (InputValue each : inputs) {
            ResourceContainer container = this.findAppliedObjectsReferencedResourceContainer((InputValue<CategoricalValue>)each);
            if (container == null) continue;
            CategoricalValue nodeState = (CategoricalValue)each.getValue();
            serverNodeStates.put(container, nodeState);
        }
        if (serverNodeStates.isEmpty()) {
            throw new RuntimeException("Environment model holds no specification of node failure random variables. Unabled to run performability strategy.");
        }
        return serverNodeStates;
    }

    private ResourceContainer findAppliedObjectsReferencedResourceContainer(InputValue<CategoricalValue> inputValue) {
        GroundRandomVariable grVariable = inputValue.getVariable();
        if (this.isServerNodeVariable(grVariable)) {
            EList appliedObjects = grVariable.getAppliedObjects();
            for (EObject appliedObject : appliedObjects) {
                if (!(appliedObject instanceof ResourceContainer)) continue;
                return (ResourceContainer)appliedObject;
            }
        }
        return null;
    }

    private boolean isServerNodeVariable(GroundRandomVariable variable) {
        return variable.getInstantiatedTemplate().getId().equals(this.strategyConfiguration.getNodeFailureTemplateId());
    }

    protected Optional<QVToReconfiguration> findReconfiguration(String name, Set<QVToReconfiguration> options2) {
        List options = options2.stream().filter(QVToReconfiguration.class::isInstance).map(QVToReconfiguration.class::cast).collect(Collectors.toList());
        for (QVToReconfiguration each : options) {
            String reconfName = each.getReconfigurationName();
            if (!reconfName.equals(name)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    protected String missingQvtoTransformationMessage(String qvtoTransformationName) {
        return String.format("No QVT transformation named '%s' available. Ensure your model defines a corresponding transformation.", qvtoTransformationName);
    }

    protected QVToReconfiguration emptyReconfiguration() {
        return EmptyQVToReconfiguration.empty();
    }
}

