/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.action;

import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.palladiosimulator.simexp.pcm.action.BaseQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.SingleQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.util.IExperimentProvider;

public class MultiQVToReconfiguration
extends BaseQVToReconfiguration
implements QVToReconfiguration {
    private static final Logger LOGGER = Logger.getLogger(MultiQVToReconfiguration.class);
    private final List<SingleQVToReconfiguration> reconfigurations;

    private MultiQVToReconfiguration(List<SingleQVToReconfiguration> reconfigurations) {
        this.reconfigurations = Collections.unmodifiableList(reconfigurations);
    }

    public static MultiQVToReconfiguration of(List<SingleQVToReconfiguration> reconfigurations) {
        return new MultiQVToReconfiguration(reconfigurations);
    }

    @Override
    public void execute(IExperimentProvider experimentProvider, IResourceTableManager resourceTableManager) {
        if (this.isEmptyReconfiguration()) {
            return;
        }
        LOGGER.info((Object)String.format("'EXECUTE' applying %d single reconfigurations", this.reconfigurations.size()));
        for (SingleQVToReconfiguration reconf : this.reconfigurations) {
            reconf.execute(experimentProvider, resourceTableManager);
        }
    }

    @Override
    protected boolean isEmptyReconfiguration() {
        return this.reconfigurations.isEmpty();
    }

    @Override
    protected String getTransformationName() {
        ArrayList<String> names = new ArrayList<String>();
        for (SingleQVToReconfiguration reconf : this.reconfigurations) {
            names.add(reconf.getTransformationName());
        }
        return StringUtils.join(names, (String)",");
    }
}

