/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.action;

import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.palladiosimulator.simexp.pcm.action.BaseQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.IQVToReconfigurationManager;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.util.IExperimentProvider;
import org.palladiosimulator.simulizar.core.reconfiguration.IReconfigurationEngine;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QvtoModelTransformation;

public class SingleQVToReconfiguration
extends BaseQVToReconfiguration
implements QVToReconfiguration {
    private static final Logger LOGGER = Logger.getLogger(SingleQVToReconfiguration.class);
    private final QvtoModelTransformation transformation;
    private final IQVToReconfigurationManager qvtoReconfigurationManager;

    protected SingleQVToReconfiguration(SingleQVToReconfiguration transformation) {
        this(transformation.transformation, transformation.qvtoReconfigurationManager);
    }

    protected SingleQVToReconfiguration(QvtoModelTransformation transformation, IQVToReconfigurationManager qvtoReconfigurationManager) {
        this.transformation = transformation;
        this.qvtoReconfigurationManager = qvtoReconfigurationManager;
    }

    public static SingleQVToReconfiguration of(QvtoModelTransformation transformation, IQVToReconfigurationManager qvtoReconfigurationManager) {
        return new SingleQVToReconfiguration(transformation, qvtoReconfigurationManager);
    }

    @Override
    public void execute(IExperimentProvider experimentProvider, IResourceTableManager resourceTableManager) {
        if (this.isEmptyReconfiguration()) {
            return;
        }
        QVTOReconfigurator qvtoReconf = this.qvtoReconfigurationManager.getReconfigurator(experimentProvider);
        String transformationName = this.transformation.getTransformationName();
        boolean succeded = this.executeTransformation((IReconfigurationEngine)qvtoReconf, this.transformation, resourceTableManager);
        if (succeded) {
            LOGGER.info((Object)String.format("'EXECUTE' applied reconfiguration '%s'", transformationName));
        } else {
            LOGGER.error((Object)String.format("'EXECUTE' failed to apply reconfiguration: reconfiguration engine could not execute reconfiguration '%s'", transformationName));
        }
    }

    protected boolean executeTransformation(IReconfigurationEngine qvtoReconf, QvtoModelTransformation transformation, IResourceTableManager resourceTableManager) {
        List<QvtoModelTransformation> actions = Collections.singletonList(transformation);
        boolean succeded = qvtoReconf.runExecute(actions, null, resourceTableManager);
        return succeded;
    }

    @Override
    protected boolean isEmptyReconfiguration() {
        return this.transformation == null;
    }

    @Override
    protected String getTransformationName() {
        return this.transformation.getTransformationName();
    }
}

