/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.process;

import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.io.IOException;
import org.palladiosimulator.failuremodel.failurescenario.FailureScenarioRepository;
import org.palladiosimulator.failuremodel.failurescenario.FailurescenarioPackage;
import org.palladiosimulator.failuremodel.failuretype.FailureTypeRepository;
import org.palladiosimulator.failuremodel.failuretype.FailuretypePackage;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.pcm.datasource.DataSource;
import org.palladiosimulator.simexp.pcm.datasource.EDP2DataSource;
import org.palladiosimulator.simexp.pcm.process.PcmExperienceSimulationRunner;
import org.palladiosimulator.simexp.pcm.state.InitialPcmStateCreator;
import org.palladiosimulator.simexp.pcm.state.failure.NodeFailureStateCreator;
import org.palladiosimulator.simexp.pcm.state.failure.NodeFailureTypeCreator;
import org.palladiosimulator.simexp.pcm.util.ExperimentRunner;
import org.palladiosimulator.simexp.pcm.util.IExperimentProvider;

public class PerformabilityPcmExperienceSimulationRunner<A, V>
extends PcmExperienceSimulationRunner<A, V> {
    private NodeFailureTypeCreator failureTypeCeator = new NodeFailureTypeCreator();
    private NodeFailureStateCreator failureStateCreator = new NodeFailureStateCreator();
    private final IExperimentProvider experimentProvider;

    public PerformabilityPcmExperienceSimulationRunner(IExperimentProvider experimentProvider, InitialPcmStateCreator<A, V> initialStateCreator) {
        this(new EDP2DataSource<A, V>(initialStateCreator), experimentProvider);
    }

    public PerformabilityPcmExperienceSimulationRunner(DataSource dataSource, IExperimentProvider experimentProvider) {
        super(dataSource, experimentProvider);
        this.experimentProvider = experimentProvider;
    }

    protected void doInitialize() {
        FailureScenarioRepository failureScenarioRepo;
        try {
            FailureTypeRepository failureTypeRepo = this.failureTypeCeator.create();
            failureScenarioRepo = this.failureStateCreator.createRepo();
            this.experimentProvider.getExperimentRunner().injectFailureScenario(failureScenarioRepo, failureTypeRepo);
            LOGGER.info((Object)"Initialized failure scenario models.");
        }
        catch (IOException e) {
            LOGGER.error((Object)"Failed to inject failurescenario models into blackboard partition", (Throwable)e);
        }
        ResourceSetPartition plainPartition = this.experimentProvider.getExperimentRunner().getPlainWorkingPartition();
        failureScenarioRepo = (FailureScenarioRepository)plainPartition.getElement(FailurescenarioPackage.eINSTANCE.getFailureScenarioRepository()).get(0);
        FailureTypeRepository failureTypeRepo = (FailureTypeRepository)plainPartition.getElement(FailuretypePackage.eINSTANCE.getFailureTypeRepository()).get(0);
        assert (failureScenarioRepo != null);
        assert (failureTypeRepo != null);
    }

    protected void postSimulate(State state) {
        ExperimentRunner expRunner = this.experimentProvider.getExperimentRunner();
        expRunner.clearFailureScenarios(this.experimentProvider);
        LOGGER.info((Object)"Cleared failurescenarios model.");
    }
}

