/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.compare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.resource.Resource;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.simexp.core.util.Pair;
import org.palladiosimulator.simexp.pcm.compare.AttributeChangedFilter;
import org.palladiosimulator.simexp.pcm.compare.ComponentInstantiationChangeFilter;
import org.palladiosimulator.simexp.pcm.compare.DiffFilter;
import org.palladiosimulator.simexp.pcm.compare.PCMRandomVariableChangeFilter;
import org.palladiosimulator.simexp.pcm.util.PcmUtil;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class PcmModelComparison {
    private final PCMInstance pcmModel;

    private PcmModelComparison(PCMInstance pcmModel) {
        this.pcmModel = pcmModel;
    }

    public static PcmModelComparison of(PCMInstance pcmModel) {
        return new PcmModelComparison(pcmModel);
    }

    public ComparisonResult compareTo(PCMInstance other) {
        return ComparisonResult.of(this.determineDifferences(other));
    }

    private List<Diff> determineDifferences(PCMInstance other) {
        return new ComparisonPreparer().getResourcesToCompare(other).flatMap(each -> this.compare((Pair<Resource, Resource>)each).getDifferences().stream()).collect(Collectors.toList());
    }

    private Comparison compare(Pair<Resource, Resource> resourcesToCompare) {
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)resourcesToCompare.getFirst(), (Notifier)resourcesToCompare.getSecond(), null);
        return EMFCompare.builder().build().compare((IComparisonScope)scope);
    }

    private class ComparisonPreparer {
        List<Pair<Resource, Resource>> resourcesToCompare = new ArrayList<Pair<Resource, Resource>>();

        private ComparisonPreparer() {
        }

        public Stream<Pair<Resource, Resource>> getResourcesToCompare(PCMInstance other) {
            this.checkConsistency(PcmModelComparison.this.pcmModel, other);
            this.add(PcmModelComparison.this.pcmModel.getAllocation().eResource(), other.getAllocation().eResource());
            this.add(PcmModelComparison.this.pcmModel.getSystem().eResource(), other.getSystem().eResource());
            this.add(PcmModelComparison.this.pcmModel.getResourceEnvironment().eResource(), other.getResourceEnvironment().eResource());
            int i = 0;
            while (i < PcmModelComparison.this.pcmModel.getRepositories().size()) {
                this.add(((Repository)PcmModelComparison.this.pcmModel.getRepositories().get(i)).eResource(), ((Repository)other.getRepositories().get(i)).eResource());
                ++i;
            }
            return this.resourcesToCompare.stream();
        }

        private void checkConsistency(PCMInstance first, PCMInstance second) {
            if (this.isNotConsistent(first, second)) {
                throw new RuntimeException("");
            }
        }

        private boolean isNotConsistent(PCMInstance first, PCMInstance second) {
            Pair pair = new Pair((Object)first, (Object)second);
            return !this.getConditionsToCheck().allMatch(condition -> condition.test(pair));
        }

        private Stream<Predicate<Pair<PCMInstance, PCMInstance>>> getConditionsToCheck() {
            ArrayList<Predicate<Pair>> conditions = new ArrayList<Predicate<Pair>>();
            conditions.add(pair -> this.areEqual(((PCMInstance)pair.getFirst()).getAllocation().getId(), ((PCMInstance)pair.getSecond()).getAllocation().getId()));
            conditions.add(pair -> this.areEqual(((PCMInstance)pair.getFirst()).getResourceEnvironment().getEntityName(), ((PCMInstance)pair.getSecond()).getResourceEnvironment().getEntityName()));
            conditions.add(pair -> this.areEqual(((PCMInstance)pair.getFirst()).getSystem().getId(), ((PCMInstance)pair.getSecond()).getSystem().getId()));
            conditions.add(pair -> this.areEqual(PcmUtil.toIdentifiables(((PCMInstance)pair.getFirst()).getRepositories()), PcmUtil.toIdentifiables(((PCMInstance)pair.getSecond()).getRepositories())));
            return conditions.stream();
        }

        private boolean areEqual(String firstId, String secondId) {
            return firstId.equals(secondId);
        }

        private boolean areEqual(List<String> firstIds, List<String> secondIds) {
            if (firstIds.size() != secondIds.size()) {
                return false;
            }
            int i = 0;
            while (i < firstIds.size()) {
                if (!this.areEqual(firstIds.get(i), secondIds.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private void add(Resource first, Resource second) {
            this.resourcesToCompare.add((Pair<Resource, Resource>)new Pair((Object)first, (Object)second));
        }
    }

    public static class ComparisonResult {
        private final List<Diff> foundDiffs;
        private final List<DiffFilter> diffFilter;

        private ComparisonResult(List<Diff> foundDiffs) {
            this.foundDiffs = foundDiffs;
            this.diffFilter = this.initDiffFilter();
        }

        private List<DiffFilter> initDiffFilter() {
            return Arrays.asList(new AttributeChangedFilter(), new PCMRandomVariableChangeFilter(), new ComponentInstantiationChangeFilter());
        }

        public static ComparisonResult of(List<Diff> foundDiffs) {
            return new ComparisonResult(foundDiffs);
        }

        private List<String> filterRelevantDiffs() {
            this.applyFilter();
            if (this.anyMatches()) {
                return this.getStringRepresentation();
            }
            return Arrays.asList("");
        }

        private List<String> getStringRepresentation() {
            return this.diffFilter.stream().filter(each -> each.anyMatch()).map(each -> each.getResult().get()).collect(Collectors.toList());
        }

        private boolean anyMatches() {
            return this.diffFilter.stream().anyMatch(filter -> filter.anyMatch());
        }

        private void applyFilter() {
            this.diffFilter.forEach(filter -> filter.applyTo(this.foundDiffs));
        }

        public String toString() {
            return this.filterRelevantDiffs().stream().reduce(PcmUtil.stringConcatenation()).orElse("");
        }
    }
}

