/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.util;

import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.commons.emfutils.EMFCopyHelper;
import org.palladiosimulator.experimentautomation.experiments.Experiment;
import org.palladiosimulator.experimentautomation.experiments.ExperimentRepository;
import org.palladiosimulator.experimentautomation.experiments.InitialModel;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.simexp.pcm.util.ExperimentRunner;
import org.palladiosimulator.simexp.pcm.util.IExperimentProvider;
import org.palladiosimulator.simexp.pcm.util.InitialPcmPartitionLoader;
import org.palladiosimulator.simexp.pcm.util.PcmUtil;

public class ExperimentProvider
implements IExperimentProvider {
    private static final Logger LOGGER = Logger.getLogger((String)ExperimentProvider.class.getName());
    private static final int DEFAULT_REPETITIONS = 1;
    private ExperimentRunner currentRunner;
    private final Experiment initialExperiment;
    private final PCMResourceSetPartition initialPartition;

    public ExperimentProvider(Experiment initialExperiment) {
        this.initialExperiment = this.normalizeExperiment(initialExperiment);
        this.initialPartition = InitialPcmPartitionLoader.loadInitialPcmPartition(initialExperiment);
        this.currentRunner = new ExperimentRunner(this.getInitialExperiment());
    }

    @Override
    public void initializeExperimentRunner() {
        this.currentRunner = new ExperimentRunner(this.getInitialExperiment());
    }

    @Override
    public ExperimentRunner getExperimentRunner() {
        return this.currentRunner;
    }

    private Experiment getInitialExperiment() {
        return new ExperimentCopier().makeCopy();
    }

    private Experiment normalizeExperiment(Experiment experiment) {
        experiment.setRepetitions(1);
        return experiment;
    }

    static /* synthetic */ Experiment access$0(ExperimentProvider experimentProvider) {
        return experimentProvider.initialExperiment;
    }

    private class ExperimentCopier {
        private ExperimentCopier() {
        }

        public Experiment makeCopy() {
            Experiment copy = this.retrieveExperiment(this.copyExperimentRepository());
            this.addPcmModels(copy.getInitialModel());
            return copy;
        }

        private Experiment retrieveExperiment(ExperimentRepository experimentRepo) {
            String initialExperimentName = ExperimentProvider.this.initialExperiment.getName();
            EList experiments = experimentRepo.getExperiments();
            Experiment retrievedExperiment = this.findElement((Collection)experiments, exp -> exp.getName().equals(initialExperimentName)).orElseThrow(() -> new RuntimeException(String.format("Failed to retrieve experiment '%s' from experimentRepository ", initialExperimentName)));
            return retrievedExperiment;
        }

        private ExperimentRepository copyExperimentRepository() {
            ResourceSetImpl originalRs = new ResourceSetImpl();
            originalRs.getResources().add((Object)ExperimentProvider.this.initialExperiment.eResource());
            Resource rCopy = new ResourceSetImpl().createResource(URI.createFileURI((String)"/temp"));
            rCopy.getContents().add((Object)((EObject)EMFCopyHelper.deepCopyToEObjectList((ResourceSet)originalRs).get(0)));
            return (ExperimentRepository)rCopy.getContents().get(0);
        }

        private void addPcmModels(InitialModel initCopy) {
            this.addImmutableModels(initCopy);
            this.addMutableModels(initCopy);
        }

        private void addImmutableModels(InitialModel initCopy) {
            Optional.ofNullable(ExperimentProvider.this.initialExperiment.getInitialModel().getEventMiddleWareRepository()).ifPresent(v -> initCopy.setEventMiddleWareRepository(v));
            Optional.ofNullable(ExperimentProvider.this.initialExperiment.getInitialModel().getMiddlewareRepository()).ifPresent(v -> initCopy.setMiddlewareRepository(v));
            Optional.ofNullable(ExperimentProvider.this.initialExperiment.getInitialModel().getReconfigurationRules()).ifPresent(v -> initCopy.setReconfigurationRules(v));
            Optional.ofNullable(ExperimentProvider.this.initialExperiment.getInitialModel().getServiceLevelObjectives()).ifPresent(v -> initCopy.setServiceLevelObjectives(v));
            Optional.ofNullable(ExperimentProvider.this.initialExperiment.getInitialModel().getMonitorRepository()).ifPresent(v -> initCopy.setMonitorRepository(v));
        }

        private void addMutableModels(InitialModel initCopy) {
            PCMResourceSetPartition pcmCopy = PcmUtil.copyPCMPartition((ResourceSetPartition)ExperimentProvider.this.initialPartition);
            initCopy.setAllocation(pcmCopy.getAllocation());
            initCopy.setRepository(this.retrieveRepository(pcmCopy.getRepositories()));
            initCopy.setResourceEnvironment(pcmCopy.getResourceEnvironment());
            initCopy.setSystem(pcmCopy.getSystem());
            if (ExperimentProvider.this.initialExperiment.getToolConfiguration().isEmpty()) {
                this.getUsageModel(pcmCopy).ifPresent(arg_0 -> ((InitialModel)initCopy).setUsageModel(arg_0));
            } else {
                initCopy.setUsageModel(pcmCopy.getUsageModel());
            }
        }

        private Optional<UsageModel> getUsageModel(PCMResourceSetPartition pcmCopy) {
            try {
                return Optional.of(pcmCopy.getUsageModel());
            }
            catch (IndexOutOfBoundsException e) {
                return Optional.empty();
            }
        }

        private Repository retrieveRepository(List<Repository> repositories) {
            return this.findElement(repositories, r -> r.getId().equals(ExperimentProvider.this.initialExperiment.getInitialModel().getRepository().getId())).orElseThrow(() -> new RuntimeException(""));
        }

        private <T> Optional<T> findElement(Collection<T> elements, Predicate<T> criterion) {
            return elements.stream().filter(criterion).findFirst();
        }
    }
}

