/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.simexp.pcm.action.FilteredQVTOModelTransformationLoader;
import org.palladiosimulator.simexp.pcm.action.IQVTOModelTransformationLoader;
import org.palladiosimulator.simexp.pcm.action.IQVTOModelTransformationSearch;
import org.palladiosimulator.simexp.pcm.action.IQVToReconfigurationManager;
import org.palladiosimulator.simexp.pcm.action.IQVToReconfigurationProvider;
import org.palladiosimulator.simexp.pcm.action.QVTOModelTransformationCache;
import org.palladiosimulator.simexp.pcm.action.impl.QVToReconfigurationProvider;
import org.palladiosimulator.simexp.pcm.action.impl.QvtoModelTransformationSearch;
import org.palladiosimulator.simexp.pcm.config.ITransformationConfiguration;
import org.palladiosimulator.simexp.pcm.util.IExperimentProvider;
import org.palladiosimulator.simulizar.core.runconfig.SimuLizarWorkflowConfiguration;
import org.palladiosimulator.simulizar.core.utils.PCMPartitionManager;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;

public class QVToReconfigurationManager
implements IQVToReconfigurationManager {
    private QVTOReconfigurator reconfigurator;
    private final IQVTOModelTransformationLoader qvtoModelTransformationLoader;
    private final QVToReconfigurationProvider qvtoReconfigurationProvider;
    private final List<Resource> additonalModelsToTransform = Lists.newArrayList();

    public QVToReconfigurationManager(String qvtoFilePath, ITransformationConfiguration transformationConfiguration) {
        this.reconfigurator = new QVTOReconfigurator(null, null);
        Set<String> transformationNames = transformationConfiguration.getTransformationNames();
        this.qvtoModelTransformationLoader = new QVTOModelTransformationCache(new FilteredQVTOModelTransformationLoader(qvtoFilePath, transformationNames));
        this.qvtoReconfigurationProvider = new QVToReconfigurationProvider(this, this.qvtoModelTransformationLoader);
    }

    @Override
    public IQVToReconfigurationProvider getQVToReconfigurationProvider() {
        return this.qvtoReconfigurationProvider;
    }

    @Override
    public IQVTOModelTransformationSearch getQVTOModelTransformationSearch() {
        return new QvtoModelTransformationSearch(this.qvtoModelTransformationLoader);
    }

    @Override
    public QVTOReconfigurator getReconfigurator(IExperimentProvider experimentProvider) {
        this.reconfigurator.setPCMPartitionManager(this.getPartitionManager(experimentProvider));
        return this.reconfigurator;
    }

    private PCMPartitionManager getPartitionManager(IExperimentProvider experimentProvider) {
        PCMResourceSetPartition partition = experimentProvider.getExperimentRunner().getWorkingPartition();
        for (Resource each : this.additonalModelsToTransform) {
            partition.getResourceSet().getResources().add((Object)each);
        }
        MDSDBlackboard blackboard = new MDSDBlackboard();
        blackboard.addPartition("org.palladiosimulator.pcmmodels.partition", (Object)partition);
        return new PCMPartitionManager(blackboard, this.createNewConfig(experimentProvider));
    }

    private SimuLizarWorkflowConfiguration createNewConfig(IExperimentProvider experimentProvider) {
        Optional<Object> monitorRepo = Optional.empty();
        List result = experimentProvider.getExperimentRunner().getWorkingPartition().getElement(MonitorRepositoryPackage.eINSTANCE.getMonitorRepository());
        if (!result.isEmpty()) {
            monitorRepo = Optional.of((MonitorRepository)MonitorRepository.class.cast(result.get(0)));
        }
        SimuLizarWorkflowConfiguration config = new SimuLizarWorkflowConfiguration((Map)Maps.newHashMap());
        if (monitorRepo.isPresent()) {
            String monitorRepoFile = ((MonitorRepository)monitorRepo.get()).eResource().getURI().toFileString();
            config.setMonitorRepositoryFile(monitorRepoFile);
        } else {
            config.setMonitorRepositoryFile(null);
        }
        return config;
    }

    @Override
    public void resetReconfigurator() {
        this.reconfigurator = new QVTOReconfigurator(null, null);
    }

    @Override
    public void addModelsToTransform(Resource modelsToTransform) {
        this.additonalModelsToTransform.add(modelsToTransform);
    }
}

