/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.datasource;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.measure.Measure;
import org.palladiosimulator.edp2.datastream.edp2source.Edp2DataTupleDataSource;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange;
import org.palladiosimulator.edp2.models.ExperimentData.RawMeasurements;
import org.palladiosimulator.measurementframework.measureprovider.IMeasureProvider;
import org.palladiosimulator.metricspec.Identifier;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.simexp.core.util.Pair;
import org.palladiosimulator.simexp.pcm.datasource.DataSource;
import org.palladiosimulator.simexp.pcm.datasource.MeasurementSeriesResult;
import org.palladiosimulator.simexp.pcm.datasource.StateMeasurementFilter;
import org.palladiosimulator.simexp.pcm.state.InitialPcmStateCreator;
import org.palladiosimulator.simexp.pcm.state.PcmMeasurementSpecification;

public class EDP2DataSource<A, V>
extends DataSource {
    private final InitialPcmStateCreator<A, V> initialStateCreator;

    public EDP2DataSource(InitialPcmStateCreator<A, V> initialStateCreator) {
        this.initialStateCreator = initialStateCreator;
    }

    @Override
    public MeasurementSeriesResult getSimulatedMeasurements(List<ExperimentRun> experimentRuns) {
        StateMeasurementFilter<A, V> filter = new StateMeasurementFilter<A, V>(this.initialStateCreator);
        Map<PcmMeasurementSpecification, Measurement> filterStateMeasurements = filter.filterStateMeasurements(experimentRuns);
        return this.asDataSeries(filterStateMeasurements);
    }

    private MeasurementSeriesResult asDataSeries(Map<PcmMeasurementSpecification, Measurement> measurements) {
        MeasurementSeriesResult result = new MeasurementSeriesResult();
        for (PcmMeasurementSpecification each : measurements.keySet()) {
            Measurement measure = measurements.get((Object)each);
            MetricDescription desc = each.getMetricDescription();
            List<Pair<MeasurementSeriesResult.PointInTime, MeasurementSeriesResult.MeasurementValue>> measurementSeries = this.getMeasurementSeries(measure, desc);
            result.addMeasurementSeries(each, measurementSeries);
        }
        return result;
    }

    private List<Pair<MeasurementSeriesResult.PointInTime, MeasurementSeriesResult.MeasurementValue>> getMeasurementSeries(Measurement measurement, MetricDescription metricDesc) {
        ArrayList<Pair<MeasurementSeriesResult.PointInTime, MeasurementSeriesResult.MeasurementValue>> measurementSeries = new ArrayList<Pair<MeasurementSeriesResult.PointInTime, MeasurementSeriesResult.MeasurementValue>>();
        Iterator<IMeasureProvider> iterator = this.getIterator(measurement);
        while (iterator.hasNext()) {
            Number number;
            Pair measurementValuePair;
            IMeasureProvider provider = iterator.next();
            Measure stateQuantity = provider.getMeasureForMetric(metricDesc);
            Measure timeInstant = provider.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
            Double timeInstantValue = (Double)timeInstant.getValue();
            MeasurementSeriesResult.PointInTime pointInTime = new MeasurementSeriesResult.PointInTime(timeInstantValue);
            Object stateQuantityValue = stateQuantity.getValue();
            if (stateQuantityValue instanceof Identifier) {
                Identifier stateQuantityValueAsIdentifier = (Identifier)stateQuantityValue;
                String stateQuantityAsStringValue = stateQuantityValueAsIdentifier.getLiteral();
                MeasurementSeriesResult.StringMeasurementValue measurementValueAsString = new MeasurementSeriesResult.StringMeasurementValue(stateQuantityAsStringValue);
                measurementValuePair = Pair.of((Object)pointInTime, (Object)measurementValueAsString);
                measurementSeries.add((Pair<MeasurementSeriesResult.PointInTime, MeasurementSeriesResult.MeasurementValue>)measurementValuePair);
            }
            if (!(stateQuantityValue instanceof Number) || !((number = (Number)stateQuantityValue) instanceof Double)) continue;
            Double stateQuantityAsDoubleValue = (Double)stateQuantityValue;
            MeasurementSeriesResult.NumberMeasurementValue<Double> measurementValueAsDouble = new MeasurementSeriesResult.NumberMeasurementValue<Double>(stateQuantityAsDoubleValue, Double.class);
            measurementValuePair = Pair.of((Object)pointInTime, measurementValueAsDouble);
            measurementSeries.add((Pair<MeasurementSeriesResult.PointInTime, MeasurementSeriesResult.MeasurementValue>)measurementValuePair);
        }
        return measurementSeries;
    }

    private Iterator<IMeasureProvider> getIterator(Measurement measurement) {
        RawMeasurements rawMeasurements = ((MeasurementRange)measurement.getMeasurementRanges().get(0)).getRawMeasurements();
        Edp2DataTupleDataSource dataSource = new Edp2DataTupleDataSource(rawMeasurements);
        return dataSource.getDataStream().iterator();
    }
}

