/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.datasource;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.palladiosimulator.simexp.core.util.Pair;
import org.palladiosimulator.simexp.pcm.state.PcmMeasurementSpecification;

public class MeasurementSeriesResult {
    private final Map<PcmMeasurementSpecification, MeasurementSeries> results = new HashMap<PcmMeasurementSpecification, MeasurementSeries>();

    public void addMeasurementSeries(PcmMeasurementSpecification spec, List<Pair<PointInTime, MeasurementValue>> measurements) {
        this.results.put(spec, new MeasurementSeries(measurements));
    }

    public Optional<MeasurementSeries> getMeasurementsSeries(PcmMeasurementSpecification spec) {
        return Optional.ofNullable(this.results.get((Object)spec));
    }

    public static class MeasurementSeries {
        private final List<Pair<PointInTime, MeasurementValue>> measurements;

        public MeasurementSeries(List<Pair<PointInTime, MeasurementValue>> measurements) {
            this.measurements = measurements;
        }

        public Stream<Pair<PointInTime, MeasurementValue>> asStream() {
            return this.measurements.stream();
        }

        public List<Pair<PointInTime, MeasurementValue>> asList() {
            return this.measurements;
        }

        public Stream<MeasurementValue> asStreamOfValues() {
            return this.asListOfValues().stream();
        }

        public List<MeasurementValue> asListOfValues() {
            return this.measurements.stream().map(each -> (MeasurementValue)each.getSecond()).collect(Collectors.toList());
        }
    }

    public static abstract class MeasurementValue {
        public abstract Object getValue();
    }

    public static class NumberMeasurementValue<T extends Number>
    extends MeasurementValue {
        private final T value;
        private final Class<T> valueClazz;

        public NumberMeasurementValue(T value, Class<T> clazz) {
            this.value = value;
            this.valueClazz = clazz;
        }

        public T getValue() {
            return this.value;
        }

        public Class<T> getValueClazz() {
            return this.valueClazz;
        }
    }

    public static class PointInTime {
        private final double pointInTime;

        public PointInTime(double pointInTime) {
            this.pointInTime = pointInTime;
        }

        public double getPointInTime() {
            return this.pointInTime;
        }
    }

    public static class StringMeasurementValue
    extends MeasurementValue {
        private final String value;

        public StringMeasurementValue(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

