/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.perceiption;

import java.util.Optional;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivedElement;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivedValue;
import org.palladiosimulator.simexp.pcm.perceiption.PcmModelChange;
import org.palladiosimulator.simexp.pcm.perceiption.PerceivedValueConverter;
import org.palladiosimulator.simexp.pcm.util.ExperimentRunner;
import org.palladiosimulator.simexp.pcm.util.IExperimentProvider;
import tools.mdsd.probdist.api.entity.CategoricalValue;

public class PcmAttributeChange<V>
implements PcmModelChange<V> {
    private final Function<ExperimentRunner, EObject> retrieveTargetHandler;
    private final String attributeName;
    private final IExperimentProvider experimentProvider;
    private final PerceivedValueConverter<V> perceivedValueConverter;

    public PcmAttributeChange(Function<ExperimentRunner, EObject> retrieveTargetHandler, String attributeName, IExperimentProvider experimentProvider, PerceivedValueConverter<V> perceivedValueConverter) {
        this.retrieveTargetHandler = retrieveTargetHandler;
        this.attributeName = attributeName;
        this.experimentProvider = experimentProvider;
        this.perceivedValueConverter = perceivedValueConverter;
    }

    @Override
    public void apply(PerceivedValue<V> change) {
        PerceivedElement pe = (PerceivedElement)change;
        Optional newValue = pe.getElement(this.attributeName);
        if (newValue.isPresent()) {
            CategoricalValue changedValue = this.perceivedValueConverter.convertElement(change, this.attributeName);
            this.applyChange(this.retrieveTarget(this.experimentProvider), changedValue);
        }
    }

    private EObject retrieveTarget(IExperimentProvider experimentProvider) {
        return this.retrieveTargetHandler.apply(experimentProvider.getExperimentRunner());
    }

    private void applyChange(EObject target, Object newValue) {
        EStructuralFeature feature = target.eClass().getEStructuralFeature(this.attributeName);
        target.eSet(feature, (Object)newValue.toString());
    }
}

