/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.state;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurementSpecification;
import org.palladiosimulator.simexp.core.statistics.StatisticalQuantities;
import org.palladiosimulator.simexp.core.util.Threshold;
import org.palladiosimulator.simexp.pcm.datasource.MeasurementSeriesResult;

public class PcmMeasurementSpecification
extends SimulatedMeasurementSpecification {
    private final MeasuringPoint measuringPoint;
    private final MetricDescription metricDescription;
    private final MeasurementAggregator aggregator;
    private final Optional<Threshold> steadyStateEvaluator;

    private PcmMeasurementSpecification(String id, String name, MeasuringPoint measuringPoint, MetricDescription metricDescription, MeasurementAggregator aggregator, Optional<Threshold> steadyStateEvaluator) {
        super(id, name);
        this.measuringPoint = measuringPoint;
        this.metricDescription = metricDescription;
        this.aggregator = aggregator;
        this.steadyStateEvaluator = steadyStateEvaluator;
    }

    public static PcmMeasurementSpecBuilder newBuilder() {
        return new PcmMeasurementSpecBuilder();
    }

    public boolean hasMeasuringPoint(MeasuringPoint measuringPoint) {
        return this.measuringPoint.getStringRepresentation().equals(measuringPoint.getStringRepresentation());
    }

    public boolean hasMetricDescription(MetricDescription metricDescription) {
        return this.metricDescription.getId().equals(metricDescription.getId());
    }

    public MeasuringPoint getMeasuringPoint() {
        return this.measuringPoint;
    }

    public MetricDescription getMetricDescription() {
        return this.metricDescription;
    }

    public Optional<Threshold> getSteadyStateEvaluator() {
        return this.steadyStateEvaluator;
    }

    public double computeQuantity(MeasurementSeriesResult.MeasurementSeries measurements) {
        return this.aggregator.aggregate(measurements);
    }

    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof PcmMeasurementSpecification)) {
            return false;
        }
        PcmMeasurementSpecification pcmSpec = (PcmMeasurementSpecification)((Object)other);
        return this.hasMeasuringPoint(pcmSpec.getMeasuringPoint()) && this.hasMetricDescription(pcmSpec.getMetricDescription());
    }

    public String toString() {
        return PcmMeasurementSpecification.deriveUniqueId(this.measuringPoint, this.metricDescription);
    }

    private static String deriveUniqueId(MeasuringPoint measuringPoint, MetricDescription desc) {
        return String.format("%1s_%2s", measuringPoint.getStringRepresentation(), desc.getName());
    }

    private static final class DefaultMeasurementAggregator
    implements MeasurementAggregator {
        private static final Logger LOGGER = Logger.getLogger((String)DefaultMeasurementAggregator.class.getName());

        private DefaultMeasurementAggregator() {
        }

        @Override
        public double aggregate(MeasurementSeriesResult.MeasurementSeries measurements) {
            List<MeasurementSeriesResult.MeasurementValue> measurementsValues = measurements.asListOfValues();
            ArrayList<Number> measurementsAsNumbers = new ArrayList<Number>();
            for (MeasurementSeriesResult.MeasurementValue measurementValue : measurementsValues) {
                Object value = measurementValue.getValue();
                if (!(value instanceof Number)) continue;
                measurementsAsNumbers.add((Number)value);
            }
            if (measurementsAsNumbers.isEmpty()) {
                LOGGER.error((Object)"No measurements available from simulation.");
                return Double.NaN;
            }
            double aggregatedMeasurements = StatisticalQuantities.withNumbers(measurementsAsNumbers).mean();
            LOGGER.info((Object)String.format("Aggregated measurements = %s", aggregatedMeasurements));
            return aggregatedMeasurements;
        }
    }

    public static interface MeasurementAggregator {
        public static MeasurementAggregator getDefault() {
            return new DefaultMeasurementAggregator();
        }

        public double aggregate(MeasurementSeriesResult.MeasurementSeries var1);
    }

    public static class PcmMeasurementSpecBuilder {
        private String name = null;
        private MeasuringPoint measuringPoint = null;
        private MetricDescription metricDescription = null;
        private MeasurementAggregator aggregator = null;
        private Optional<Threshold> steadyStateEvaluator = Optional.empty();

        public PcmMeasurementSpecBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public PcmMeasurementSpecBuilder measuredAt(MeasuringPoint measPoint) {
            this.measuringPoint = measPoint;
            return this;
        }

        public PcmMeasurementSpecBuilder withMetric(MetricDescription metricDesc) {
            this.metricDescription = metricDesc;
            return this;
        }

        public PcmMeasurementSpecBuilder useDefaultMeasurementAggregation() {
            this.aggregator = MeasurementAggregator.getDefault();
            return this;
        }

        public PcmMeasurementSpecBuilder aggregateMeasurementsBy(MeasurementAggregator aggregator) {
            this.aggregator = aggregator;
            return this;
        }

        public PcmMeasurementSpecBuilder withOptionalSteadyStateEvaluator(Threshold evaluator) {
            this.steadyStateEvaluator = Optional.of(evaluator);
            return this;
        }

        public PcmMeasurementSpecification build() {
            Objects.requireNonNull(this.name, "");
            Objects.requireNonNull(this.measuringPoint, "");
            Objects.requireNonNull(this.metricDescription, "");
            Objects.requireNonNull(this.aggregator, "");
            return new PcmMeasurementSpecification(PcmMeasurementSpecification.deriveUniqueId(this.measuringPoint, this.metricDescription), this.name, this.measuringPoint, this.metricDescription, this.aggregator, this.steadyStateEvaluator);
        }
    }
}

