/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.state;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurement;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurementSpecification;
import org.palladiosimulator.simexp.core.state.ArchitecturalConfiguration;
import org.palladiosimulator.simexp.core.state.SelfAdaptiveSystemState;
import org.palladiosimulator.simexp.core.state.SimulationRunnerHolder;
import org.palladiosimulator.simexp.core.state.StateQuantity;
import org.palladiosimulator.simexp.core.util.Threshold;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivableEnvironmentalState;
import org.palladiosimulator.simexp.pcm.perceiption.PcmModelChange;
import org.palladiosimulator.simexp.pcm.state.InitialPcmStateCreator;
import org.palladiosimulator.simexp.pcm.state.PcmArchitecturalConfiguration;
import org.palladiosimulator.simexp.pcm.state.PcmMeasurementSpecification;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class PcmSelfAdaptiveSystemState<A, V>
extends SelfAdaptiveSystemState<PCMInstance, A, V> {
    private final InitialPcmStateCreator<A, V> initialPcmStateCreator;

    private PcmSelfAdaptiveSystemState(SimulationRunnerHolder simulationRunnerHolder, PcmArchitecturalConfiguration<A> archConf, PerceivableEnvironmentalState<V> perceivedState, Set<SimulatedMeasurementSpecification> specs, boolean isInitial, InitialPcmStateCreator<A, V> initialPcmStateCreator) {
        super(simulationRunnerHolder);
        this.quantifiedState = StateQuantity.of(this.toMeasuredQuantities(specs));
        this.archConfiguration = archConf;
        this.perceivedState = perceivedState;
        this.initialPcmStateCreator = initialPcmStateCreator;
        this.applyChanges(perceivedState);
        if (isInitial) {
            this.determineQuantifiedState();
        }
    }

    public static <A, V> PcmSassBuilder<A, V> newBuilder(InitialPcmStateCreator<A, V> initialPcmStateCreator, SimulationRunnerHolder simulationRunnerHolder) {
        return new PcmSassBuilder<A, V>(initialPcmStateCreator, simulationRunnerHolder);
    }

    private List<SimulatedMeasurement> toMeasuredQuantities(Set<SimulatedMeasurementSpecification> specs) {
        return specs.stream().map(each -> SimulatedMeasurement.with((SimulatedMeasurementSpecification)each)).collect(Collectors.toList());
    }

    public boolean isSteadyState() {
        for (SimulatedMeasurement each : this.quantifiedState.getMeasurements()) {
            Optional<Threshold> evaluator = ((PcmMeasurementSpecification)each.getSpecification()).getSteadyStateEvaluator();
            if (!evaluator.isPresent() || !evaluator.get().isNotSatisfied(each.getValue())) continue;
            return false;
        }
        return true;
    }

    public SelfAdaptiveSystemState<PCMInstance, A, V> transitToNext(PerceivableEnvironmentalState<V> perceivedState, ArchitecturalConfiguration<PCMInstance, A> archConf) {
        PcmSassBuilder<A, V> builder = PcmSelfAdaptiveSystemState.newBuilder(this.initialPcmStateCreator, this.simulationRunnerHolder);
        return builder.withStructuralState((PcmArchitecturalConfiguration)archConf, perceivedState).andMetricDescriptions(this.initialPcmStateCreator.getMeasurementSpecs()).build();
    }

    private void applyChanges(PerceivableEnvironmentalState<V> perceivedState) {
        if (perceivedState instanceof PcmModelChange) {
            ((PcmModelChange)perceivedState).apply(perceivedState.getValue());
        }
    }

    public static class PcmSassBuilder<A, V> {
        private final InitialPcmStateCreator<A, V> initialPcmStateCreator;
        private final SimulationRunnerHolder simulationRunnerHolder;
        private Set<SimulatedMeasurementSpecification> specs = new LinkedHashSet<SimulatedMeasurementSpecification>();
        private PcmArchitecturalConfiguration<A> initialArch = null;
        private PerceivableEnvironmentalState<V> initialEnv = null;
        private boolean isInitial = false;

        public PcmSassBuilder(InitialPcmStateCreator<A, V> initialPcmStateCreator, SimulationRunnerHolder simulationRunnerHolder) {
            this.initialPcmStateCreator = initialPcmStateCreator;
            this.simulationRunnerHolder = simulationRunnerHolder;
        }

        public PcmSassBuilder<A, V> withStructuralState(PcmArchitecturalConfiguration<A> initialArch, PerceivableEnvironmentalState<V> initialEnv) {
            this.initialArch = initialArch;
            this.initialEnv = initialEnv;
            return this;
        }

        public PcmSassBuilder<A, V> andMetricDescriptions(Set<SimulatedMeasurementSpecification> specs) {
            this.specs.addAll(specs);
            return this;
        }

        public PcmSassBuilder<A, V> asInitial() {
            this.isInitial = true;
            return this;
        }

        public PcmSelfAdaptiveSystemState<A, V> build() {
            Objects.requireNonNull(this.initialArch, "");
            Objects.requireNonNull(this.initialEnv, "");
            if (this.specs.isEmpty()) {
                throw new RuntimeException("");
            }
            return new PcmSelfAdaptiveSystemState<A, V>(this.simulationRunnerHolder, this.initialArch, this.initialEnv, this.specs, this.isInitial, this.initialPcmStateCreator);
        }
    }
}

