/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.util;

import com.google.common.collect.Lists;
import de.uka.ipd.sdq.workflow.BlackboardBasedWorkflow;
import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.SequentialJob;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.edp2.impl.RepositoryManager;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroup;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentSetting;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.experimentautomation.abstractsimulation.AbstractSimulationConfiguration;
import org.palladiosimulator.experimentautomation.application.jobs.CopyPartitionJob;
import org.palladiosimulator.experimentautomation.application.jobs.RunExperimentForEachToolJob;
import org.palladiosimulator.experimentautomation.application.tooladapter.abstractsimulation.AbstractSimulationConfigFactory;
import org.palladiosimulator.experimentautomation.experiments.Experiment;
import org.palladiosimulator.experimentautomation.experiments.ToolConfiguration;
import org.palladiosimulator.failuremodel.failurescenario.FailureScenarioRepository;
import org.palladiosimulator.failuremodel.failurescenario.FailurescenarioPackage;
import org.palladiosimulator.failuremodel.failuretype.FailureTypeRepository;
import org.palladiosimulator.simexp.pcm.util.CopyUriPreservingPartitionJob;
import org.palladiosimulator.simexp.pcm.util.IExperimentProvider;
import org.palladiosimulator.simexp.pcm.util.InitialPcmPartitionLoader;
import org.palladiosimulator.simexp.pcm.util.PcmUtil;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class ExperimentRunner {
    private static final Logger LOGGER = Logger.getLogger(ExperimentRunner.class);
    private static final String FAILURE_SCENARIO_MODEL_URI = "http://palladiosimulator.org/failurescenario/1.0";
    private static final String FAILURE_TYPE_MODEL_URI = "http://palladiosimulator.org/failuretype/1.0";
    private final Experiment experiment;
    private final SimulationContext simulationContext;
    private final ExperimentRunExtractor expRunExtractor;

    public ExperimentRunner(Experiment initial) {
        this.experiment = initial;
        this.simulationContext = new SimulationContext();
        this.expRunExtractor = new ExperimentRunExtractor();
    }

    public void runExperiment() {
        this.simulationContext.runSimulation();
    }

    public List<ExperimentRun> getCurrentExperimentRuns() {
        return this.expRunExtractor.extractCurrentExperimentRuns();
    }

    public PCMInstance makeSnapshotOfPCM() {
        return new PCMInstance(this.copyPCMPartition());
    }

    private PCMResourceSetPartition copyPCMPartition() {
        return PcmUtil.copyPCMPartition((ResourceSetPartition)this.getWorkingPartition());
    }

    public PCMResourceSetPartition getWorkingPartition() {
        return (PCMResourceSetPartition)this.simulationContext.getBlackboard().getPartition("org.palladiosimulator.simexp.pcm.workingpartition");
    }

    public ResourceSetPartition getPlainWorkingPartition() {
        return (ResourceSetPartition)this.simulationContext.getBlackboard().getPartition("org.palladiosimulator.simexp.pcm.workingpartition");
    }

    public void injectFailureScenario(FailureScenarioRepository failureScenarioRepo, FailureTypeRepository failureTypeRepo) throws IOException {
        this.simulationContext.injectFailureScenario(failureScenarioRepo, failureTypeRepo);
    }

    public void updateFailureScenario(FailureScenarioRepository failureScenarioRepo) throws IOException {
        this.simulationContext.updateFailureScenario(failureScenarioRepo);
    }

    public void clearFailureScenarios(IExperimentProvider experimentProvider) {
        this.simulationContext.clearFailureScenarios(experimentProvider);
    }

    private class ExperimentRunExtractor {
        private final List<ToolContext> toolContexts = Lists.newArrayList();

        private ExperimentRunExtractor() {
        }

        private void cacheToolContext(ToolContext context) {
            this.toolContexts.add(context);
        }

        private ToolContext getOrCreateToolContext(AbstractSimulationConfiguration toolConfig) {
            Optional<ToolContext> result = this.findToolContext(toolConfig);
            if (result.isPresent()) {
                return result.get();
            }
            ToolContext context = new ToolContext(toolConfig, this.reproduceConfigMap((ToolConfiguration)toolConfig));
            this.cacheToolContext(context);
            return context;
        }

        private Optional<ToolContext> findToolContext(AbstractSimulationConfiguration toolConfig) {
            return this.toolContexts.stream().filter(c -> c.toolConfig.getName().equals(toolConfig.getName())).findFirst();
        }

        private Map<String, Object> reproduceConfigMap(ToolConfiguration toolConfig) {
            return AbstractSimulationConfigFactory.createConfigMap((Experiment)ExperimentRunner.this.experiment, (AbstractSimulationConfiguration)((AbstractSimulationConfiguration)toolConfig), (String)"", new ArrayList());
        }

        public List<ExperimentRun> extractCurrentExperimentRuns() {
            ArrayList runs = Lists.newArrayList();
            for (AbstractSimulationConfiguration each : this.filterSimulationConfigs()) {
                ExperimentGroup group = this.findExperimentGroup(each);
                ExperimentSetting setting = this.findExperimentSetting(group, this.getVariationId(each));
                ExperimentRun run = this.getCurrentRunFrom(setting);
                runs.add(run);
            }
            return runs;
        }

        private ExperimentRun getCurrentRunFrom(ExperimentSetting setting) {
            int last = setting.getExperimentRuns().size() - 1;
            return (ExperimentRun)setting.getExperimentRuns().get(last);
        }

        private List<AbstractSimulationConfiguration> filterSimulationConfigs() {
            return ExperimentRunner.this.experiment.getToolConfiguration().stream().filter(AbstractSimulationConfiguration.class::isInstance).map(AbstractSimulationConfiguration.class::cast).collect(Collectors.toList());
        }

        private ExperimentGroup findExperimentGroup(AbstractSimulationConfiguration toolConfig) {
            Repository repository = RepositoryManager.getRepositoryFromUUID((String)toolConfig.getDatasource().getId());
            for (ExperimentGroup experimentGroup : repository.getExperimentGroups()) {
                String purpose = this.getExperimentRunId(toolConfig);
                if (!experimentGroup.getPurpose().equals(purpose)) continue;
                return experimentGroup;
            }
            throw new IllegalArgumentException("Could not find experiment group.");
        }

        private ExperimentSetting findExperimentSetting(ExperimentGroup expGroup, String expSettingDesc) {
            for (ExperimentSetting expSetting : expGroup.getExperimentSettings()) {
                if (!expSetting.getDescription().equals(expSettingDesc)) continue;
                return expSetting;
            }
            throw new IllegalArgumentException("Could not find experiment setting for variation.");
        }

        private String getExperimentRunId(AbstractSimulationConfiguration toolConfig) {
            return this.getOrCreateToolContext(toolConfig).getExperimentRunId();
        }

        private String getVariationId(AbstractSimulationConfiguration toolConfig) {
            return this.getOrCreateToolContext(toolConfig).getVariationId();
        }

        private class ToolContext {
            public AbstractSimulationConfiguration toolConfig;
            public Map<String, Object> configMap;

            public ToolContext(AbstractSimulationConfiguration toolConfig, Map<String, Object> configMap) {
                this.toolConfig = toolConfig;
                this.configMap = configMap;
            }

            public String getExperimentRunId() {
                return (String)this.configMap.get("experimentRun");
            }

            public String getVariationId() {
                return (String)this.configMap.get("variationId");
            }
        }
    }

    private class SimulationContext {
        private final MDSDBlackboard blackboard;

        public SimulationContext() {
            this.blackboard = InitialPcmPartitionLoader.loadInitialBlackboard(ExperimentRunner.this.experiment);
        }

        public BlackboardBasedWorkflow<MDSDBlackboard> initWorkflow(Experiment experiment) {
            SequentialJob simulationJob = new SequentialJob();
            simulationJob.add((IJob)new CopyUriPreservingPartitionJob("org.palladiosimulator.simexp.pcm.workingpartition", "org.palladiosimulator.pcmmodels.partition"));
            simulationJob.add((IJob)new CopyPartitionJob("org.palladiosimulator.simexp.pcm.workingpartition", "org.palladiosimulator.analyzed.partition"));
            simulationJob.add((IJob)new RunExperimentForEachToolJob(experiment));
            simulationJob.forEach(job -> ((IBlackboardInteractingJob)job).setBlackboard((Blackboard)this.blackboard));
            return new BlackboardBasedWorkflow((IJob)simulationJob, (Blackboard)this.blackboard);
        }

        public void runSimulation() {
            this.initWorkflow(ExperimentRunner.this.experiment).run();
        }

        public MDSDBlackboard getBlackboard() {
            return this.blackboard;
        }

        public void injectFailureScenario(FailureScenarioRepository failureScenarioRepo, FailureTypeRepository failureTypeRepo) throws IOException {
            ResourceSetPartition partition = (ResourceSetPartition)ExperimentRunner.this.simulationContext.blackboard.getPartition("org.palladiosimulator.simexp.pcm.workingpartition");
            URI modelURIFailureTypes = URI.createURI((String)ExperimentRunner.FAILURE_TYPE_MODEL_URI);
            URI modelURIFailureScenario = URI.createURI((String)ExperimentRunner.FAILURE_SCENARIO_MODEL_URI);
            ResourceSet resourceSet = partition.getResourceSet();
            this.addResourceToPartition(resourceSet, modelURIFailureTypes, (EObject)failureTypeRepo);
            this.addResourceToPartition(resourceSet, modelURIFailureScenario, (EObject)failureScenarioRepo);
        }

        public void updateFailureScenario(FailureScenarioRepository failureScenarioRepo) throws IOException {
            ResourceSetPartition partition = (ResourceSetPartition)ExperimentRunner.this.simulationContext.blackboard.getPartition("org.palladiosimulator.simexp.pcm.workingpartition");
            URI modelURIFailureScenario = URI.createURI((String)ExperimentRunner.FAILURE_SCENARIO_MODEL_URI);
            ResourceSet resourceSet = partition.getResourceSet();
            this.addResourceToPartition(resourceSet, modelURIFailureScenario, (EObject)failureScenarioRepo);
        }

        private void addResourceToPartition(ResourceSet resourceSet, URI modelURI, EObject modelRoot) {
            Resource resource = resourceSet.getResource(modelURI, false);
            if (resource != null) {
                resourceSet.getResources().remove((Object)resource);
            }
            try {
                Resource initalResource = this.create(resourceSet, modelURI, modelRoot);
                this.addResource(resourceSet, initalResource);
            }
            catch (IOException e) {
                LOGGER.error((Object)String.format("Failed to add model %s to resource set", modelURI), (Throwable)e);
            }
        }

        private void printResourceToFileSystem(Resource resource) throws FileNotFoundException, IOException {
            Path pathBaseDir = FileSystems.getDefault().getPath("C:\\tmp\\SIMEXP\\", new String[0]);
            URI oldUri = resource.getURI();
            try {
                try {
                    URI tmpUri = URI.createFileURI((String)(String.valueOf(pathBaseDir.toString()) + "\\" + oldUri.segment(0) + "_" + Long.toString(System.nanoTime())));
                    resource.setURI(tmpUri);
                    HashMap options = new HashMap();
                    resource.save(options);
                }
                catch (IOException e) {
                    LOGGER.error((Object)String.format("Failed to persist resource URI %s to filesytem", "bla"), (Throwable)e);
                    resource.setURI(oldUri);
                }
            }
            finally {
                resource.setURI(oldUri);
            }
        }

        private Resource create(ResourceSet resourceSet, URI modelURI, EObject modelRoot) throws IOException {
            Resource newResource = resourceSet.createResource(modelURI);
            newResource.getContents().clear();
            newResource.getContents().add((Object)modelRoot);
            resourceSet.getResources().add((Object)newResource);
            return newResource;
        }

        private void addResource(ResourceSet resourceSet, Resource newResource) {
            resourceSet.getResources().add((Object)newResource);
        }

        public void clearFailureScenarios(IExperimentProvider experimentProvider) {
            ResourceSetPartition plainPartition = experimentProvider.getExperimentRunner().getPlainWorkingPartition();
            URI modelURIFailureScenario = URI.createURI((String)ExperimentRunner.FAILURE_SCENARIO_MODEL_URI);
            FailureScenarioRepository failureScenarioRepo = (FailureScenarioRepository)plainPartition.getElement(FailurescenarioPackage.eINSTANCE.getFailureScenarioRepository()).get(0);
            failureScenarioRepo.getFailurescenarios().clear();
            LOGGER.info((Object)String.format("Cleared FailureScenario model at URI '%s'", modelURIFailureScenario));
        }
    }
}

