/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.datasource;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurementSpecification;
import org.palladiosimulator.simexp.pcm.datasource.MetricComparer;
import org.palladiosimulator.simexp.pcm.state.InitialPcmStateCreator;
import org.palladiosimulator.simexp.pcm.state.PcmMeasurementSpecification;

public class StateMeasurementFilter<A, V> {
    private final InitialPcmStateCreator<A, V> initialStateCreator;

    public StateMeasurementFilter(InitialPcmStateCreator<A, V> initialStateCreator) {
        this.initialStateCreator = initialStateCreator;
    }

    public Map<PcmMeasurementSpecification, Measurement> filterStateMeasurements(List<ExperimentRun> experimentRuns) {
        Set<SimulatedMeasurementSpecification> initialMeasurementSpecs = this.initialStateCreator.getMeasurementSpecs();
        return this.filterStateMeasurements(experimentRuns, initialMeasurementSpecs);
    }

    private Map<PcmMeasurementSpecification, Measurement> filterStateMeasurements(List<ExperimentRun> experimentRuns, Set<SimulatedMeasurementSpecification> initialMeasurementSpecs) {
        HashMap measurments = Maps.newHashMap();
        for (ExperimentRun each : experimentRuns) {
            Map<PcmMeasurementSpecification, Measurement> stateMeasurments = this.filterStateMeasurements(each, initialMeasurementSpecs);
            if (stateMeasurments.isEmpty()) {
                throw new RuntimeException("");
            }
            measurments.putAll(stateMeasurments);
        }
        return measurments;
    }

    private Map<PcmMeasurementSpecification, Measurement> filterStateMeasurements(ExperimentRun experimentRun, Set<SimulatedMeasurementSpecification> initialMeasurementSpecs) {
        HashMap<PcmMeasurementSpecification, Measurement> specToMeas = new HashMap<PcmMeasurementSpecification, Measurement>();
        MetricComparer metricComparer = new MetricComparer();
        EList measurements = experimentRun.getMeasurement();
        for (Measurement each : measurements) {
            List<PcmMeasurementSpecification> specifications = this.findSpecifications(each, initialMeasurementSpecs);
            for (PcmMeasurementSpecification pcmSpec : specifications) {
                if (!metricComparer.sameMetric(each, pcmSpec)) continue;
                specToMeas.put(pcmSpec, each);
            }
        }
        return specToMeas;
    }

    private List<PcmMeasurementSpecification> findSpecifications(Measurement measurement, Set<SimulatedMeasurementSpecification> initialMeasurementSpecs) {
        MeasuringPoint measuringPoint = measurement.getMeasuringType().getMeasuringPoint();
        Set<PcmMeasurementSpecification> measurementSpecs = this.getMeasurementSpecs(initialMeasurementSpecs);
        return measurementSpecs.stream().filter(spec -> spec.hasMeasuringPoint(measuringPoint)).collect(Collectors.toList());
    }

    private Set<PcmMeasurementSpecification> getMeasurementSpecs(Set<SimulatedMeasurementSpecification> measurementSpecs) {
        return measurementSpecs.stream().filter(PcmMeasurementSpecification.class::isInstance).map(PcmMeasurementSpecification.class::cast).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

