/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.state;

import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.scheduler.resources.active.ResourceTableManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.palladiosimulator.simexp.core.action.Reconfiguration;
import org.palladiosimulator.simexp.core.state.ArchitecturalConfiguration;
import org.palladiosimulator.simexp.pcm.compare.PcmModelComparison;
import org.palladiosimulator.simexp.pcm.state.IPCMReconfigurationExecutor;
import org.palladiosimulator.simexp.pcm.util.IExperimentProvider;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class PcmArchitecturalConfiguration<A>
extends ArchitecturalConfiguration<PCMInstance, A> {
    private static final Logger LOGGER = Logger.getLogger((String)PcmArchitecturalConfiguration.class.getName());
    private final IExperimentProvider experimentProvider;

    private PcmArchitecturalConfiguration(PCMInstance configuration, IExperimentProvider experimentProvider) {
        super((Object)configuration);
        this.experimentProvider = experimentProvider;
    }

    public static <A> PcmArchitecturalConfiguration<A> of(PCMInstance configuration, IExperimentProvider experimentProvider) {
        return new PcmArchitecturalConfiguration<A>(configuration, experimentProvider);
    }

    public String getStringRepresentation() {
        return Integer.toString(this.deriveUniqueID());
    }

    private Integer deriveUniqueID() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ((PCMInstance)this.getConfiguration()).getRepositories().forEach(r -> this.appendSerializationString(r.eResource(), output));
        this.appendSerializationString(((PCMInstance)this.getConfiguration()).getSystem().eResource(), output);
        this.appendSerializationString(((PCMInstance)this.getConfiguration()).getAllocation().eResource(), output);
        return ((Object)output).toString().hashCode();
    }

    private void appendSerializationString(Resource resource, OutputStream output) {
        try {
            resource.save(output, Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String difference(ArchitecturalConfiguration<PCMInstance, A> other) {
        if (this.isNotValid(other)) {
            return "";
        }
        return this.difference((PcmArchitecturalConfiguration)other);
    }

    private boolean isNotValid(ArchitecturalConfiguration<PCMInstance, A> other) {
        return other == null || !(other instanceof PcmArchitecturalConfiguration);
    }

    public ArchitecturalConfiguration<PCMInstance, A> apply(Reconfiguration<A> reconf) {
        if (!(reconf instanceof IPCMReconfigurationExecutor)) {
            throw new RuntimeException("'EXECUTE' failed to apply reconfiguration: Found invalid reconfiguration; expected an instance of IPCMReconfigurationExecutor");
        }
        IPCMReconfigurationExecutor qvtoReconf = (IPCMReconfigurationExecutor)reconf;
        qvtoReconf.execute(this.experimentProvider, (IResourceTableManager)new ResourceTableManager());
        LOGGER.info((Object)"'EXECUTE' step done");
        PcmArchitecturalConfiguration<A> updatedArchitecturalConfiguration = new PcmArchitecturalConfiguration<A>(this.makeSnapshot(this.experimentProvider), this.experimentProvider);
        return updatedArchitecturalConfiguration;
    }

    private PCMInstance makeSnapshot(IExperimentProvider experimentProvider) {
        return experimentProvider.getExperimentRunner().makeSnapshotOfPCM();
    }

    private String difference(PcmArchitecturalConfiguration<A> other) {
        PCMInstance first = (PCMInstance)this.getConfiguration();
        PCMInstance second = (PCMInstance)other.getConfiguration();
        return PcmModelComparison.of(first).compareTo(second).toString();
    }
}

