/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.util;

import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.experimentautomation.application.jobs.CopyPartitionJob;
import org.palladiosimulator.simexp.pcm.util.PcmUtil;

public class CopyUriPreservingPartitionJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger LOGGER = Logger.getLogger(CopyPartitionJob.class);
    private final String sourcePartition;
    private final String targetPartition;

    public CopyUriPreservingPartitionJob(String sourcePartition, String targetPartition) {
        super(false);
        this.sourcePartition = sourcePartition;
        this.targetPartition = targetPartition;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        LOGGER.info((Object)("Cloning " + this.sourcePartition + " to " + this.targetPartition));
        ((MDSDBlackboard)this.getBlackboard()).removePartition(this.targetPartition);
        ResourceSetPartition orginal = (ResourceSetPartition)((MDSDBlackboard)this.getBlackboard()).getPartition(this.sourcePartition);
        PCMResourceSetPartition copy = PcmUtil.copyPCMPartition(orginal);
        ((MDSDBlackboard)this.getBlackboard()).addPartition(this.targetPartition, (Object)copy);
    }

    public String getName() {
        return "Clone Partition Contents";
    }
}

