/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.util;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.extension.AbstractExtendableJob;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.analyzer.workflow.core.jobs.PreparePCMBlackboardPartitionJob;
import org.palladiosimulator.experimentautomation.application.jobs.CopyPartitionJob;
import org.palladiosimulator.experimentautomation.application.jobs.LoadModelsIntoBlackboardJob;
import org.palladiosimulator.experimentautomation.application.jobs.PrepareBlackboardJob;
import org.palladiosimulator.experimentautomation.experiments.Experiment;
import org.palladiosimulator.simexp.pcm.util.CopyUriPreservingPartitionJob;

public class InitialPcmPartitionLoader {
    public static MDSDBlackboard loadInitialBlackboard(Experiment experiment) {
        return new InitialPcmPartitionLoaderJob(experiment).loadInitialBlackboard();
    }

    public static PCMResourceSetPartition loadInitialPcmPartition(Experiment experiment) {
        return new InitialPcmPartitionLoaderJob(experiment).loadInitialPcmPartition();
    }

    private static class InitialPcmPartitionLoaderJob
    extends AbstractExtendableJob<MDSDBlackboard> {
        public InitialPcmPartitionLoaderJob(Experiment experiment) {
            this.add((IJob)new PreparePCMBlackboardPartitionJob());
            this.add((IJob)new PrepareBlackboardJob());
            this.add((IJob)new LoadModelsIntoBlackboardJob(experiment.getInitialModel(), true));
        }

        public PCMResourceSetPartition loadInitialPcmPartition() {
            return (PCMResourceSetPartition)this.loadBlackboard().getPartition("org.palladiosimulator.pcmmodels.original.partition");
        }

        public MDSDBlackboard loadInitialBlackboard() {
            this.add((IJob)new CopyPartitionJob("org.palladiosimulator.pcmmodels.partition", "org.palladiosimulator.analyzed.partition"));
            this.add((IJob)new CopyUriPreservingPartitionJob("org.palladiosimulator.pcmmodels.partition", "org.palladiosimulator.simexp.pcm.workingpartition"));
            return this.loadBlackboard();
        }

        private MDSDBlackboard loadBlackboard() {
            MDSDBlackboard blackboard = new MDSDBlackboard();
            this.myJobs.forEach(job -> ((IBlackboardInteractingJob)job).setBlackboard((Blackboard)blackboard));
            this.myJobs.forEach(job -> {
                try {
                    job.execute((IProgressMonitor)new NullProgressMonitor());
                }
                catch (JobFailedException | UserCanceledException e) {
                    e.printStackTrace();
                }
            });
            return blackboard;
        }
    }
}

