/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.service.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.palladiosimulator.simexp.service.guice.SRPModule;
import org.palladiosimulator.simexp.service.registry.ServiceDiscovery;
import org.palladiosimulator.simexp.service.registry.ServiceEntry;

public class GuiceServiceDiscovery
implements ServiceDiscovery {
    private Injector injector;

    @Override
    public void setUp(List<ServiceEntry<?>> services) {
        ServiceEntryAllocator serviceAllocator = new ServiceEntryAllocator();
        for (ServiceEntry<?> each : services) {
            serviceAllocator.allocate(each);
        }
        this.createInjector(serviceAllocator.getModules());
    }

    private void createInjector(List<AbstractModule> modules) {
        if (!modules.isEmpty()) {
            this.injector = Guice.createInjector(modules);
        }
    }

    @Override
    public <T> Optional<T> findService(Class<T> required) {
        return this.filterBindings(required).map(r -> r.getProvider().get()).findFirst();
    }

    @Override
    public <T> List<T> findServices(Class<T> required) {
        return this.filterBindings(required).map(each -> each.getProvider().get()).collect(Collectors.toList());
    }

    private <T> Stream<Binding<T>> filterBindings(Class<T> required) {
        return this.injector.findBindingsByType(TypeLiteral.get(required)).stream();
    }

    private class ServiceEntryAllocator {
        private Map<String, AbstractModule> allocations = new HashMap<String, AbstractModule>();

        public List<AbstractModule> getModules() {
            return new ArrayList<AbstractModule>(this.allocations.values());
        }

        public <T> void allocate(ServiceEntry<T> entry) {
            String key = entry.getRequiredClass().getSimpleName();
            if (this.allocations.containsKey(key)) {
                this.allocateExistingBinding(key, entry);
            } else {
                this.allocateNewBinding(entry.getRequiredClass(), entry.getProvidedClass());
            }
        }

        private <T, U extends T> void allocateNewBinding(Class<T> required, Class<U> provided) {
            SRPModule<T, U> module = new SRPModule<T, U>(required);
            module.addProvidedClass(provided);
            this.allocations.put(required.getSimpleName(), module);
        }

        private void allocateExistingBinding(String key, ServiceEntry<?> entry) {
            ((SRPModule)this.allocations.get(key)).addProvidedClass(entry.getProvidedClass());
        }
    }
}

