/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.service.registry;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.palladiosimulator.simexp.service.registry.ServiceDiscovery;
import org.palladiosimulator.simexp.service.registry.ServiceEntry;
import org.palladiosimulator.simexp.service.registry.ServiceProvider;
import org.palladiosimulator.simexp.service.registry.ServiceRegistration;

public enum ServiceRegistry implements ServiceDiscovery,
ServiceRegistration
{
    INSTANCE;

    private static final Logger LOGGER;
    private static final String SERVICE_REGISTRY_ID = "org.palladiosimulator.simexp.service.serviceregistry";
    private final List<ServiceEntry<?>> register = new ArrayList();

    static {
        LOGGER = Logger.getLogger((String)ServiceRegistry.class.getName());
    }

    @Override
    public void setUp(List<ServiceEntry<?>> services) {
    }

    @Override
    public <T> Optional<T> findService(Class<T> requiredClass) {
        for (ServiceEntry<?> each : this.register) {
            if (!each.getRequiredClass().equals(requiredClass)) continue;
            return Optional.ofNullable(this.toServiceImpl(each));
        }
        return Optional.empty();
    }

    @Override
    public <T> List<T> findServices(Class<T> requiredClass) {
        ArrayList<T> results = new ArrayList<T>();
        for (ServiceEntry<?> each : this.register) {
            if (!each.getRequiredClass().equals(requiredClass)) continue;
            results.add(this.toServiceImpl(each));
        }
        return results;
    }

    private <T> T toServiceImpl(ServiceEntry<?> serviceEntry) {
        T result = null;
        try {
            result = (T)serviceEntry.getProvidedClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.error((Object)String.format("Failed to provide service implementation for service '%s'", serviceEntry.getProvidedClass().getName()), (Throwable)e);
        }
        return result;
    }

    private ServiceRegistry() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.registerProvider(registry);
    }

    public static ServiceDiscovery get() {
        return INSTANCE;
    }

    private void registerProvider(IExtensionRegistry registry) {
        IConfigurationElement[] config = registry.getConfigurationElementsFor(SERVICE_REGISTRY_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object providerClass = e.createExecutableExtension("class");
                if (providerClass instanceof ServiceProvider) {
                    ServiceProvider serviceProvider = (ServiceProvider)providerClass;
                    serviceProvider.register(this);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new RuntimeException("registration failure", e);
        }
    }

    @Override
    public void registerService(ServiceEntry<?> serviceToRegister) {
        this.register.add(serviceToRegister);
    }
}

