/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.ui.workflow.config;

import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import java.util.Arrays;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.sideeffect.ISideEffect;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.validation.CompoundStringValidator;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.validation.ExtensionValidator;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.validation.FileURIValidator;

public class EditRepositoryDialog
extends InputDialog {
    private final String type;
    private final String[] extension;
    private final String initialValue;
    private final DataBindingContext ctx;
    private IObservableValue<String> model;

    public EditRepositoryDialog(Shell parentShell, String title, String type, String[] extension) {
        this(parentShell, title, type, extension, null);
    }

    public EditRepositoryDialog(Shell parentShell, String title, String type, String[] extension, String initialValue) {
        super(parentShell, title, title, "", null);
        this.type = type;
        this.extension = extension;
        this.ctx = new DataBindingContext();
        this.initialValue = initialValue;
    }

    public boolean close() {
        this.ctx.dispose();
        return super.close();
    }

    public String getRepositoryModelUri() {
        return (String)this.model.getValue();
    }

    protected Control createDialogArea(Composite parent) {
        ModifyListener modifyListener = e -> {};
        Composite container = (Composite)super.createDialogArea(parent);
        TabHelper.createFileInputSection((Composite)container, (ModifyListener)modifyListener, (String)this.type, (String[])this.extension, (Text)this.getText(), (String)("Select " + this.type), (Shell)this.getShell(), (boolean)true, (boolean)true, (String)"");
        ISWTObservableValue target = WidgetProperties.text((int)24).observe((Widget)this.getText());
        Data data = new Data();
        this.model = PojoProperties.value((String)"repositoryUri", String.class).observe((Object)data);
        UpdateValueStrategy updateValueStrategy = new UpdateValueStrategy();
        updateValueStrategy.setBeforeSetValidator((IValidator)new CompoundStringValidator(Arrays.asList(new FileURIValidator(this.type), new ExtensionValidator(this.type, this.extension[0]))));
        Binding allocationBindValue = this.ctx.bindValue((IObservableValue)target, this.model, updateValueStrategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)allocationBindValue, (int)131200);
        return container;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        AggregateValidationStatus aggregateValidationStatus = new AggregateValidationStatus((IObservableCollection)this.ctx.getBindings(), 2);
        ISideEffect.create(() -> {
            IStatus status = (IStatus)aggregateValidationStatus.getValue();
            if (status.isOK()) {
                return null;
            }
            return String.format("Error: %s", status.getMessage());
        }, arg_0 -> ((EditRepositoryDialog)this).setErrorMessage(arg_0));
        this.model.setValue((Object)this.initialValue);
        return contents;
    }

    private static class Data {
        private String repositoryUri;

        private Data() {
        }

        public String getRepositoryUri() {
            return this.repositoryUri;
        }

        public void setRepositoryUri(String repositoryUri) {
            this.repositoryUri = repositoryUri;
        }
    }
}

